#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <string.h>
#include "local.h"
#include "socket.h"

FILE *log;

extern int h_errno;

int
GetPortOption(line)
char *line;
{
char *temp;
char temp2[8192];
char templine[8192];

strcpy(templine,line);

temp = strstr(templine," -p ");
fflush(stdout);

if(temp)
	{
	strcpy(temp2,getBlankedString(temp,2));
	return(i_convert(temp2));
	};

return -1;
fflush(stdout);
}

char *GetLastInLine(line)
char *line;
{
static char temp2[8192];
char temp[8192];
int i,j,o,p,l;

for(i = 0; i < strlen(line); i++)
	if(line[i] == '\n')
		{
		for(l = 0, j = i; j > 0; j--,l++)
			if(line[j] == ' ')
				{
				temp[l] = '\0';
				for(o = 0, p = l-1; p > 0; p--,o++)
					temp2[o] = temp[p];	
				temp2[strlen(temp)-1] = '\0';
				return temp2;
				}
			else temp[l] = line[j];
		};
}

/* This will probably only happen for gopherd's but for now all are checked.. */
KillProcess(line,server)
char *line;
struct serv server;
{
FILE *fp;
char *serverid;
char processes[1024];
char grepstring[1024];
char killstring[1024];
char *procid;
int serverport;


switch(server.id) {
	case GOPHER :	/* It's a Gopher! */
			sprintf(grepstring,"ps waux | grep \"waiting for connection @ %d\" | grep -v grep | grep -v sh ",server.port);
			break;
	default :	
			sprintf(grepstring,"ps waux | grep %s | grep %d | grep -v grep | grep -v sh ",server.name,server.port);
};

fp = popen(grepstring,"r");
processes[0] = '\0';

while(!feof(fp) && (fgets(processes,1023,fp) != NULL))
	{
	if(processes[0] != '\0'){
	printf("processes %s\n",processes);
	procid = getBlankedString(processes,2);
	}
	}
if(procid) {
if(isdigit(procid[0])) {
sprintf(killstring,"kill -9 %s",procid);	
printf("killstring : %s\n",killstring);
system(killstring);
}
}

fclose(fp);
}

int ResetRCLocalEntry(server,line)
struct serv server;
char *line;
{
char time[256];
int port,tmpport;

strcpy(time,current_time());
 
fprintf(stderr,"%s Resetting : %s @ %d\n",time,server.name,server.port);
fprintf(log,"%s Resetting : %s @ %d\n",time,server.name,server.port);
fflush(log);

KillProcess(line,server); /* This will probably only do something for gopherd's */

system(line); /* Call the same routine for starting server as is in rc.local */
}

int IsAValidServer(line,server)
char *line;
struct serv *server;
{
int i;
int port;
char *temp;

strcpy(server->name,getBlankedString(line,1));
temp = strrchr(server->name,'/');

if(temp) /* is it a fullyqualified  path.. */
temp++;
else return 0; /* it's not so it could be a shell command i.e. echo */



for(i = 0; i < SERVERTYPES; i++)
{
	if(!strcmp(temp,(SERVERITEM[i]->name)))
			{
			server->id = SERVERITEM[i]->id;
			strcpy(server->name,(SERVERITEM[i]->name));
			switch(server->id) {
        		case  GOPHER : server->port = GetGopherPort(line);
                        		break;

        		default  :
                       			port = GetPortOption(line);
                        		if(port == -1) /* use default */
                                		server->port = SERVERITEM[i]->port;
					else server->port = port;

			}
       
			
			return 1;
			}
};
return 0;
}

int GetGopherPort(line)
char *line;
{
char *last;
int Port;

Port = 70; /* Set the default .. */

last = GetLastInLine(line);

if(isdigit(last[0]))
	Port = i_convert(last);
return Port;
}


/* Check if server is responding at the specified port */

int PingServer(server)
struct serv server;
{
int s;
struct sockaddr_in sin;
struct servent *ps;
struct hostent *ph;
char host[256];
int len;
long address;
int port,tmpport;
char time[256];

gethostname(host,256);

port = htons(server.port);

printf("name : %s\nid : %d\nport : %d\n",server.name,server.id,server.port);
fflush(stdout);

 if(isdigit(host[0])) {
                if((address = inet_addr(host)) == -1) {
                        fprintf(stderr,"%s : invalid host name\n",host);
                        return -1;
                        }
                sin.sin_addr.s_addr = address;
                sin.sin_family = AF_INET;
        }
        else if((ph = gethostbyname(host)) == NULL) {
                switch(h_errno) {
                        case    HOST_NOT_FOUND:
                                fprintf(stderr,"Host %s not found.\n",host);
                                return -1;
                        case    TRY_AGAIN:
                                fprintf(stderr,"Try again later.\n");
                                return -1;
                        case    NO_RECOVERY:
                                fprintf(stderr,"Host %s DNS error.\n",host);
                                return -1;
                        case    NO_ADDRESS:
                                fprintf(stderr,"No IP address for %s.\n",host);
                                return -1;
                        default:
                                fprintf(stderr,"Unknown error.\n");
                                return -1;
 			}
	}
        else {
                sin.sin_family = ph->h_addrtype;
                bcopy(ph->h_addr,(char *) & sin.sin_addr, ph->h_length);
       }
        sin.sin_port = port;

	/* Open a socket ... */
        if((s = socket(AF_INET,SOCK_STREAM,0)) < 0) {
                fprintf(stderr,"Cannot open socket");
                return -1;
        	}

/* Connect to server ... */
if(connect(s,(struct sockaddr *) & sin, sizeof(sin)) < 0) {
		printf("Can't do it Capt'n!\n");
		fflush(stdout);
		strcpy(time,current_time());
        	fprintf(stderr,"%s Cannot connect %s @ %d\n",time,server.name,server.port);
        	fprintf(log,"%s Cannot connect %s @ %d\n",time,server.name,server.port);
		fflush(stderr);
		fflush(log);

		close(s);
		/* Can't connect to server, must be down.. */
                return 0;
		}
	else printf("Connected to port\n");
close(s);
		
/* Did everything right so server is assumed to be ok.. */
return 1;
}

int ParseRCLocal()
{
FILE *fp;
char line[8192];
char temp[8192];
char arg1[1024],arg2[1024],arg3[1024];
struct serv serverinfo;
char time[256];

strcpy(time,current_time());

if(!(fp = fopen(RCLOCAL,"r")))
	{
	fprintf(stderr,"Couldn't open : %s\n",RCLOCAL);
	exit(1);
	};

log = fopen(LOGFILE,"A+");

while(!(feof(fp)) && (fgets(line,8191,fp) != NULL))
{
strcpy(arg1,getBlankedString(line,1));  /* Get the first column's entry */

if(!(strcmp(arg1,"if") || !(strcmp(arg1,"[")))) /* check if file check line */
{
/* It's a test line .. */
}
else if(line[0] == '#')
	{
	/* It's a comment */
	}
else {
	if(IsAValidServer(line,&serverinfo))
		{
		if(PingServer(serverinfo))
			{
			/*
			fprintf(stderr,"%s server's ok : %s\n",time,line);
			fprintf(log,"%s server's ok : %s\n",time,line);
			*/
			}
			else /* Server is not responding */
				ResetRCLocalEntry(serverinfo,line);	
		};
	};
}

fclose(fp);
fclose(log);
}

