/*************************************************************************/
/*      Example File for testing the Data Compression Library            */
/*  Compiled with WATCOM C                                               */
/*                                                                       */
/*  READ THE 'README.TXT' FILE BEFORE USE !                              */
/*                                                                       */
/*  The author makes no warranty of any kind, expressed or implied,      */
/*  with regard to this program and the Data Compression Library.        */
/*  The author shall not be liable for any loss or damages resulting     */
/*  from the use of any of the programs supplied.                        */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*  This program Loads in a file to RAM.                                 */
/*  Compresses it, decompresses it, and saves result                     */
/*************************************************************************/

#include <stdio.h>                                              
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>

#include "dcl_386.h"                     // The Data Compression Library Header

#define BYTE unsigned char              // Makes Life a little easier


void main(int argc,char *argv[])
{
  BYTE *source_data;                    // pointer to raw data
  BYTE *compressed_data;                // pointer to compressed data
  
  unsigned int flength;                 
  int hndl;
 
  
  printf("\n\nData Compression Library Test\n");

  if(argc!=3) {
	printf("COPYRIGHT Dani Arrusi 1995\n");
	printf("SYNTAX : example <input file> <output file>\n\n");
	exit(0);
  }

  /////////////////////////////////// 
  /* The first thing we need to do is allocate some space for the compression
     buffers. The first parameter is the uncompressed(source) buffer size
     in bytes, the second parameter is the compressed (destination) buffer
     size in bytes. See Documentation For details.                         */

  if(DCL_init_compress(20000,20000)==NULL) {
     printf("Cannot Allocate Memory for Compression Buffers\n");
     exit(1);
  }
  ///////////////////////////////////

  ///////////////////////////////////
  // Load in a file to memory 
  if((hndl=open(argv[1],O_RDONLY | O_BINARY))==-1) {
	printf("File '%s' not found\n",argv[1]);
	exit(0);
  }
  if(filelength(hndl)>20000) {
	printf("\nFile too big to fit into buffers\n");
	printf("Edit 'example.c' and modify 'DCL_init_compress'\n");
	printf("See documentation in 'readme.txt' for further details\n\n");
	exit(1);
  }
  source_data=(BYTE *)malloc(filelength(hndl));
  if(source_data==NULL) {
	printf("Cannot allocate ram for input file\n");
	exit(1);
  }  
  read(hndl,source_data,filelength(hndl));
  flength=filelength(hndl);
  close(hndl);
  printf("Original File = %d Bytes\n\n",flength);
  ///////////////////////////////////

  ///////////////////////////////////
  // Compress and Decompress

  printf("Compressing file \n");
  
  // compress the ram data
  compressed_data=DCL_shrink(source_data,&flength);     
  
  // we can now loose the original uncompressed file data
  free(source_data);
  
  // Show how big the compressed data is
  printf("Compressed file = %d Bytes\n\n",flength);

  // Uncompress the data
  printf("Expanding Compressed File\n");
  
  source_data=DCL_expand(compressed_data,&flength);
    
  printf("Expanded File = %d Bytes\n",flength);
  /////////////////////////////////////

  /////////////////////////////////////
  // Save out new uncompressed data
  
  printf("Saving new data as '%s'\n",argv[2]);
  hndl=open(argv[2], O_WRONLY | O_CREAT | O_BINARY | O_TRUNC , S_IREAD | S_IWRITE);
  write(hndl,source_data,flength);
  close(hndl);
  /////////////////////////////////////

  /////////////////////////////////////
  // De initialise Compression buffers
  DCL_close_compress();       // deallocates 'static' input and output buffers
  //////////////////////////////////////
 
}
