Unit ToolBox;

Interface

Uses Dos,Crt;

Function  WildMatch (Name,WName : NameStr; Ext, WExt : ExtStr) : Boolean;
Function  FileExists (Filename : String) : Boolean;
Function  Upper (Text : String) : String;
Procedure Commas (Var Text : String);
Function  TimeString (LTime : Longint) : String;

Implementation

{ Matches a filename with a wildcard }
{ }
Function WildMatch (Name,WName : NameStr; Ext, WExt : ExtStr) : Boolean;
Var
 Match : Boolean;
 Star  : Boolean;
 L     : Byte;
Begin
 Match := True;

 Star  := False;
 L := 1;
 While (L<=Length(WName)) AND (L<=Length(Name)) Do Begin
  Star  := Star OR (WName[L]='*');
  Match := Match AND (Star OR (WName[L]='?') OR (WName[L]=Name[L]));
  INC(L);
 End;
 If NOT Star Then Match := Match AND (WName[0]=Name[0]);
 IF Match Then Begin
  Star  := False;
  L := 1;
  While (L<=Length(WExt)) AND (L<=Length(Ext)) Do Begin
   Star  := Star OR (WExt[L]='*');
   Match := Match AND (Star OR (WExt[L]='?') OR (WExt[L]=Ext[L]));
   INC(L);
  End;
  If NOT Star Then Match := Match AND (WExt[0]=Ext[0]);
 End;

 WildMatch := Match;
End;

{ Converts a string into uppercase }
{ }
Function Upper (Text : String) : String;
Var
 L : Byte;
Begin
 If Length(Text)>0 Then For L:=1 To Length(Text) Do Text[L] := UpCase(Text[L]);
 Upper := Text;
End;

{ Insert commas every three digits from the left }
{ }
Procedure Commas (Var Text : String);
Var
  Count : Byte;
Begin
 { Remove leading blanks }
 While (Length(Text)>0) And (Text[1]=' ') Do Delete (Text,1,1);
 { Insert commas }
 Count := Length (Text)+1;
 While Count>4 Do Begin
  Dec (Count,3);
  Insert (',',Text,Count);
 End;
End;

{ Converts a time in packed DOS format into a string }
{ }
Function TimeString (LTime : Longint) : String;
Var
 ATime : DateTime;
 { }
 Function LeadZero(Number : Word):String;
 Var
  S : String;
 Begin
  Str(Number:2,S);
  If S[1]=' ' Then S[1]:='0';
  LeadZero := S;
 End;
 { }
Begin
 UnpackTime (LTime,ATime);
 TimeString := LeadZero(ATime.Day)+'/'+LeadZero(ATime.Month)+'/'+LeadZero(ATime.Year MOD 100)+' '+
               LeadZero(ATime.Hour)+':'+LeadZero(ATime.Min)+':'+LeadZero(ATime.Sec);
End;

Function FileExists (Filename : String) : Boolean;
Var
 S : SearchRec;
Begin
 Dos.FindFirst(Filename,Archive,S);
 FileExists := ((DosError=0) AND (S.Size>0));
 DosError := 0;
End;

{ === }

Begin
End.
