{ TEST program for the ZIP File System unit (ZFS) - Ivn Montes Velencoso

   WWW : http://members.tripod.com/imontes/
   e-mail : drslump@axis.org

      Needs an external file called TEST.ZIP that contains three graphic
      pictures called CYCLONE.RAW that is compressed using the SHRINK
      method, CYCLO.RAW that uses the INFLATED method and DIABOLO.RAW that
      is stored with no compression.
}

{$IFNDEF GO32V2}
{$STOP Sorry but this example only works for the go32 v2 target}
{$ENDIF}

{$ASMMODE intel}   {Intel assembler syntax}

uses crt, dos, zfs, go32;

var
  i         :longint;               {counter}
  perc      :byte;                  {percentage of compression}

  pack1     :pZIP;                  {ZIP archives}

  tmpDir    :pMEMDir;               {Temporal for listing of files}
  tmpPack   :pZIP;                  {Temporal for listing of files}

  ff        :file;                  {file handler}
  pp        :pointer;               {temporal buffer for picture loading}

  timer :longint absolute $40:$6c;  {system clock}
  time1,
  time2     :longint;               {for calculate the time spended}

  dt        :datetime;


begin
  ClrSCR;

  WriteLN(' ZiP File System - Test Program 01');
  WriteLN('.-------------------------------.');
  WriteLN;

  WriteLN('# Free memory before initialize ', MEMAVAIL SHR 10, ' kb');

  pack1:=OpenZIP ('TEST.ZIP', NORMALMODE); {Opens a ZIP file in normal mode}
  if IOResult<>0 then  {There is an error!}
   begin
     WriteLN('Error oppening the ZIP file');
     Halt;
   end;

  WriteLN('# ', pack1^.Name, ' opened.');

  WriteLN('# Free memory after initialize  ', MEMAVAIL SHR 10, ' kb');
  WriteLN;
  WriteLN('-Press a key-');
  readkey;


  {Shows all the files inside the openned ZIP files}
  tmpPack:=FirstZIP;
  REPEAT
    ClrScr;
    TextBackground(Blue);
    WritelN('Num.':4,'  ','Name':25,'  ','Position':8,'  ','size':6,'  ','real size':11,'  ','percent':8);
    TextBackground(Black);
    i:=0;
    tmpDir:=tmpPack^.FirstMemDir;
    REPEAT
      perc:=100-((tmpdir^.obj.size*100) div tmpdir^.obj.usize);
      WritelN(i+1:4,'  ',tmpdir^.Obj.Nom:25,'  ',tmpdir^.obj.Pos:8,'  ',tmpdir^.obj.size:6,'  ',tmpdir^.obj.usize:11,'  ',perc:7,'%');
      UnPackTime(tmpdir^.Obj.Time, dt);
{      WriteLN('date : ', dt.Day,'-',dt.Month,'-',dt.Year);
      WriteLN('time : ', dt.Hour,':',dt.Min,',',dt.Sec);
      inc(i,2);}

      inc(i,1);
      if (i mod 23)=0 then
       begin
         readkey;
         ClrSCR;
         TextBackground(Blue);
         WritelN('Num.':4,'  ','Name':25,'  ','Position':8,'  ','size':6,'  ','real size':11,'  ','percent':8);
         TextBackground(Black);
       end;
      tmpDir:=tmpDir^.Next;
    UNTIL tmpDir=NIL;

    WriteLN('-Press a key-');
    readkey;
    tmpPack:=tmpPack^.Next;
  UNTIL tmpPack=NIL;

  {If you put here 'DIABOLO.RAW' you will load an stored file,
   if you put 'CYCLONE.RAW' you will load a Shrunk one and
   if you put 'GFX\CYCLO.RAW' you will load an Inflated one}
  Assign(ff, 'GFX\CYCLO.raw');  {We open a file}
  reset(ff,1);
  If IOResult<>0 then {There is an error!}
   begin
     WriteLN('Error while openning a file');
     HALT;
   end;

  {If it's on disk we display a message showing so}
  if filerec(ff).mode<>fmZipped then
   begin
     WriteLN('File found outside a ZIP file, so we use it');
     WriteLN('-Press a key-');
     readkey;
   end;

  Getmem(pp, filesize(ff));      {allocates the needed memory for the buffer}

  //seek(ff, 32000);

  time1:=timer;                       {starts the timming}
  BlockRead(ff, pp^, filesize(ff));   {Decompress the file into the buffer}
  time2:=timer;                       {stops the timming}
  if IOResult<>0 then
   begin
     WriteLN('ERROR reading the file : ',IOResult);
     halt;
   end;

  WriteLN;
  WriteLN(' File info');
  WriteLN('.-------.');
  WriteLN('Name             : ', filerec(ff).name);
  WriteLN('Size             : ', filesize(ff), ' bytes');
  WriteLN('Current Position : ', filepos(ff));
  WriteLN;
  writeLN('-Press a key-');
  readkey;

  asm mov ax, 13h; int 10h; end;  {Sets the VGA 320x200x256 standard mode}

  for i:=0 to 255 do              {Sets a magenta shaded palette}
   begin
     OutPortb($3c8, i);
     OutPortb($3c9, i shr 2);
     OutPortb($3c9, 0);
     OutPortb($3c9, i shr 2);
   end;

  asm                {Flips the buffer into the VGA Ram}
    push es                        {Saves ES selector}
    mov  es,  DosMemSelector       {ES points to the DOS <1MB memory}
    mov  edi, $a0000               {VGA Ram addres}
    mov  esi, pp
    mov  ecx, 64000/4
    rep  movsd                     {copy the buffer}
    pop  es                        {Restore the ES selector}
  end ['ECX','EDI','ESI'];

  readkey;                         {waits for a keypress}
  asm mov ax, 03h; int 10h; end;   {puts the Text mode}


  FreeMem(pp, filesize(ff));      {Frees the buffer memory}

  Close(ff);                      {Closes the open file}

{  CloseZIP(pack1); }       {It will be closed automatically when exit}
  WriteLN('TIME : ', ((time2-time1)/18.2):8:3, ' seconds');
end.
