{
TEST program for the ZIP File System unit (ZFS) that works with win32.
It generates the same screen that TEST.PAS only that this stores it in a
raw format file called 'OUT.RAW' with a resolution of 320x200 pixels with
256 colours. It can be view with many advanced image viewers and with
Photoshop.

   WWW : http://members.tripod.com/imontes/
   e-mail : drslump@axis.org

      Needs an external file called TEST.ZIP that contains two graphic
      pictures called CYCLONE.RAW that is compressed using the SHRINK
      method and DIABOLO.RAW that is stored with no compression.
}
PROGRAM ZFS_TEST_W32;

uses zfs;

var
  i:longint;                         {counter}

  pack1, pack2, pack3 :pZIP;
  tmpDir  :pMEMDir;
  tmpPack :pZIP;
  fi, fo :file;                       {file handler}

  pp :pointer;                       {buffer}

  tb:byte;tw:word;tl:longint;
  direc:longint;

begin
  WriteLN(' ZiP File System - Test Program. Special for Win32');
  WriteLN('.-----------------------------------------------.');
  WriteLN;
  WriteLN('# Free memory before initialize ', MEMAVAIL SHR 10, ' kb');

  pack1:=OpenZIP ('TEST.ZIP', FALSE);   {Opens the ZIP file}
  if IOResult<>0 then
   begin
     WritELN('Error Openning a ZIP file : ',IOResult);
     HALT;
   end;

  WriteLN('# Free memory after initialize  ',MEMAVAIL SHR 10, ' kb');
  WriteLN;

  {If you put here the file 'DIABOLO.RAW' you will load an stored file while
  if you put 'CYCLONE.RAW' you will load a Shrunk one.
  If you put 'GFX\CYCLO.RAW' you'll load a deflated one}
  Assign(fi, 'CYCLONE.RAW');  {We open a file}
  Reset(fi,1);
  If IOResult<>0 then
   begin
     WriteLN('Error while openning a file : ',IOResult);
     HALT;
   end;

  Getmem(pp, filesize(fi));      {allocates the needed memory for the buffer}

  BlockRead(fi, pp^, filesize(fi));   {Decompressed the file into the buffer}
  if IOResult<>0 then
   begin
     WriteLN('Error uncompressing the file : ', IOResult);
     halt;
   end;

  {Creates a new file with the image data}
  system.assign(fo, 'out.raw');
  system.rewrite(fo,1);
  if system.IOresult=0 then
   begin
     system.BlockWrite(fo, pp^, filesize(fi));
     if system.IOResult<>0 then
      begin
        WriteLN('Error writing OUT.RAW');
        halt;
      end;
   end
  else
   begin
     WriteLN('Error creating OUT.RAW');
     halt;
   end;
  system.close(fo);


  FreeMem(pp, filesize(fi));      {Frees the buffer memory}

  Close(fi);                  {Closes the open file}

  {All the opened ZIP files will be closed automaticly when programs exits}
end.
