#include <stdio.h>
#include <dos.h>

#define pitfreq 1193181    /* Ticks per second */

int volatile timecounter;
int volatile clock_ticks;
void (__interrupt __far *oldint8)();

SetTimerCount(int freq)
{
  outp(0x43, 0x36);
  outp(0x40, freq & 0xff);
  outp(0x40, freq >> 8);
}

void __interrupt __far timerint()
{
  timecounter++;
  clock_ticks += pitfreq / 1000;
  if (clock_ticks >= 0x10000) {
    clock_ticks -= 0x10000;
    _chain_intr(oldint8);
  } else
    outp(0x20, 0x20); /* Acknowledge interrupt */
}

StartTimer()
{
  timecounter = 0;
}

WaitFor(int ticks)
{
  while (ticks > timecounter)  
    ;
}

InitTimer()
{
    _disable();                /* cli */
    oldint8 = _dos_getvect(8); 
    _dos_setvect(8, timerint);
    _enable();                 /* sti */
    clock_ticks = 0;
    SetTimerCount(pitfreq / 1000); /* Set freq */
}

RestoreTimer()
{
    SetTimerCount(0);                   /* Restore original timerfrequence */
    _disable();
    _dos_setvect(8, oldint8);
    _enable();
}