{ Set Video Mode for ET4000 }

uses Txt;

{  SetVideoMode  }
procedure SetVideoMode(X,Y:integer);    { 55x18 }
const
  Mode:array[0..23] of byte=(
    $01,$03,$05,$06,$07,$0D,$0E,$0F,$10,$11,$12,$13,
    $22,$23,$24,$26,$29,$2A,$2D,$2E,$2F,$30,$37,$38);
  St:array[0..23] of string[19]=(
    'Text   40x 25,  16C','Text   80x 25,  16C',
    'CGA   320x200,   4C','CGA   640x200,   2C',
    'Text   80x 25, Mono','EGA   320x200,  16C',
    'EGA   640x200,  16C','EGA   640x350,   2C',
    'EGA   640x350,  16C','VGA   640x480,   2C',
    'VGA   640x480,  16C','VGA   320x200, 256C',
    'Text  132x 44,  16C','Text  132x 25,  16C',
    'Text  132x 28,  16C','Text   80x 60,  16C',
    'SVGA  800x600,  16C','Text  100x 40,  16C',
    'SVGA  640x350, 256C','SVGA  640x480, 256C',
    'SVGA  640x400, 256C','SVGA  800x600, 256C',
    'SVGA 1024x768,  16C','SVGA 1024x768, 256C');
var P,K:integer;
    Buf:pointer;
begin
  if Mem[0:$449]<>3 then begin VideoMode(3); TextMem:=Ptr($B800,0); end;
  GetMem(Buf,4000);
  GetText(X,Y,56,19,Buf^);
  TextWindow1(X,Y,55,18,$17,$17,1,'');
  TextBar(X+1,Y+2,53,1,$13,'');
  PrintText(X+4,Y+1,$1F,'VMode for ET4000  (C) 1994 by Jou-Nan Chen');
  for P:=0 to 23 do begin
    PrintText(X+4+25*(P div 12),Y+4+P mod 12,$1B,HexByte(Mode[P]));
    PrintText(X+7+25*(P div 12),Y+4+P mod 12,$1E,St[P]);
  end;
  P:=1;
  repeat
    PrintText(X+3+25*(P div 12),Y+4+P mod 12,$2F,' '+HexByte(Mode[P]));
    PrintText(X+6+25*(P div 12),Y+4+P mod 12,$2E,' '+St[P]+' ');
    K:=Key;
    PrintText(X+3+25*(P div 12),Y+4+P mod 12,$1B,' '+HexByte(Mode[P]));
    PrintText(X+6+25*(P div 12),Y+4+P mod 12,$1E,' '+St[P]+' ');
    case K of
      $4800:Dec(P);    $5000:Inc(P);       { Up,Down }
      $4B00:Dec(P,12); $4D00:Inc(P,12);    { Left,Right }
      $4700:P:=0;      $4F00:P:=23;        { Home,End }
    end;
    if P<0  then Inc(P,24);
    if P>23 then Dec(P,24);
  until (K=$1C0D) or (K=$011B);            { Enter,Esc }
  PutText(X,Y,56,19,Buf^);
  FreeMem(Buf,4000);
  if K=$1C0D then VideoMode(Mode[P]);
end;

var V,I:integer;

begin
  if ParamCount=0 then SetVideoMode(13,4) else begin
    Val(ParamStr(1),V,I);
    if (ParamCount=1) and (I=0) then VideoMode(V) else begin
      Writeln;
      Writeln('VMode for ET4000  (C) 1994 by Jou-Nan Chen');
      Writeln('Usage: VMode Mode_Number  or  VMode');
      Halt(1);
    end;
  end;
end.
