;Falling Dots - Written by Tanis of Cleria
;You can get in touch with me thru my e-mail on internet:
;tanis@illusion.shiny.it
;22 - September - 1995
;Working version.

DOSSEG
.MODEL SMALL
.STACK 200h
.DATA



.CODE

MAIN_CODE:
		call	initialize
		xor	cx,cx
Start:
		CALL	putimage
start2:
		inc	cx
		cmp	cx,65535
		je	start3
		IN	AL,60h
		CMP	AL,1
		JNE	start2
		MOV	AX,4C00H
		INT	21H
start3:
		call	main
		in	al,60h
		cmp	al,1
		jne	start3
		mov	ax,4c00h
		int	21h




PALETTE LABEL byte
INCLUDE ABYSS.PAL

IMAGE LABEL BYTE
INCLUDE ABYSS.RAW

;
;INITIALIZES VGA SCREEN IN 320X200X256 CHAINED MODE
;

	InitVGA	proc
    		mov ax,13h
		int 10h
    		mov ax,0a000h
    		MOV ES,AX
		ret
	InitVGA endp

;
;DRAWS A PIXEL OF COLOUR C AT COORDINATES X,Y
;


; IN :  AX <- Y
;	BX <- X
;	DL <- Colour

	PIX	PROC
  		shl ax, 8  ;{ax <- y*256}
  		mov di, ax ;{di <- y*256}
  		shr di, 2  ;{di <- y*256/2}
  		add di, ax
  		add di, bx
		mov al,dl ; <- Colour
  		MOV ES:[DI],AL
		ret
	PIX	ENDP

;
;WAITS FOR VERTICAL RETRACE
;

;Procedure WVRT;
	WVRT	PROC
      		mov dx,03dah
     	@l1:
      		in al,dx
      		test al,8
      		jnz @l1
     	@l2:
      		in al,dx
      		test al,8
      		JZ @L2
		ret
	WVRT	ENDP

;
;SETS THE PALETTE
;

	SETPAL	PROC
		MOV	CX,255
		mov	di,0
	setpal1:
		xor	ax,ax
		mov	dx,03c8h
		mov	al,palette[di]
		out	dx,al
		inc	dx
		MOV	AL,PALETTE[di+1]
		OUT	DX,AL
		MOV	AL,PALETTE[di+2]
		OUT	DX,AL
		MOV	AL,PALETTE[di+3]
		out	dx,al
		add	di,4
		loop	setpal1
		ret
	SETPAL	ENDP

;


POINTTYPE	struc
	X		Dw	0
	y		dw	0
	INCX		Dw	0
	incy		dw	0
	C		DB	0
	ACTIVE		DB	0
pointtype	ENDS

PO	POINTTYPE	4264 DUP(<>)

K1      DW      9821
k2      dw      1

SEED    DW      4263

;
;RANDOM NUMBER GENERATOR
;

;This random-number generator routine is taken from "Mental Surgery" sources
;by Future Crew. (Big thanks to all of 'em!)

seed1	dw	1234
seed2	dw	5678
seed3	dw	1234h
seed4	dw	5678h

rand2	PROC	NEAR
	push	bx
	push	cx
	push	dx
	mov	ax,cs:seed1
	mov	bx,cs:seed2
	mov	cx,cs:seed3
	mov	dx,cs:seed4
	add	ax,bx
	rol	ax,cl
	xor	ax,dx
	xchg	cl,ch
	add	bx,cx
	add	dx,bx
	add	cx,ax
	ror	bx,1
	sbb	ax,dx
	mov	cs:seed4,dx
	mov	cs:seed3,dx
	mov	cs:seed2,dx
	mov	cs:seed1,ax
	pop	dx
	pop	cx
	pop	bx
	ret
rand2	ENDP

;
;INITIALIZES POINTS POSITION FROM THE "ABYSS" IMAGE
;

initp	proc	near
	mov	di,0
	mov	si,0
	xor	bx,bx
	xor	bp,bp
	mov	cx,24
@yeah2:
	push	cx
	mov	cx,163
@yeah1:
	push	cx
	mov	[po.x+di],bp
	add	[po.x+di],60
	mov	[po.y+di],bx
	add	[po.y+di],40
	call	rand2
	and	ax,3
	mov	[po.incx+di],ax
	call	rand2
	and	ax,3
	mov	[po.incy+di],ax
	call	rand2
	and	ax,1
	cmp	ax,1
	jne	@noswitch
	xor	ax,ax
	sub	ax,[po.incx+di]
	mov	[po.incx+di],ax
@noswitch:
	call	rand2
	and	ax,1
	cmp	ax,1
	jne	@noswitch2
	xor	ax,ax
	sub	ax,[po.incy+di]
	mov	[po.incy+di],ax
@noswitch2:
	mov	[po.active+di],1
	mov	al,[image+si]
	mov	[po.c+di],al
	add	di,10
	inc	si
	pop	cx
	inc	bp
	loop	@yeah1
	pop	cx
	inc	bx
	xor	bp,bp
	loop	@yeah2
	ret
initp	endp

;
;CALCULATES POINTS POSITION FOR EVERY FRAME
;

;IN:	DI <- Number of current point * 10 (vector's length)..

DOC PROC NEAR
	mov	ax,[po.x+di]
	add	ax,[po.incx+di]
	mov	[po.x+di],ax
	cmp	ax,319
	jle	@bound1
	mov	ax,319
	mov	[po.x+di],ax
	xor	ax,ax
	sub	ax,[po.incx+di]
	mov	[po.incx+di],ax
@bound1:
	mov	ax,[po.x+di]
	cmp	ax,0
	jGE	@bound2
	mov	ax,0
	mov	[po.x+di],ax
	xor	ax,ax
	sub	ax,[po.incx+di]
	mov	[po.incx+di],ax
@bound2:
	mov	ax,[po.y+di]
	add	ax,[po.incy+di]
	mov	[po.y+di],ax
	mov	ax,[po.y+di]
	cmp	ax,199
	jle	@bound3
	mov	ax,199
	mov	[po.y+di],ax
	xor	ax,ax
	sub	ax,[po.incy+di]
	inc	ax
	mov	[po.incy+di],ax
@bound3:
	mov	ax,[po.y+di]
	cmp	ax,0
	jge	@bound4
	xor	ax,ax
	mov	[po.y+di],ax
	xor	ax,ax
	sub	ax,[po.incy+di]
	mov	[po.incy+di],ax
@bound4:
	mov	ax,[po.incy+di]
	inc	ax
	mov	[po.incy+di],ax
	mov	ax,[po.y+di]
	mov	bx,[po.incy+di]
	cmp	ax,199
	jne	@bound5
	cmp	bx,0
	jne	@bound5
	mov	dl,0
	mov	[po.active+di],dl
@bound5:
	ret
doc	endp

;
;PUTS THE "ABYSS" IMAGE ON SCREEN
;

putimage	proc	near
	xor	di,di
	mov	cx,4263
@put1:
	mov	bx,[po.x+di]
	mov	ax,[po.y+di]
	mov	dl,[po.c+di]
	push	di cx
	call	pix
	pop	cx di
	add	di,10
	loop	@put1
	ret
putimage	endp

;
;DOES THE INITIALIZATION
;

	initialize	proc
		CALL	INITVGA
		CALL	SETPAL
		CALL	INITP
		ret
	initialize	endp

;
;MAIN ROUTINE
;

	MAIN	PROC
		MOV	DI,0
		MOV	CX,4263
	main4:
		PUSH	CX
		CMP	[PO.ACTIVE+DI],1
		JNE	MAIN2
		MOV	BX,[po.X+di]
		MOV	AX,[po.Y+di]
		MOV	DL,0
		push	di
		CALL	PIX
		pop	di
	MAIN2:
		push	di
		CALL	DOC
		pop	di
		CMP	[PO.ACTIVE+DI],1
		JNE	MAIN3
		MOV	BX,[po.X+di]
		MOV	AX,[po.Y+di]
		MOV	DL,[PO.C+DI]
		PUSH	DI
		CALL	PIX
		POP	DI

	MAIN3:
		add	di,10
		POP	CX
		LOOP	MAIN4
		CALL	WVRT
		RET
	MAIN	ENDP


END MAIN_CODE
