Comment $
******************************************************************************
*                                                *
*                                                                     *
*                                                        *
*                                                                     *
*                                                     *
*                                                                            *
*                                                                        *
*                                                                        *
*                                                                          *
*                                                                        *
*                                                                        *
*                                                                            *
*                               Version  0.16                               *
******************************************************************************
*                   Planar Mode Grafix Routs Coded By Ste R                  *
*     Please E-Mail Comments/Suggestions/Bugs To robbins@unix.lancs.ac.uk    *
******************************************************************************
* Version History                                                            *
* ~~~~~~~~~~~~~~~                                                            *
* V0.01 - First Version                                                      *
* V0.02 - Fixed Small Bug In Put_Pixel (Cheers Bio :) )                      *
* V0.10 - Added 320X200 Planar Mode Support, And Multi-Page Support, With    *
*         Page Offsets Calculated Automatically.                             *
* V0.11 - Added Option To Set Screen Address And Pixel Pan Manually          *
* V0.12 - Added Put_TBob To Put A Bob Anywhere On Any Plane, Uses BTP Format *
*         Bobs For Speed :)                                                  *
* V0.13 - Added Put_MTBob - Same As Above, But Masked (Colour 0 Not Plotted) *
* V0.14 - Added Set_Scan_Height, To Set The Scanline Repeat Value, Useful    *
*         For Setting Low Res Modes For Plasmas, Fires, Scalers And Stuff :) *
* V0.15 - Fixed Bob Routs - Silly Mistake :)                                 *
* V0.16 - Added Screen_Off/Screen_On Routs.  Useful For Giving CPU More Time *
*         To Do Calcs And Stuff When The Screen Isn't Being Used             *
******************************************************************************
$
        Vid_Seg  EQU    0a000h  ; Base Address Of Video Memory
        Seq_Port EQU    03c4h   ; Sequencer Port Address
        GrC_Port EQU    03ceh   ; Graphic Controller Port
        Atr_Port EQU    03c0h   ; Attribute Port

        Crtc_Port EQU   03d4h   ; CRT Controller Port
        Input_1   EQU   03dah   ; Input Status #1 Register

; Table Of CRTC Data For Setting ModeX - 200 Lines
LCRTC_Data_200      EQU     2
CRTC_Data_200	DW	00014h
                DW      0E317h

; Table Of CRTC Data For Setting ModeX - 240 Lines
LCRTC_Data_240      EQU     10
CRTC_Data_240	DW      00D06h
                DW      03E07h
                DW      04109h
                DW      0EA10h
                DW      0AC11h
                DW      0DF12h
                DW      00014h
                DW      0E715h
                DW      00616h
                DW      0E317h

; Virtual Length Of Scan Line - Set This Before Calling "Set_X"
LScan           DW      320

; Number Of Scanlines
NScan           DB      ?

; Offsets For The Graphics Pages 
; 3 Pages *MAX* For 240 Scanlines
; 4 Pages *MAX* For 200 Scanlines
; Can Be Less For Virtual Scan Line Lengths
Page0           DW      0               ; Always 0
Page1		DW	?
Page2		DW	?
Page3		DW	?	

; Offsets For Put_Pixel & Get_Pixel
Scan_Offs       DW      240 Dup (?)

; Sets Grafix 320X200 Mode 13h
Set_Graph       PROC
        mov     ax,0013h
        int     10h
        ret
Set_Graph       ENDP

;Sets Text 80X25 Mode 03h
Set_Text        PROC
        mov     ax,0003h
        int     10h
        ret
Set_Text        ENDP

; Sets Up The Pixel Offset Table For Put_Pixel & Get_Pixel
; MUST Be Called Before Using Those Routs, But After LScan Has Been Set
; Saves And Restores All Used Regs.
Setup_Pixel     PROC
        push    ax                      ; Store Regs.
        push    bx
        push    cx
        push    es
        push    di
        mov     bx, LScan               ; Length Of Virtual Scanline
        shr     bx, 2                   ; In Bytes
        mov     ax,SEG Scan_Offs        ; Get Address Of Table..
        mov     es,ax                   ; .. Into ES:DI
        mov     di,OFFSET Scan_Offs
        xor     ax,ax                   ; Clear AX
        stosw                           ; Copy AX To Table
        mov     cx,240                  ; 240  Scanlines
.Lp:    add     ax, bx                  ; Add Scanline Length To AX
        stosw                           ; Store It In The Table
        loop    .Lp                     ; Loop
        pop     di                      ; Restore Regs
        pop     es
        pop     cx
        pop     bx
        pop     ax
        ret
Setup_Pixel     ENDP

Set_Pages	PROC
	Push	ax
	mov	ax, LScan		; Length Of Scanline
	shr	ax, 2			; Divide By 4 (4 Pixels Per Byte)
	mul	NScan			; Get Size Of Each Page
	mov	Page1, ax		; Store It In Page1
	add	ax, ax			; Add Page Size
	mov	Page2, ax		; Store In Page2
	add	ax, Page1		; Add Page Size
	mov	Page3, ax		; Store In Page3
	Pop	ax
	ret
Set_Pages	ENDP

; Actually Sticks Us Into ModeX - With 240 Scanlines Per Page
; Set The Variable LSCAN To The Virtual Scanline Length You Want
; Trashes AX, CX, DX, DS, SI
; Shouldn't Matter Though As This Should Be The First Thing You Call!
Set_X_240   PROC
        Call    Set_Graph       ; Set Mode 13h
        mov     dx, Seq_Port
        mov     ax, 00604h      ; Index 4 (Memory Mode Reg.) In AL
                                ; Bit 3 = Chain 4
        out     dx, ax          ; Kill Chain 4 Mode
        mov     ax, 00100h      ; Index 0 (Reset Reg.) In AL
        out     dx, ax          ; Reset Syncronous (At End Of Cycle)
        dec     dx              ; Change Port
        dec     dx              ; To Misc. Shit Port :)
        mov     al, 11100011b
        out     dx, al          ; Sets 480 Line Mode, 25Mhz Dot Clock
        inc     dx              ; Change Port
        inc     dx              ; Back To Sequencer Port
        mov     ax, 00300h
        out     dx, ax          ; Restart Controller
        mov     dx, Crtc_Port
        mov     al, 011h
        out     dx, al          ; Select Index 11h (Vert.Retrace End)
        inc     dx              ; Data Port
        in      al, dx          ; Read In Current Bit Mask
        and     al, 07Fh        ; 01111111 - Clear Top Bit (Write Protect)
        out     dx, al          ; Un-Write Protect Index 0-7 Of CRTC Reg.
        dec     dx              ; Restore Port To Index
        mov     ax, seg CRTC_Data_240       	; Address Of Our CRTC Data
        mov     ds, ax
        mov     si, offset CRTC_Data_240
        mov     cx, LCRTC_Data_240		; Length Of Data
        repz    outsw                   	; Chuck It At The Port
        mov     ax, lscan
        shr     ax, 3           ; Number Of Words Per Scan Line
        mov     ah, al          ; Into AH
        mov     al, 013h        ; Port Index 013h - Logical Screen Width
        out     dx, ax

        mov     NScan, 240
	Call	Set_Pages
	ret
Set_X_240   ENDP

; Actually Sticks Us Into ModeX - With 200 Scanlines Per Page
; Set The Variable LSCAN To The Virtual Scanline Length You Want
; Trashes AX, CX, DX, DS, SI
; Shouldn't Matter Though As This Should Be The First Thing You Call!
Set_X_200   PROC
        Call    Set_Graph       ; Set Mode 13h
        mov     dx, Seq_Port
        mov     ax, 00604h      ; Index 4 (Memory Mode Reg.) In AL
                                ; Bit 3 = Chain 4
        out     dx, ax          ; Kill Chain 4 Mode
        mov     ax, 00100h      ; Index 0 (Reset Reg.) In AL
        out     dx, ax          ; Reset Syncronous (At End Of Cycle)
        dec     dx              ; Change Port
        dec     dx              ; To Misc. Shit Port :)
        mov     al, 01100011b
        out     dx, al          ; Sets 400 Line Mode, 25Mhz Dot Clock
        inc     dx              ; Change Port
        inc     dx              ; Back To Sequencer Port
        mov     ax, 00300h
        out     dx, ax          ; Restart Controller
        mov     dx, Crtc_Port
        mov     al, 011h
        out     dx, al          ; Select Index 11h (Vert.Retrace End)
        inc     dx              ; Data Port
        in      al, dx          ; Read In Current Bit Mask
        and     al, 07Fh        ; 01111111 - Clear Top Bit (Write Protect)
        out     dx, al          ; Un-Write Protect Index 0-7 Of CRTC Reg.
        dec     dx              ; Restore Port To Index
        mov     ax, seg CRTC_Data_200       	; Address Of Our CRTC Data
        mov     ds, ax
        mov     si, offset CRTC_Data_200
        mov     cx, LCRTC_Data_200		; Length Of Data
        repz    outsw                   	; Chuck It At The Port
        mov     ax, lscan
        shr     ax, 3           ; Number Of Words Per Scan Line
        mov     ah, al          ; Into AH
        mov     al, 013h        ; Port Index 013h - Logical Screen Width
        out     dx, ax

        mov     NScan, 200
	Call	Set_Pages
        ret
Set_X_200   ENDP

; Clear ModeX Screen To A Specified Colour
; AL - Colour To Clear To
; Trashes DX
Cls     PROC
        push    ax
        mov     dx, Seq_Port
        mov     ax, 0F02h       ; Index 2 - Plane Select Write Reg.
        out     dx, ax          ; Select All Planes For Write
        pop     ax
        xor     di, di          ; Start At Begining Of Vid. Mem
        mov     cx, 0ffffh      ; Vid Mem Size/2/4
        cld                     ; Make Sure We Go The Correct Way :)
        mov     ah, al
        mov     bx, Vid_Seg     ; Start Address
        mov     es, bx
        rep     stosw           ; Do Clearing (In Words)
        ret
Cls     ENDP

; Wait For A Vertical Retrace
; Trashes Nothing
Wait_Retrace    PROC
        push    dx
        push    ax
        mov     dx,3DAh
@Wait1:
        in      al,dx
        and     al,08h
        jnz     @Wait1
@Wait2:
        in      al,dx
        and     al,08h
        jz      @Wait2
        pop     ax
        pop     dx
        ret
Wait_Retrace    ENDP

; Put Pixel
; Doesn't Use A Shitty MUL Any More, Now Uses A Cool Table Lookup
; Quite A Bit More Complicated That The Mode13h Put Pixel :)
; AL - Colour Of Pixel
; BX - X Co-ord
; DX - Y Co-ord
; CX - Offset To Plot From e.g. Page1 or 16000
; Trashes BX, CX, DX, ES, DI
Put_Pixel       PROC
        push    ax
        mov     ax, Vid_Seg     ; Base Address
        mov     es, ax          ; Into ES
        shl     dx,1            ; X2 As Table Is Word Sized
        mov     di,dx           ; Store In DI
        mov     di,word ptr scan_offs[di]       ; Get Offset From Table
	add	di, cx		; Add Offset To Plot From
	mov     cx, bx          ; Store X Coord
        shr     bx, 2           ; Divide By 4 (4 Planes)
        add     di,bx           ; Add To Y Offset To Get Total Offset
        mov     ax, 00102h      ; Port Index 02h (Select Planes) And Place A
                                ; 1 In AH (See Later!)
        and     cl, 3           ; Get Correct Plane Number (0-3)
        shl     ah, cl          ; Shift AH For The Number Of Planes, With The
                                ; 1 Loaded Earlier, We Now Have The Plane
                                ; Mask In AH!
        mov     dx, Seq_Port
        out     dx, ax          ; Set Our Mask
        pop     ax              ; Restore Colour
        stosb                   ; Write Pixel
	ret
Put_Pixel       ENDP

; Get Pixel
; Doesn't Use A Shitty MUL Any More, Now Uses A Cool Table Lookup
; Quite A Bit More Complicated That The Mode13h Get Pixel :)
; BX - X Co-ord
; DX - Y Co-ord
; CX - Offset To Plot From e.g. Page1 or 16000
; Returns:
;         AL - Colour Of Pixel
; Trashes BX, CX, DX, ES, DI
Get_Pixel       PROC
        mov     ax, Vid_Seg     ; Base Address
        mov     es, ax          ; Into ES
        shl     dx,1            ; X2 As Table Is Word Sized
        mov     di,dx           ; Store In DI
        mov     di,word ptr scan_offs[di]       ; Get Offset From Table
	add	di, cx		; Add Offset To Plot From
        mov     cx, bx          ; Store X Coord
        shr     bx, 2           ; Divide By 4 (4 Planes)
        add     di,bx           ; Add To Y Offset To Get Total Offset
        and     cl, 3           ; Get Correct Plane Number (0-3)
        mov     ah, cl          ; Stick It In AH (Plane Select)
        mov     al, 4           ; Port Address 4 (Read Plane Select Reg.)
        mov     dx, Grc_Port
        out     dx, ax          ; Select Plane
        mov     al, es:[di]     ; Read Pixel
        ret
Get_Pixel       ENDP

; Set Starting Offset Of Screen
; Does Not Use Pixel Panning, So Offset Is Rounded Down To Nearest 4 Pixels
; BX - Offset Or Page (Note : Offset Must Be In Bytes And 1Byte = 4Pixels)
; Trashes Nothing
Set_Start_Offset	PROC
	Push	ax
	Push	dx
	mov     dx, Input_1     ; Input Status #1
@Lp:
        in      al, dx
        test    al, 8
        jnz     @Lp             ; Wait For Retrace To Start
        sub     dx, 6           ; Change To CRTC Port
        mov     al, 0dh         ; Index 0dh - Start Address Low
        mov     ah, bl          ; Get Low Byte Of Address
        cli                     ; Kill Interrupts
        out     dx, ax          ; Set Low Byte Of Address
        dec     al              ; Index 0ch - Start Address High
        mov     ah, bh          ; Get High Byte Of Address
        out     dx, ax          ; Set High Byte Of Address
        sti                     ; Reenable Interrupts
	Pop	dx
	Pop	ax
        ret
Set_Start_Offset	ENDP

; Set Pixel Panning
; CL - Number Of Pixels To Pan (0-3)
; Trashes Nothing
Set_Pan PROC
        Push    ax
        Push    dx
	mov     dx, Input_1     ; Input Status #1
@Lp2:
        in      al, dx
        test    al, 8
        jz      @Lp2            ; Wait For Retrace To End
                                ; Flip-Flop Now Reset (Needs To Be For Pixel
                                ; Pan!)
        mov     dx, Atr_Port    ; Select Attribute Port 
        mov     al, 033h        ; Index 033h - Pixel Pan Register
        out     dx, al
        mov     al, cl          ; Move Value Into AL
        shl     al, 1           ; Multiply By 2 (Only Even No.s Allowed)
        out     dx, al          ; Do The Pan
        Pop     dx
        Pop     ax
        ret
Set_Pan ENDP

; Set The Starting Point Of The Displayed Screen
; Takes Into Account Pixel Panning, So Screen Can Be Scrolled In Any Direction
; One Pixel At A Time
; BX - X-Coord (In Pixels)
; DX - Y-Coord (In Pixels)
; CX - Page Offset To Take X,Y Coords From
; Trashes AX, BX, CX, DX
Set_Start_Addr PROC
        mov     ax, lscan       ; Length Of Scanline
        shr     ax, 2           ; In Bytes
        mul     dx              ; Multiply By Y Coord
        mov     dl, bl          ; Copy LSByte Of X Into CL
        shr     bx, 2           ; Divide By 4 (We Can Only Change Start
                                ; Address By 1Byte = 4 Pixels)
        add     bx, ax          ; Add To Y Offset
        add     bx, cx          ; Add Page Offset

        call    Set_Start_Offset        ; Set Offset
        and     dl, 3           ; Get The Rest Of Offset (0-3)
        mov     cl, dl
        call    Set_Pan         ; Set Pixel Panning
        ret
Set_Start_Addr  ENDP

; Stops Pixel Panning Affecting The Split Screen
; Call This After Setting The Split Line
; Trashes AX, DX
Set_PPC PROC
        mov     dx,Atr_Port     ; Select Port
        mov     al,30h          ; Index 30h - Mode Control Register
        out     dx,al
        inc     dx              ; Move To Data Port
        in      al,dx           ; Get Current Data
        dec     dx              ; Move Back To Index Port
        or      al,00100000b    ; Set Bit 5 (Horiz. Pan Conpatibility)
        out     dx,al
        ret
Set_PPC ENDP

; Sets The Screen Split Scanline
; Call Set_PPC After This Or Don't Use Pixel Panning!
; BX - Scan Line To Split To
; Trashes AX, DX
Set_Split_Line  PROC
        shl     bx, 1           ; X2 For Double Pixel Height
        mov     dx, CRTC_Port   ; Select Port
        mov     al, 18h         ; Index 18h - Bits 0-7 Of Split
        mov     ah, bl          ; Place 8 LSB In AH
        out     dx, ax
        mov     al, 09h         ; Index 09h - Bit 9 Of Split (+ Others)
        out     dx, al          ; Select Index
        inc     dx              ; Move To Data Port
        in      al,dx           ; Get Current Settings
        mov     ah,bh           ; Get MSB
        and     ah,00000010b    ; We Just Want Bit 9
        shl     ah,5            ; Shift To Bit 6 (Bit To Set/Reset In Port)
        and     al,10111111b    ; Clear Bit 6 Of Current Port Settings
        or      al,ah           ; OR Them Together
        out     dx,al           ; Set New Value
        dec     dx              ; Move Back To Index Port
        mov     al,07h          ; Index 07h - Bit 8 Of Split (+ Others)
        out     dx,al           ; Select Index
        inc     dx              ; Move To Data Port
        in      al,dx           ; Read Current Settings
        mov     ah,bh           ; Get MSB
        and     ah,00000001b    ; Bit 8
        shl     ah,4            ; Shift To Bit 4
        and     al,11101111b    ; Clear Bit 4
        or      al,ah           ; Or Them Together
        out     dx,al           ; Set New Value
        ret
Set_Split_Line  ENDP

; Sets Scanline Repeat Value/Scanline Height
; You Can Use This To Make Really Stupid Resolutions :)
; BL - Scanline Height
Set_Scan_Height PROC
        mov     dx, CRTC_Port   ; Select Port
        mov     al, 09h         ; Index 9 - Max. Scan/Char. Height
        out     dx, al          ; Select It
        inc     dx              ; Move To Data Port
        in      al, dx          ; Get Current Setting
        and     al, 0fh         ; We Only Want Bits 0-3
        add     al, bl          ; Add Our Repeat Value
        out     dx, al          ; Send New Value
        ret
Set_Scan_Height ENDP

; Turns The Screen Display Off
; Gives CPU More Time To Do Other Stuff!
; Trashes AX, DX
Screen_Off      PROC
        cli                     ; Kill Interrupts
        mov     dx, Seq_Port    ; Select Port
        mov     al, 01h         ; Select Index
        out     dx, al
        inc     dx              ; Move To Data Port
        in      al, dx          ; Get Current Settings
        or      al, 00100000b   ; Set Video Off Bit
        out     dx, al          ; Store Settings
        sti                     ; Restore Interrupts
        ret
Screen_Off      ENDP

; Turns The Screen Display On
; Trashes AX, DX
Screen_On       PROC
        cli                     ; Kill Interrupts
        mov     dx, Seq_Port    ; Select Port
        mov     al, 01h         ; Select Index
        out     dx, al
        inc     dx              ; Move To Data Port
        in      al, dx          ; Get Current Settings
        and     al, 11011111b   ; Reset Video Off Bit
        out     dx, al          ; Store Settings
        sti                     ; Restore Interrupts
        ret
Screen_On       ENDP

; Internal Variables For Bob Routs
X_Size  DW      ?
Y_Size  DW      ?

; Puts A Bob On The Screen
; Must Be In BTP Format, And The X-Size Must NOT Be Greater Than LScan
; DS:SI - The Bob
; BX    - X-Pos To Plot At
; DX    - Y-Pos To Plot At
; CX    - Offset Or Page To Plot Onto
; Trashes AX, BX, CX, DX, ES, DI, SI
Put_TBob        PROC
        mov     ax, Vid_Seg     ; Base Address
        mov     es, ax          ; Into ES
        shl     dx,1            ; X2 As Table Is Word Sized
        mov     di,dx           ; Store In DI
        mov     di,word ptr scan_offs[di]       ; Get Offset From Table
	add	di, cx		; Add Offset To Plot From
        mov     cl, bl          ; Store LSB Of X-Offset
        shr     bx, 2           ; Divide By 4 (4 Planes)
        add     di,bx           ; Add To Y Offset To Get Total Offset

; BTP Format Files Have A Header Size Of 4 Bytes
; Offset 0 - X-Size In Bytes (Word)
; Offset 2 - Y-Size In Scanlines (Word)
        lodsw
        mov     bx, ax          ; X-Size (Bytes)
        lodsw
        mov     Y_Size, ax
        mov     ax, lscan       ; Offset To Add At End Of Each Scanline
        shr     ax, 2
        sub     ax, bx
        shr     bx, 1           ; X-Size (Words)
        mov     x_size, bx

        mov     bx, ax          ; Move Offset Into BX
        mov     ah, 01h         ; Place A 1 In AH
        and     cl, 3           ; Get Correct Plane Number (0-3)
        shl     ah, cl          ; Shift AH For The Number Of Planes, With The
                                ; 1 Loaded Earlier, We Now Have The Plane
                                ; Mask In AH!

        mov     dx, Seq_Port    ; Select Correct Port...
        mov     al, 02h         ; .. And Index (Write Plane Select)

        mov     cx, 4           ; Loop For All Planes
@Plane_Loop:
        out     dx, ax          ; Select Plane For Write

        push    cx              ; Store Counter
        mov     cx, y_size      ; Loop Counter For Num Of Scanlines
        push    di              ; Store Destination Offset

@Y_Loop:
        push    cx              ; Store Counter
        mov     cx, x_size      ; Loop Counter For Len Scanline In Words
        Rep     movsw           ; Copy 1 Scanline
        add     di, bx          ; Move To Start Of Next Scanline
        Pop     cx              ; Restore Y Counter
        dec     cx
        jnz     @Y_Loop         ; Loop For All Scanlines
        pop     di              ; Restore Destination Offset
        shl     ah, 1           ; Next Plane
        cmp     ah, 00010000b   ; Have We Gone Out Of Range
        jne     @In_Range
        mov     ah, 01h         ; If So, Reset To Plane 0
        inc     di              ; And Move To Next Pixel
@In_Range:
        pop     cx              ; Restore Plane Counter
        dec     cx
        jnz     @Plane_Loop     ; Loop For Next Plane
        ret
Put_TBob        ENDP

; Puts A Bob On The Screen - With Masking
; Any Pixels Of Colour 0 Are Not Plotted
; Must Be In BTP Format, And The X-Size Must NOT Be Greater Than LScan
; DS:SI - The Bob
; BX    - X-Pos To Plot At
; DX    - Y-Pos To Plot At
; CX    - Offset Or Page To Plot Onto
; Trashes AX, BX, CX, DX, ES, DI, SI
Put_MTBob        PROC
        mov     ax, Vid_Seg     ; Base Address
        mov     es, ax          ; Into ES
        shl     dx,1            ; X2 As Table Is Word Sized
        mov     di,dx           ; Store In DI
        mov     di,word ptr scan_offs[di]       ; Get Offset From Table
	add	di, cx		; Add Offset To Plot From
        mov     cl, bl          ; Store LSB Of X-Offset
        shr     bx, 2           ; Divide By 4 (4 Planes)
        add     di,bx           ; Add To Y Offset To Get Total Offset

; BTP Format Files Have A Header Size Of 4 Bytes
; Offset 0 - X-Size In Bytes (Word)
; Offset 2 - Y-Size In Scanlines (Word)
        lodsw
        mov     x_size, ax      ; X_Size (Bytes)
        lodsw
        mov     Y_Size, ax
        mov     ax, lscan       ; Offset To Add At End Of Each Scanline
        shr     ax, 2
        sub     ax, x_size

        mov     bx, ax          ; Move Offset Into BX

        mov     ah, 01h         ; Place A 1 In AH
        and     cl, 3           ; Get Correct Plane Number (0-3)
        shl     ah, cl          ; Shift AH For The Number Of Planes, With The
                                ; 1 Loaded Earlier, We Now Have The Plane
                                ; Mask In AH!
        mov     dx, Seq_Port    ; Select Correct Port

        mov     cx, 4           ; Loop For All Planes
@Plane_Loopm:
        mov     al, 02h         ; Select Index (Write Plane Select)
        out     dx, ax          ; Select Plane For Write

        push    cx              ; Store Counter
        mov     cx, y_size      ; Loop Counter For Num Of Scanlines
        push    di              ; Store Destination Offset

@Y_Loopm:
        push    cx              ; Store Counter
        mov     cx, x_size      ; Loop Counter For Len Scanline In Words
@X_Loopm:
        lodsb                   ; Get Next Pixel
        cmp     al, 0           ; Is It 0?
        je      @No_plot        ; If So Don't Plot It
        mov     es:[di], al     ; If Not, Plot
@No_Plot:
        inc     di              ; Next Pixel
        dec     cx
        jnz     @X_Loopm        ; Loop

        add     di, bx          ; Move To Start Of Next Scanline
        Pop     cx              ; Restore Y Counter
        Dec     cx
        jnz     @Y_Loopm        ; Loop For All Scanlines
        pop     di              ; Restore Destination Offset

        shl     ah, 1           ; Next Plane
        cmp     ah, 00010000b   ; Have We Gone Out Of Range
        jne     @In_Rangem
        mov     ah, 01h         ; If So, Reset To Plane 0
        inc     di              ; And Move To Next Pixel
@In_Rangem:
        pop     cx              ; Restore Plane Counter
        dec     cx
        jnz     @Plane_Loopm    ; Loop For Next Plane
        ret
Put_MTBob        ENDP
