                .model  small
                .286
                .stack 200h

                ASSUME  DS:@DATA
              
        Lines240        =       1

.Data
                Include  ball1.dat

.Code
pal     db      0, 0, 0
        db      0, 33, 99
        db      0, 33, 165
        db      0, 99, 0
        db      0, 132, 0
        db      33, 66, 231
        db      33, 165, 0
        db      66, 66, 66
        db      66, 198, 33
        db      99, 132, 231
        db      99, 231, 33
        db      132, 132, 132
        db      165, 231, 165
        db      198, 198, 231
        db      231, 231, 231
        db      255, 255, 255


                Include BeepX.Asm

; Writes A Pallete To The VGA
; DS:SI - Palette
; CX - Number Of Colors To Write
; AL - Starting Palette Register
; Trashes DX,SI,CX
Write_Pal       MACRO
        mov     dx,cx           ;Faster Than Muls
        add     cx,cx           ;Times 3 For R,G,B Values
        add     cx,dx   
        mov     dx,03c8h
        out     dx,al
        inc     dx
        cld
        rep     outsb
ENDM

Start:
                mov     ax, seg pal
                mov     ds, ax
                mov     es, ax
                mov     si, offset pal
                mov     di, offset pal
                mov     cx, 16*3
palll:
                lodsb
                shr     al, 2
                stosb
                loop    palll

                call    Wait_Retrace
                mov     lscan, 640
                IF Lines240
                        Call    Set_x_240           ; Go ModeX
                ELSE
                        Call    Set_x_200
                ENDIF
                call    Wait_Retrace
                mov     ax, seg pal
                mov     ds, ax
                mov     si, offset pal
                mov     cx, 16
                mov     al, 0
                Write_Pal
                call    Wait_Retrace
                
                Call    Setup_Pixel     ; Setup Put & Get Pixel Offsets

                Mov     al, 0           ; Clear To Colour 0
                Call    Cls

                mov     ax, vid_seg     ; Address Of Video Memory
                mov     es, ax          ; Into ES
                xor     di, di          ; Start At 0 Offset
                mov     ax, seg pic
                mov     ds, ax
                mov     si, offset pic
                mov     cx, 200
yloop:
                push    cx
                mov     dx, 200
                sub     dx, cx
                mov     cx, 320
xloop:
                mov     bx, 320
                sub     bx, cx
                lodsb
                push    bx
                push    cx
                push    dx
                push    es
                push    di
		xor	cx, cx
		call 	put_pixel
                pop     di
                pop     es
                pop     dx
                pop     cx
                pop     bx
                loop    xloop
                pop     cx
                loop    yloop
; Tests Screen Split
                xor     bx, bx          ; Set Current Screen Offset
                mov     dx, 100          ; To X=0, Y=75
                xor     cx, cx
                call    set_start_addr
                call    wait_retrace
                mov     bx, 150          ; Split Screen At Scanline 75
                call    set_split_line
                xor     bx, bx          ; Set Screen Offset To 0
                xor     dx, dx          ; This Works For Top Section Of
                xor     cx, cx
                call    set_start_addr  ; Screen Only (<75)
                call    wait_retrace

                Call    Set_PPC         ; Set Pixel Pan Compatibility

; Test Scrolling
; Changes X Offset From 100 Down To 0 In Pixel Steps
; NOTE - Only The Top Line Scrolls, As The Screen Is Split Across The Line
;        Y = 75 (See Above)
                mov     cx, 320         ; Counter
lp3:
                mov     dx, cx          ; X-Offset
                mov     bx, cx          ; Use Counter For Y-Offset
                push    cx              ; Store CX
                xor     cx, cx
                call    Set_Start_Addr  ; Set Address (No Retrace Needed)
                pop     cx              ; Restore CX
                loop    lp3             ; Loop

                mov     al, 10
                mov     bx, 160
                mov     dx, 75
                mov     cx, page1
                Call    Put_Pixel

                Call    Wait_Retrace
; Test Scrolling On Another Page
; Changes X Offset From 100 Down To 0 In Pixel Steps
; NOTE - Only The Top Line Scrolls, As The Screen Is Split Across The Line
;        Y = 75 (See Above)
                mov     cx, 100         ; Counter
lp4:
                mov     dx, cx          ; X-Offset
                mov     bx, cx          ; Use Counter For Y-Offset
                push    cx              ; Store CX
                mov     cx, page1
                call    Set_Start_Addr  ; Set Address (No Retrace Needed)
                pop     cx              ; Restore CX
                loop    lp4             ; Loop

Do_Loop:
                mov     ah,1                    ; Check If Key Pressed
                int     16h
                je      Do_Loop                 ; If Not, Loop

                Call    set_text                ; Return To Text Mode

                mov     ax,4C00h                ; Terminate
                int     21h
End     Start        
