/*
Rylan's DJGPP blob conversion demo program.
Based on Code by Tom Hammersley
rylan@intekom.co.za
http://home.intekom.com/rylan/

DJGPP C module

This is another program that shows how to do the following:
- Access 320x200x256 VGA graphics in protected mode under DJGPP using DJGPP+NASM
- Convert real mode assembly code to protected mode so you can convert TASM
  demo programs (in which most demo code is written) to DJGPP+NASM
- Integrate DJGPP+NASM
- Call NASM functions from inside DJGPP

Please feel free to contact me about anything regarding this program!

The biggest problems I have encountered converting real mode TASM format
programs to freeware protected mode DJGPP+NASM programs have been in the
memory references - real mode assembly code just does not access memory in
the same manner as protected mode code has to. In protected mode you have
certain things you cannot do at all versus real mode where you can do almost
anyhting and access almost any memory location, or even change it. Protected
mode often does not allow this at all, but there exists certain ways to get
around any limitations - it just takes some mucking about to find them! This
small tutorial is intended for someone who has some real mode assembly
experience, and want to make a shift to protected mode using the BEST FREE
CODING SOFTWARE ON EARTH: DJGPP+NASM!!!

What you need:
- Fully installed, functioning copy of DJGPP
  Go to http://www.delorie.com/djgpp/ if you do not have this.
- Fully installed, functioning copy of NASM
  Go to http://www.cryogen.com/nasm/ if you do not have this.
- A tiny bit of real mode assembly experience
- The urge to learn!
*/

/*
Standard includes - dpmi.h is needed 'cause we use a dpmi function to gain
access to the video RAM.
*/
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <dpmi.h>

int vid_descr = 0;
/*
This is the "video descriptor" - it is used in the BLOBSA.ASM module to gain
access to VGA video RAM.
*/

extern void volatile blob_main();
/*
This is how you link a DJGPP module with a NASM assembly module - this declares
the function BLOB_MAIN as an external function, i. e. it does not appear in
this module but is located externally to it in another module that will be
linked in at link-time during the compilation phase.
*/

int main(void)
/*
Main program function - as you can see all it does is to call the dpmi function
__dpmi_segment_to_descriptor in order to get the value for the vid_descr
variable, and it then starts up the assembly function that does the actual
effect.
*/
{
 vid_descr = __dpmi_segment_to_descriptor(0xA000);
 /*
 This statement returns a number into the vid_descr variable that we can
 use in the NASM assembly code in BLOBSA.ASM to access VGA video RAM just like
 it is accessed in real mode. All you need to do is to pop the vid_descr
 variable into the ES register, and use that as a base register in memory
 references that are to access the screen.
 */

 blob_main();
 /*
 This is the main blob function which is declared externally in the BLOBSA.ASM
 NASM assembly file.
 */

 exit(0); //All done
}

