/*
Bump Mapping Demo in Allegro from real mode native Pascal.
Converted from someone elses real mode code - Orpheus / Helix.

Done by Stfan Viljoen
10 Goedehoopstreet
Potchefstroom
2520
Republic of South Africa

Email: rylan@intekom.co.za
*/

#include <stdlib.h>
#include <conio.h>
#include <stdio.h>
#include <math.h>
#include <allegro.h>
#include "bump4.h"

#define TABLESIZE 8000

float sintable[TABLESIZE];
float costable[TABLESIZE];

BITMAP *screen1,*screen2;

int x,y,
    vlx,vly,
    nx,ny;

unsigned short l1;

int loop;

void init()
{
 allegro_init();
 set_gfx_mode(GFX_VGA,320,200,0,0);
 install_keyboard();

 screen1 = create_bitmap(SCREEN_W,SCREEN_H);
 screen2 = create_bitmap(SCREEN_W,SCREEN_H);
}

float rad(float theta)
{
 return ((theta * PI) / 180);
}

void gentable()
{
 float deg = 0;

 for (loop = 0; loop < TABLESIZE; loop++)
 {
  costable[loop] = cos(rad(deg));
  sintable[loop] = sin(rad(deg));
  deg+= 2.8;
 }

}

void setuppal()
{
 RGB pal;

 for (l1 = 0; l1 <= 255; l1++)
 {
  pal.r = 0;
  pal.g = 0;
  pal.b = 0;
  set_color(l1,&pal);
 }

 for (l1 = 128; l1 <= 255; l1++)
 {
  pal.r = l1 >> 1;
  pal.g = 0;
  pal.b = l1 >> 3;
  set_color(l1,&pal);
 }

}

void loadpicture()
{
 DATAFILE *datafile;

 datafile = load_datafile("bump4.dat");

 blit(datafile[BumpMap].dat,screen1,0,0,0,0,SCREEN_W,SCREEN_H);
}

void dobump()
{
 int difx,dify,col,lx,ly;

 lx = 160;
 ly = 100;
 l1 = 0;

 while (!(keypressed()))
 {

  if (l1 < TABLESIZE)
  {
   l1++;
  }

  else

  {
   l1 = 0;
  }

  lx = 160 + (40 * costable[l1]);
  ly = 100 + (40 * sintable[l1]);

  for (x = 1; x <= 318; x++)
  {

   for (y = 1; y <= 190; y++)
   {

    vlx = x - lx;
    vly = y - ly;

    if ((vlx < 130) && (vlx > -130) && (vly > -130) && (vly < 130))
    {

     nx = screen1->line[y][x + 1] - screen1->line[y][x - 1];
     ny = screen1->line[y + 1][x] - screen1->line[y - 1][x];

     col = (int)(abs(vlx - nx));

     if (col > 127)
     {
      col = 127;
     }

     difx = 127 - col;

     if (difx < 0)
     {
      difx = 1;
     }

     col = (int)(abs(vly - ny));

     if (col > 127)
     {
      col = 127;
     }

     dify = 127 - col;

     if (dify < 0)
     {
      dify = 1;
     }

     col = difx + dify;

     if (col > 128)
     {
      screen2->line[y][x] = col;
     }

    }

   }

  }

  blit(screen2,screen,0,0,0,0,SCREEN_W,SCREEN_H);
  clear(screen2);

 }

}

void done()
{
 destroy_bitmap(screen2);
 destroy_bitmap(screen1);
 set_gfx_mode(GFX_TEXT,80,25,0,0);
}

int main(void)
{
 init();

 gentable();

 setuppal();

 loadpicture();

 dobump();

 done();

 printf("Converted from Real Mode Demo by Orhpeus / Helix.\n");
 printf("Done by Rylan\n");
 printf("Rylan@intekom.co.za\n");
 exit(0);
}
