;
;                       Cool Boot (v 1.0)
;
;  Replace the old boring MS-DOS boot sector with an new cool
;  one, with a fire effect and an fading message.
;
;  Thanks to Psychic Monk for the fire code. Since I was to
;  lacy to write my own, I just size optimised his code ;)
;
;  BTW; I wrote this piece of code while I was in the army :(
;
;  (c) Copyright 1996             Greven I , Suicide Software
;


        IDEAL
        P386N
        


; *** Equates and Numbers ***
CR              EQU     13
LF              EQU     10
EOS             EQU     '$'



; *** Macros ***

;-------------------------------------------
; Fade the text in and out
;-------------------------------------------
Macro   Text_Stuff
        mov     dx,3C8h
        mov     al,100                  ; Color reg 100
        out     dx,al
        inc     dx                      ; DX = Color data
        xor     al,al
        out     dx,al                   ; R = 0
        mov     ah,[Byte ds:Text_Color]
        mov     al,ah
        shr     al,2                    ; Color / 4
        out     dx,al                   ; G = Color / 4
        mov     al,ah
        out     dx,al                   ; B = Color

        cmp     [Byte ds:Fade_Dir],1
        je      @@800

; Fade up
        inc     al
        cmp     al,62
        jne     @@990
        inc     [Byte ds:Fade_Dir]      ; Set fade down flag (1)
        jmp     @@990


; Fade down
@@800:  sub     al,2
        jnz     @@990
        dec     [Byte ds:Fade_Dir]

@@990:  mov     [Byte ds:Text_Color],al
EndM    Text_Stuff



;-------------------------------------------
; Copy the frame buffer to the screen
;-------------------------------------------
Macro   Draw_Flame
        mov     al,[Byte ds:Y_Len]
        cmp     al,94
        je      @@105
        inc     al
        cmp     al,1
        mov     [Byte ds:Y_Len],al
        jge     @@105
        jmp     Return


@@105:  cmp     [Word ds:Flame_Ofs],320 * (200-94) + 4
        je      @@205
        sub     [Word ds:Flame_Ofs],320

@@205:  mov     [Word ds:Temp],Offset Frame + 104
        mov     di,[Word ds:Flame_Ofs]
        mov     bl,[Byte ds:Y_Len]
        xor     eax,eax

Line_Loop:
        mov     cx,3                    ; Draw 3 copies

@@305:  push    cx
        mov     si,[Word ds:Temp]       ; Display First image
        mov     cx,104/4
        rep     movsd
        pop     cx
        loop    @@305

        xor     eax,eax
        stosd
        stosd
        add     [Word ds:Temp],104      ; Next line
        dec     bl
        jnz     Line_Loop
Return:
EndM    Draw_Flame
        




;-------------------------------------------
; Calculate the next frame buffer
;-------------------------------------------
Macro   Calc_Flame
        mov     si,Offset Frame + 104 - 3
        mov     cx,104 * (94+9-2)

@@101:  mov     al,[Byte ds:si+2*104]   ; Each point is set as the average of
        mov     bl,[Byte ds:si]         ; four pixels to the left below it.
        add     ax,bx
        mov     bl,[Byte ds:si+1]
        sub     ax,3
        add     ax,bx
        mov     bl,[Byte ds:si+104]
        add     ax,bx

        sar     ax,2
        jge     @@201
        xor     ax,ax

@@201:  mov     [Byte ds:si-104 + 3],al
        inc     si
        loop    @@101


; Setup bottom line with "random" numbers
        mov     si,Offset Frame+104*(94+9-2)
        mov     cx,104
        xor     dx,dx

@@301:  call    Random
        or      ax,ax
        js      @@401
        call    Random

@@401:  sub     al,35  
        mov     [Byte ds:si+104+3],al
        and     al,07fh
        mov     [Byte ds:si],al
        add     si,2
        loop    @@301
EndM    Calc_Flame





;------------------------------
; Wait for the start of VR
;------------------------------
Macro   Wait_VR
        mov     dx,3DAh
@@100:  in      al,dx
        test    al,8
        je      @@100
@@110:  in      al,dx
        test    al,8
        jne     @@110
EndM    Wait_VR




ASSUME  CS:Code_Seg , DS:Code_Seg , SS:Stack_Seg



SEGMENT Code_Seg        Dword   Private         'CODE'          USE16

        ORG     00h             ; Boot sector is loaded at 07C0h:0000



; Boot sector

Cool_B: jmp     _Start
        nop
        db      "GREVEN I"
        dw      512                     ; BIOS parameter block (BPB) for
        db      1                       ; a normal 1.44M disk (63 Bytes long)
        dw      1
        db      2
        dw      224
        dw      2880
        db      0F8h
        dw      9
        dw      18
        dw      2
        dd      0
        dd      0
        dw      0
        db      29h
        dd      0h
        db      "NO NAME    "
        db      "FAT12   "


; Boot program
; We only have 512 bytes - BPB table (447 Bytes), so the code is extremely
; optimized for size

_Start: push    07C0h                   ; Setup stack
        pop     ss
        mov     sp,0FFFFh-10
        push    ss                      ; DS = Data in code seg
        pop     ds
        push    ds                      ; ES = Data in code seg
        pop     es
        mov     ax,13h                  ; 320 X 200 , 256 colors
        int     10h
        cld        


; Clear variables
        mov     di,Offset Frame
        mov     cx,(104*104*2) / 4
        xor     eax,eax
        rep     stosd


; Create fire palette
        mov     di,Offset Palette
        xor     al,al

        mov     cx,6                    ; Black to blue  (CH = ZERO!)
        mov     bx,0102h
        mov     dx,0002h
        call    Make_Pal


; Darkblue to midblue
        mov     cl,10
        xor     ah,ah                   ; I = 0

@@10:   stosb                           ; R = 0
        stosb                           ; G = 0
        mov     bl,14
        sub     bl,ah                   ; B = 14 - I
        mov     [Byte ds:di],bl         ; Store I (B)
        inc     di
        inc     ah                      ; I = I + 1
        loop    @@10
        
        
        mov     cl,24                   ; Midblue to brightblue
        mov     bx,182Fh
        mov     dx,0010h
        call    Make_Pal


        mov     cl,32                   ; Brightblue to lightblue/cyan
        mov     bx,101Fh
        mov     dx,0100h
        call    Make_Pal


; Setup palette
        mov     si,Offset Palette
        mov     cl,72*3
        mov     dx,3C8h
        xor     al,al
        out     dx,al
        inc     dx
        rep     outsb


; Write string
        mov     ax,1300h
        mov     bx,0064h
        mov     cl,[Byte ds:Len_String]
        mov     dl,[Byte ds:Start_String]
        mov     dh,0Ah
        mov     bp,Offset String
        int     10h

        push    0A000h                  ; ES = Video RAM
        pop     es


Main_Loop:
        Wait_VR
        Text_Stuff
        Draw_Flame
        Calc_Flame

        mov     ah,1                    ; Loop until a key is pressed
        int     16h
        jz      Main_Loop
        xor     ah,ah                   ; Remove key
        int     16h


; Exit
        mov     ax,03h                  ; Normal video mode
        int     10h
        int     19h                     ; Load boot sector



; *** Subroutines ***


;------------------------------
; Make one shade
;------------------------------
; In :  CX = Number of colors
;       BL = *
;       BH = /
;       DH = 0 or 1
;       AL Must be zero
;------------------------------
Proc    Make_Pal
        xor     ah,ah                   ; AH = I

@@10:   push    ax
        stosb                           ; R = 0
        stosb                           ; G = 0
        mov     al,ah                   ; AL = I
        mul     bl                      ; AX = I * BL
        div     bh                      ; AL = I / BH
        add     al,dl                   ; AL = I + DL

        or      dh,dh
        jz      @@20
        dec     di                      ; Write Green instead
        stosb
        mov     al,63                   ; B = 63

@@20:   stosb
        pop     ax
        inc     ah                      ; I = I + 1 
        loop    @@10

        ret
EndP    Make_Pal



;------------------------------
; AX = "Random" number
;------------------------------
Proc    Random
        mov     ax,[Word ds:Seed]
        imul    ax,8905h
        inc     ax
        mov     [Word ds:Seed],ax

        ret
EndP    Random



;------------------------------
; Boot program data
;------------------------------
        ALIGN   WORD

Seed            dw      4321h           ; Random seed
Flame_Ofs       dw      320*200 + 4
String          db      'IDIOT, YOU FORGOT TO REMOVE THE DISK !' ; Default
Len_String      db      38
Start_String    db      1


        ALIGN   DWORD

; The rest of memory is unused so we can use it for our buffers
Frame           =       $               ; 104*(94+9) Words
Temp            =       $ + (104*103)*2 ; Word
Y_Len           =       Temp + 2        ; Byte
Text_Color      =       Y_Len + 1       ; Byte
Fade_Dir        =       Text_Color + 1  ; Byte
Palette         =       Fade_Dir + 1    ; 72 * 3 Bytes


        ORG     512-2
                db      55h,0AAh        ; Boot sector signature




; Install program start

ASSUME  CS:Code_Seg , DS:Data_Seg , SS:Stack_Seg

Start:  mov     ax,Data_Seg
        mov     ds,ax
        cld


; Write copyright message
        mov     dx,Offset Str_Init
        mov     ah,09h
        int     21h


; Test for 386+
        pushf
        pop     ax
        or      ax,0F000h
        push    ax
        popf
        pushf
        pop     ax
        test    ax,0F000h
        jnz     CPU_Ok


; CPU is 286 or below
        mov     dx,Offset Str_Err3
        jmp     Exit_Write


; Check command line
CPU_Ok: movzx   cx,[Byte es:080h]       ; Get command line length
        jcxz    @@10                    ; No command line (Use defaults)


; Search for '/'
        mov     di,082h
        mov     al,'/'
        repne   scasb
        jcxz    @@10                    ; No '/' found

        cmp     [Byte es:di],'!'        ; Is switch /!
        jne     @@00
        inc     [Byte ds:Skipp_Copy]    ; Set flagg
        repne   scasb                   ; Find next '/'
        jcxz    @@10

@@00:   mov     ax,[Word es:di]         ; Found, get chars after '/'

        cmp     al,'?'                  ; Is switch /?
        jne     @@20
        mov     dx,Offset Str_Help      ; Write help text
        jmp     Exit_Write


@@20:   cmp     al,'d'                  ; Is switch /d or /D
        je      @@60
        cmp     al,'D'
        je      @@60
        
        cmp     ax,':s'                 ; Is switch /s: or /S:
        je      @@30
        cmp     ax,':S'
        je      @@30
        

; Invalid switch        
        mov     dx,Offset Str_Err4
        jmp     Exit_Write


; Copy user string to String in Code Seg
@@30:   mov     si,di
        add     si,2                    ; SI = Start of user string
        push    si                      ; Save start of string
        mov     di,Offset String
        mov     cx,39                   ; Max 38 chars
@@40:   mov     al,[Byte es:si]
        cmp     al,CR                   ; End of string?
        je      @@50
        mov     [Byte cs:di],al
        inc     si
        inc     di
        loop    @@40

        jmp     @@55                    ; String is to long


; Finished, set up String Length and String start
@@50:   pop     ax                      ; AX = Start of string
        sub     ax,si
        jz      @@10                    ; If length = 0, Write default string
        neg     ax                      ; AL = String length
        mov     [Byte cs:Len_String],al
        sub     al,40                   ; Screen length
        neg     al                      ; Center text
        shr     al,1
        mov     [Byte cs:Start_String],al
        jmp     @@10                    ; Write Cool Boot sector


; String is to long
@@55:   mov     dx,Offset Str_Err5
        jmp     Exit_Write



; Write MS-DOS boot sector instead
@@60:   inc     [Byte ds:Boot_S]        ; Set flagg


; Ok, Start
@@10:   call    Copy_BPB
        jc      Exit_Write              ; DX = String to write


; Try to write new boot sector
        mov     bx,Offset MS_DOS        ; Assume we shall write MS-DOS boot
        push    Offset Str_MSDOS        ; sector
        cmp     [Byte ds:Boot_S],1
        je      @@15                    ; Ok

        push    cs                      ; Write Cool Boot insted
        pop     ds
        mov     bx,Offset Cool_B
        pop     ax                      ; Remove offset to Str_MSDOS
        push    Offset Str_Cool


; DS:BX = Boot sector
@@15:   xor     al,al                   ; Drive 0 (A)
        mov     cx,1                    ; 1 Sector
        xor     dx,dx                   ; Write to sector 0
        int     26h
        mov     bx,Data_Seg             ; DS = Data Seg
        mov     ds,bx                   
        jnc     OK


; Disk error, Try to find out what happened
        add     sp,2*2                  ; Remove flags and message
        mov     dx,Offset Str_Err1
        or      al,al                   ; Write protect error code?
        jnz     Exit_Write              ; No, jump
        mov     dx,Offset Str_Err2
        jmp     Exit_Write


; It went fine
Ok:     popf   
        pop     dx                      ; String to write


Exit_Write:
        mov     ah,09h                  ; Write string in DX
        int     21h
        mov     ax,04C00h               ; Exit
        int     21h




;-------------------------------------
; Copy old BPB to new boot sector
;-------------------------------------
; In:   Nothing
;
; Out:  CY = 0, OK
;
;       CY = 1, Error
;       DX = Error string
;
; Regs: -
;-------------------------------------
Proc    Copy_BPB
        cmp     [Byte ds:Skipp_Copy],0
        jne     @@99
        
; Try to read boot sector from disk
        xor     al,al
        mov     cx,1
        xor     dx,dx
        mov     bx,Offset Buffer
        int     25h
        pop     bx                      ; Remove flaggs from stack
        jnc     @@10

; Disk error
        mov     dx,Offset Str_Err1
        ret


; Ok, copy data
@@10:   mov     si,Offset Buffer+11     ; BPB at offset 11
        mov     cx,51
        
        mov     di,Offset Cool_B+11     ; Assume we shall write to Cool Boot
        push    cs
        cmp     [Byte ds:Boot_S],0
        je      @@20
        
        mov     di,Offset MS_DOS+11     ; Write MS-DOS insted
        pop     ax                      ; Remove CS from stack
        push    ds

@@20:   pop     es
        rep     movsb
        clc
        ret


; Don't use disk orginal BPB so use our own BPB
@@99:   mov     ax,0040h                ; ES = BIOS data
        mov     es,ax

        mov     eax,[Dword es:06Ch]     ; Get Timer tick count
        shl     eax,16                  ; Try to get an unique number
        or      eax,[Dword es:06Ch]
        sub     ah,[Byte es:01Ah] 
        add     al,[Byte es:051h]
        mov     [Dword ds:MS_DOS+39],eax; Write serial number to MS-DOS's BPB
        mov     [Dword cs:39],eax       ; and to Cool Boot's BPB

        clc
        ret
EndP    Copy_BPB

EndS    Code_Seg



SEGMENT Data_Seg        Dword   Private         'DATA'          USE16

Str_Init        db      CR,LF,'-= Cool Boot v 1.0  -  Suicide Software (c) 96 =-',CR,LF,EOS
Str_Cool        db      CR,LF,"Writing new 'Cool' boot sector to A: , [Done]"
                db      CR,LF,'Fire code by Psychic Monk!',CR,LF,EOS
Str_MSDOS       db      CR,LF,"Writing old 'MS-DOS' boot sector to A: , [Done]",CR,LF,EOS
Str_Err1        db      CR,LF,'ERROR : No disk in drive, or terrible disk error',CR,LF,EOS
Str_Err2        db      CR,LF,'ERROR : The disk is write protected, stupid :)',CR,LF,EOS
Str_Err3        db      CR,LF,'ERROR : Your computer sucks, you need an 386 or better',CR,LF,EOS
Str_Err4        db      CR,LF,'ERROR : Invalid switch!  /? for help',CR,LF,EOS
Str_Err5        db      CR,LF,'ERROR : String is to long! Max 38 chars',CR,LF,EOS
Str_Help        db      CR,LF,'Cool Boot accepts ONE of the following switches'
                db      CR,LF,'/? = This help screen'
                db      CR,LF,'/D = Write MS-DOS boot sector'
                db      CR,LF,'/S:string = String to use (Max 38 chars)',CR,LF,EOS


Boot_S          db      0       ; 0 = Cool Boot, 1 = MS-DOS
Skipp_Copy      db      0       ; 0 = Copy BPB, 1 = Don't do it


; Standard MS-DOS (5.0) boot sector (Used in all version from 5.0 -> 6.22)
; I don't know anything about DOS 7.0, Yet ;)
MS_DOS  db      235,060,144,077,083,068,079,083,053,046,048,000,002,001
        db      001,000,002,224,000,064,011,248,009,000,018,000,002,000
        db      000,000,000,000,000,000,000,000,000,000,041,236,011,073
        db      011,078,079,032,078,065,077,069,032,032,032,032,070,065
        db      084,049,050,032,032,032,250,051,192,142,208,188,000,124
        db      022,007,187,120,000,054,197,055,030,086,022,083,191,062
        db      124,185,011,000,252,243,164,006,031,198,069,254,015,139
        db      014,024,124,136,077,249,137,071,002,199,007,062,124,251
        db      205,019,114,121,051,192,057,006,019,124,116,008,139,014
        db      019,124,137,014,032,124,160,016,124,247,038,022,124,003
        db      006,028,124,019,022,030,124,003,006,014,124,131,210,000
        db      163,080,124,137,022,082,124,163,073,124,137,022,075,124
        db      184,032,000,247,038,017,124,139,030,011,124,003,195,072
        db      247,243,001,006,073,124,131,022,075,124,000,187,000,005
        db      139,022,082,124,161,080,124,232,146,000,114,029,176,001
        db      232,172,000,114,022,139,251,185,011,000,190,230,125,243
        db      166,117,010,141,127,032,185,011,000,243,166,116,024,190
        db      158,125,232,095,000,051,192,205,022,094,031,143,004,143
        db      068,002,205,025,088,088,088,235,232,139,071,026,072,072
        db      138,030,013,124,050,255,247,227,003,006,073,124,019,022
        db      075,124,187,000,007,185,003,000,080,082,081,232,058,000
        db      114,216,176,001,232,084,000,089,090,088,114,187,005,001
        db      000,131,210,000,003,030,011,124,226,226,138,046,021,124
        db      138,022,036,124,139,030,073,124,161,075,124,234,000,000
        db      112,000,172,010,192,116,041,180,014,187,007,000,205,016
        db      235,242,059,022,024,124,115,025,247,054,024,124,254,194
        db      136,022,079,124,051,210,247,054,026,124,136,022,037,124
        db      163,077,124,248,195,249,195,180,002,139,022,077,124,177
        db      006,210,230,010,054,079,124,139,202,134,233,138,022,036
        db      124,138,054,037,124,205,019,195,013,010,078,111,110,045
        db      083,121,115,116,101,109,032,100,105,115,107,032,111,114
        db      032,100,105,115,107,032,101,114,114,111,114,013,010,082
        db      101,112,108,097,099,101,032,097,110,100,032,112,114,101
        db      115,115,032,097,110,121,032,107,101,121,032,119,104,101
        db      110,032,114,101,097,100,121,013,010,000,073,079,032,032
        db      032,032,032,032,083,089,083,077,083,068,079,083,032,032
        db      032,083,089,083,000,000,085,170

Buffer          db      512 Dup(?)      ; Buffer to hold old boot sector

EndS    Data_Seg



SEGMENT Stack_Seg       Para    Stack           'STACK'         USE16
        dw      64 Dup (?)      ; A 64 words stack
EndS    Stack_Seg

        End     Start
