// $Id: GRAFIC.H 1.1 1995/12/08 20:33:45 Mihai_Moldovanu Exp $
/*
        VESA 640x480x256 lib

**********************************************************************
        0.      TestVesa()       // only pentru 640x480x256
        1.      SetVideoMode( void )
        1.5     SetTextMode( void )
no      2.      SetDrawPage( page )
no      3.      SetVisualPage( page)
        4.      PutImage( x, y, image * buffer)
        4.5     PutSprite( x, y, unsigned char * buffer)
        5.      PutText(x, y, char * string, color )
        6.      SetFont( font_nr )
        7.      Line(x1, y1, x2, y2, color )
        8.      SetBank( nr )      Are rost numai in SVGA ;
                           altfel organizare planara
        9.      SetPalette( char * p768 )
        10.      FillBox( x1 , y1 , x2 , y2 , color);
        11.      PutPixel(  x , y , color )
***********************************************************************/
#ifndef VesaGraphicInterface
#define VesaGraphicInterface

     #include   <i86.h>
     #include   <dos.h>
     #include   <stdio.h>
     #include   <stdlib.h>
     #include   <conio.h>

// constante
#define         VESAMODE        0x101   // 640x480x256
#define         MAXFNT          2       // numarul de fonturi disponibile
#define         MAXX            640
#define         MAXY            480


// external :
extern int Blocks;
extern unsigned int     VideoModePtr;
extern unsigned short   Xres ;
extern unsigned short   Yres ;
extern unsigned short   BytesPerLine ;
extern unsigned char    MemModel;
extern unsigned char    BitsPerPixel ;
extern unsigned short   WinGran ;
extern unsigned short   WinSize ;
extern unsigned int     WinFuncPtr ;
extern unsigned int     SwitchBank ;
extern char             NumberOfBanks ;
extern char             BankSize ;

extern int      hchar;

// structuri de date pentru VESA
// Used by function 00h

#pragma pack (1)

typedef struct
        {
            char                VESASignature[4];
            unsigned short      VESAVersion;
            char *              OEMStringPtr;   // dd
            unsigned char       Capabilities[4];
            unsigned int        VideoModePtr;   // dd
            unsigned short      TotalMemory;
            unsigned char       Reserved[236];
        } VgaInfoBlock;


/* SuperVGA mode information block */
// Used by 01h
typedef struct {
    short   ModeAttributes;         /* Mode attributes                  */
    char    WinAAttributes;         /* Window A attributes              */
    char    WinBAttributes;         /* Window B attributes              */
    short   WinGranularity;         /* Window granularity in k          */
    short   WinSize;                /* Window size in k                 */
    short   WinASegment;            /* Window A segment                 */
    short   WinBSegment;            /* Window B segment                 */
    unsigned int    WinFuncPtr;            /* Far pointer to window function   OBS: dd*/
    short   BytesPerScanLine;       /* Bytes per scanline               */
    short   XResolution;            /* Horizontal resolution            */
    short   YResolution;            /* Vertical resolution              */
    char    XCharSize;              /* Character cell width             */
    char    YCharSize;              /* Character cell height            */
    char    NumberOfPlanes;         /* Number of memory planes          */
    char    BitsPerPixel;           /* Bits per pixel                   */
    char    NumberOfBanks;          /* Number of CGA style banks        */
    char    MemoryModel;            /* Memory model type                */
    char    BankSize;               /* Size of CGA style banks          */
    char    NumberOfImagePages;     /* Number of images pages           */
    char    res1;                   /* Reserved                         */
    char    RedMaskSize;            /* Size of direct color red mask    */
    char    RedFieldPosition;       /* Bit posn of lsb of red mask      */
    char    GreenMaskSize;          /* Size of direct color green mask  */
    char    GreenFieldPosition;     /* Bit posn of lsb of green mask    */
    char    BlueMaskSize;           /* Size of direct color blue mask   */
    char    BlueFieldPosition;      /* Bit posn of lsb of blue mask     */
    char    RsvdMaskSize;           /* Size of direct color res mask    */
    char    RsvdFieldPosition;      /* Bit posn of lsb of res mask      */
    char    DirectColorModeInfo;    /* Direct color mode attributes     */
    char    res2[216];              /* Pad to 256 byte block size       */
    } ModeInfoBlock;

// Bitmap Structure
typedef struct
        {
            unsigned short xsize;
            unsigned short ysize;
            unsigned char * buf;        /* Imaginea linie cu linie      */
        } Image;

#pragma pack ()

/**********************************************************************/

// Primitive generale

/**********************************************************************/

int    TestVesa( void );
void Eroare( int cod_err );
void SetVideoMode( void );
void SetTextMode( void );

void SetBank( int nr );

// Page setting functions
void SetDrawPage( unsigned int page );
void SetVisualPage( unsigned int page );

// Like a sprite
void PutImage(  unsigned short x, unsigned short y,
                Image * buffer );
#pragma aux PutImage parm [EAX] [EBX] [ESI];

// Pune in buffer
void GetImage(  unsigned short x, unsigned short y,
                Image * buffer );
#pragma aux GetImage parm [EAX] [EBX] [ESI];

// Text function
void SetFont( int font_nr );
#pragma aux SetFont parm [EAX];

void PutText( unsigned short x, unsigned short y,
              char * string , unsigned char color);

// Alg. Bresenham
void Line( unsigned short x1, unsigned short y1,
           unsigned short x2, unsigned short y2, unsigned char color );
#pragma aux Line parm [EAX] [EBX] [ECX] [EDX] [ESI];

// Setare paleta de 256 culori ( toata )
void SetPalette( unsigned char * pal_buf );

// Umple dreptunghi
void FillBox( unsigned short x1, unsigned short y1,
              unsigned short x2, unsigned short y2, unsigned char color );
#pragma aux FillBox parm [EAX] [EBX] [ECX] [EDX] [ESI];

// Pune pixel pe jos
void PutPixel(  unsigned short  x,
                unsigned short y, unsigned char color);
#pragma aux PutPixel parm [EBX] [EAX] [ECX];

// Ia pixel de pe jos
int GetPixel(  unsigned short  x,
                unsigned short y );
#pragma aux GetPixel parm [EBX] [EAX];

// Smash a sprite
void PutSprite(  unsigned short x, unsigned short y,
                 Image * buffer );
#pragma aux PutSprite parm [EAX] [EBX] [ESI]

// ************ Functii auxiliare **************

// seteaza paleta  incepind de la Start, Cate pozitii
void SetPaletteNo(      unsigned char * pal_buf ,
                        unsigned char start ,
                        unsigned char cate );
#pragma aux SetPaletteNo parm [ESI] [EAX] [ECX]

// pune un caracter pe ecran SI intoarce latimea lui.
int PutChar(    unsigned short x,
                unsigned short y,
                char ch );
#pragma aux PutChar parm [EAX] [EBX] [ECX];

#endif