{ͻ}
{      -- THIS FILE IS PART OF THE LIVESYSTEMS COMPRESSOR TOOLBOX. --      }
{          ALL RIGHTS RESERVED  (C) COPYRIGHTED G. HOOGTERP 1994           }
{                                                                          }
{             See the documentation for details on the license.            }
{                                                                          }
{ͼ}

{
This is a demo of what you can do with the CompSys toolbox.
}


Unit CompFile;
Interface
Uses Dos,
     CompSys;

{$I STRUCT.PAS}

Type FileNameStr = String[12];

Type HandleCompressedFileObject = Object
       Magic                    : MagicTypes;
       Prog                     : ComStr;
       CommLine                 : ComStr;
       FileName                 : ComStr;
       TempDir                  : ComStr;
       Error                    : Integer;

       Constructor              Init(_Filename : ComStr;Tmp : ComStr);
       Procedure                Decompress;
       Procedure                Compress(MakeMagic : MagicTypes);
       Function                 HCError:Integer;

       Procedure                DoShell; Virtual;
       Procedure                WhichMagic;
       Procedure                FindProgram(Name : ComStr;Params : String);
       Function                 FillInVar(Variable : Byte;S : String;Value : String):String;
     End;


Implementation

Constructor HandleCompressedFileObject.Init(_FileName : ComStr;Tmp : ComStr);
Begin
Error:=0;
Filename:=_Filename;
TempDir:=Tmp;
Prog:='';
CommLine:='';
WhichMagic;
End;


Procedure HandleCompressedFileObject.DoShell;
Begin
SwapVectors;
Exec(Prog,Commline);
SwapVectors;
Error:=DosError;
If Error=0
   Then Error:=DosExitCode;
End;

Procedure HandleCompressedFileObject.WhichMagic;
Var Temp : CompressorType;
Begin
Magic:=None;
If Not DetectCompressor(FileName,Temp)
   Then Exit;
Magic:=MagicTypes(Temp^.Magic);
End;

Function HandleCompressedFileObject.HCError:Integer;
Begin
HCError:=Error;
Error:=0;
End;


Procedure HandleCompressedFileObject.FindProgram(Name : ComStr;Params : String);
Begin
CommLine:=Params;
Prog:=FSearch(Name,GetEnv('PATH'));
End;

Function HandleCompressedFileObject.FillInVar(Variable : Byte;S : String;Value : String):String;
Var ZStr : String[5];
    P    : Byte;
Begin
If Variable>9
   Then Exit;
ZStr:='%'+Chr(Variable+48);
P:=Pos(ZStr,S);
If P>0
   Then Begin
        Delete(S,P,2);
        Insert(Value,S,P);
        End;
FillInVar:=S;
End;


Procedure HandleCompressedFileObject.Decompress;
Var Temp : String;
Begin
Case Magic Of
  None       : Prog:='';
  ARC_Type   : Begin
               FindProgram('PKXARC.EXE','%0');
               If Prog=''
                  Then FindProgram('PAK.EXE','E %0');
               End;

  ARJ_Type    : FindProgram('ARJ.EXE','e %0 %1');
  DWC_Type    : FindProgram('DWC.EXE','');
  Hyp_Type    : FindProgram('HYPER.EXE','e %0 %1');
  LHA_Type    : FindProgram('LHA.EXE','e %0 %1');
  MDCD_Type   : FindProgram('MDCD.EXE','e %0 %1');
  ZIP_Type    : FindProgram('PKUNZIP.EXE','%0 %1');
  SQZ_Type    : FindProgram('SQZ.EXE','e %0 %1');
  ZOO_Type    : FindProgram('ZOO.EXE','e %0 %1');
  RAR_Type    : FindProgram('RAR.EXE','e %0 %1');
End; {Case}
CommLine:=FillInVar(0,CommLine,FileName);
CommLine:=FillInVar(1,CommLine,TempDir);
End;

Procedure HandleCompressedFileObject.Compress(MakeMagic : MagicTypes);
Var Temp : String;
Begin
Case MakeMagic Of
  None       : Prog:='';
  ARC_Type   : Begin
               FindProgram('PKARC.EXE','%0');
               If Prog=''
                  Then FindProgram('PAK.EXE','A %0');
               End;

  ARJ_Type    : FindProgram('ARJ.EXE','a %0 %1');
  DWC_Type    : FindProgram('DWC.EXE','');
  Hyp_Type    : FindProgram('HYPER.EXE','a %0 %1');
  LHA_Type    : FindProgram('LHA.EXE','a %0 %1');
  MDCD_Type   : FindProgram('MDCD.EXE','a %0 %1');
  ZIP_Type    : FindProgram('PKZIP.EXE','%0 %1');
  SQZ_Type    : FindProgram('SQZ.EXE','a %0 %1');
  ZOO_Type    : FindProgram('ZOO.EXE','a %0 %1');
  RAR_Type    : FindProgram('RAR.EXE','a %0 %1');
End; {Case}
CommLine:=FillInVar(0,CommLine,FileName);
CommLine:=FillInVar(1,CommLine,TempDir);
End;
End.
