/*
	Buttom draw routines
	made by Ismo Horppu on 1996 - 1997
	- coming soon color select
*/

#include "m320x200.h"
#include "font.h"
#include "ct2but.h"

// Draws unpressed or pressed button
void DrawButton (int x, int y, int w, int h, unsigned char pressFlag)
{
	int sx, sy;
	
	if (pressFlag == 1){
		DrawTopColor = BottomColor;
		DrawBottomColor = TopColor;
		DrawFillColor = BottomFillColor;
	}

	else{
		DrawTopColor = TopColor;
		DrawBottomColor = BottomColor;
		DrawFillColor = TopFillColor;
	}
	
	for (sy = y + 1; sy < y + h - 1; sy++){
		for (sx = x + 1; sx < x + w - 1; sx++){
			PutPixel (sx, sy, DrawFillColor, VB);
		}
	}
	
	for (sx = x; sx < x + w; sx++){
		PutPixel (sx, y, DrawTopColor, VB);
	}
	
	for (sx = x; sx < x + w; sx++){
		PutPixel (sx, y + h - 1, DrawBottomColor, VB);
	}
	
	for (sy = y; sy < y + h - 1; sy++){
		PutPixel (x, sy, DrawTopColor, VB);
	}
	
	for (sy = y + 1; sy < y + h; sy++){
		PutPixel (x + w - 1, sy, DrawBottomColor, VB);
	}
}

// Draws texted unpressed or pressed button
void DrawTextedButton (int x, int y, int w, int h, unsigned char pressFlag, char *string)
{
	int sx, sy;
	
	if (pressFlag == 1){
		DrawTopColor = BottomColor;
		DrawBottomColor = TopColor;
		DrawFillColor = BottomFillColor;
	}

	else{
		DrawTopColor = TopColor;
		DrawBottomColor = BottomColor;
		DrawFillColor = TopFillColor;
	}
	
	for (sy = y + 1; sy < y + h - 1; sy++){
		for (sx = x + 1; sx < x + w - 1; sx++){
			PutPixel (sx, sy, DrawFillColor, VB);
		}
	}
	
	for (sx = x; sx < x + w; sx++){
		PutPixel (sx, y, DrawTopColor, VB);
	}
	
	for (sx = x; sx < x + w; sx++){
		PutPixel (sx, y + h - 1, DrawBottomColor, VB);
	}
	
	for (sy = y; sy < y + h - 1; sy++){
		PutPixel (x, sy, DrawTopColor, VB);
	}
	
	for (sy = y + 1; sy < y + h; sy++){
		PutPixel (x + w - 1, sy, DrawBottomColor, VB);
	}
	
	DisplayString (string, x + 2, y + 2);
}

// Draws texted unpressed or pressed button
void DrawTextedButton2 (int x, int y, int w, int h, unsigned char pressFlag, char *string, int ha)
{
	int sx, sy;
	
	if (pressFlag == 1){
		DrawTopColor = BottomColor;
		DrawBottomColor = TopColor;
		DrawFillColor = BottomFillColor;
	}

	else{
		DrawTopColor = TopColor;
		DrawBottomColor = BottomColor;
		DrawFillColor = TopFillColor;
	}
	
	for (sy = y + 1; sy < y + h - 1; sy++){
		for (sx = x + 1; sx < x + w - 1; sx++){
			PutPixel (sx, sy, DrawFillColor, VB);
		}
	}
	
	for (sx = x; sx < x + w; sx++){
		PutPixel (sx, y, DrawTopColor, VB);
	}
	
	for (sx = x; sx < x + w; sx++){
		PutPixel (sx, y + h - 1, DrawBottomColor, VB);
	}
	
	for (sy = y; sy < y + h - 1; sy++){
		PutPixel (x, sy, DrawTopColor, VB);
	}
	
	for (sy = y + 1; sy < y + h; sy++){
		PutPixel (x + w - 1, sy, DrawBottomColor, VB);
	}
	
	DisplayString (string, x + 2, y + 2 + ha);
}

// Draws unpressed or pressed button edges
void DrawButtonEdges (int x, int y, int w, int h, unsigned char pressFlag)
{
	int sx, sy;
	
	if (pressFlag == 1){
		DrawTopColor = BottomColor;
		DrawBottomColor = TopColor;
		DrawFillColor = BottomFillColor;
	}

	else{
		DrawTopColor = TopColor;
		DrawBottomColor = BottomColor;
		DrawFillColor = TopFillColor;
	}
	
	for (sx = x; sx < x + w; sx++){
		PutPixel (sx, y, DrawTopColor, VB);
	}
	
	for (sx = x; sx < x + w; sx++){
		PutPixel (sx, y + h - 1, DrawBottomColor, VB);
	}
	
	for (sy = y; sy < y + h - 1; sy++){
		PutPixel (x, sy, DrawTopColor, VB);
	}
	
	for (sy = y + 1; sy < y + h; sy++){
		PutPixel (x + w - 1, sy, DrawBottomColor, VB);
	}
}

void SetButtonColors (BYTE NewTopColor, BYTE NewBottomColor, BYTE NewTopFillColor, BYTE NewBottomFillColor)
{
	TopColor = NewTopColor;
	BottomColor = NewBottomColor;
	TopFillColor = NewTopFillColor;
	BottomFillColor = NewBottomFillColor;
}