signed long InitCADD (void);
signed long FreeCADD (void);

char textline[80];
char grabtext[80];
char itemtext[80];

class Country{

public:
	char Name[32];
	Country *Next;
	Country *CountryFirst, *CountryCurrent, *CountryLast;
	Country ();
	signed long AddCountry ();	
	signed long FreeCountries ();
	signed long DisplayNames ();
	signed long SearchCountry (char *CountryName);
	char *ReturnCountry (signed long countryindex);
	signed long countries;
};

/*
	coming soon recoil support & scope support (aim bonus)
*/
class Weapon{

public:
	char Name[32];
	signed long HitAccuracy;
	signed long Damage;
	signed long Peneration;
	signed long Cost;
	signed long MagSize;
	signed long MagType;
	signed long MagCost;
	signed long Cost1;
	signed long Cost2;
	signed long WeaponType;
	signed long FireType;
	signed long MalFunction;
	signed long Country;
	signed long DamageLoss;
	signed long HitAccuracyLoss;
	signed long Weight;
	Weapon *Next;
	Weapon *WeaponFirst, *WeaponCurrent, *WeaponLast, *WeaponSelected;
	Weapon ();
	signed long AddWeapon ();
	signed long FreeWeapons ();
	signed long DisplayWeaponInfo (signed long weapon_index);
	char *GetName (signed long weaponindex);
	signed long Select (signed long weapon_index);
	signed long weapons;
};

class Team{

public:
	char name[32];
	signed long AddTeam ();
	signed long FreeTeams ();
	signed long SelectCurrentTeam (signed long teamindex);
	signed long DeleteTeam (signed long teamindex);

	Team ();
	Team *TeamFirst, *TeamCurrent, *TeamLast;
	Team *Next;
	signed long teams;
	signed long teamsoldiers;
	signed long money;
	signed long country;
	signed long ID;
	signed long activesoldiers;
};

class Name{

public:
	signed long Country;
	char FirstName[16];
	char SurName[16];	
	Name ();
	signed long AddName ();
	signed long FreeNames ();
	signed long GenerateAllPossibleNames ();
	signed long GetName (signed long firstindex, signed long surindex);
	signed long DisplayNames ();
	signed long GetNameCountry (signed long nameindex);
	char *GetFirstName (signed long nameindex);
	char *GetSurName (signed long nameindex);

	Name *Next;
	Name *NameFirst, *NameCurrent, *NameLast;
	signed long names;
};

/*
	Soldier class prototype
*/
class Soldier{

public:
	signed long Team;
	signed long FirstName;		// linked name list entry
	signed long SurName;		// linked name list entry
	signed long HP[7];			// hit points for 7 body parts

	/*
		body parts are:
		0 - head (str + con), head has 2 hit "parts" and
		hits to head are very deadly (2-3x normal damage!)
		1 - left arm (str + con) * 2
		2 - right arm
		3 - chest (str + con) * 3
		4 - abdomen
		5 - left leg
		6 - right leg
	*/
	
	signed long Weapon;		// linked weapon list entry
	signed long Ammo;			// total ammo
	signed long Inmag;			// in magazine ammo
	signed long APs;			// moving points
	signed long Strength;
	signed long Constitution;
	signed long Kills;			// kills
	signed long Experience;	// experience points... 
	signed long Rank;			// rank (can be, 0=NOVICE, 1=GREEN, 2=VETERAN, 3=ELITE)
	signed long Cost;			// buy/sell price
	signed long Load;			// soldier's load in KGs
	signed long FireSkill;

	Soldier ();
	signed long AddSoldier (void);
	signed long FreeSoldiers (void);
	signed long GenerateSoldier (signed long country, signed long mixednames);
	signed long DisplaySoldierInfo (signed long index);
	signed long DeleteSoldier (signed long soldierindex);
	signed long SelectSoldier (signed long index);

	Soldier *Next;	// not used
	Soldier *SoldierFirst, *SoldierCurrent, *SoldierLast;
	Soldier *SoldierSelected;
	signed long soldiers;	// not used
	signed long active;
};

#define HEAD_HPS 0
#define CHEST_HPS 1
#define LEFTARM_HPS 2
#define RIGHTARM_HPS 3
#define ABDOMEN_HPS 4
#define LEFTLEG_HPS 5
#define RIGHTLEG_HPS 6

class Country *CaddCountry;
class Weapon *CaddWeapon;
class Team *CaddTeam;
class Name *CaddName;
class Soldier *CaddSoldier;	// used in soldier generate routine
class Soldier *CaddGeneratedSoldier;

signed long itempos = 0;
signed long itemindex = 0;

#define FIRE_TYPES 8

char *FireType[FIRE_TYPES] = {
	"SS",		// singleshot
	"PA",		// pump-action
	"SA",		// semiautomatic
	"BURST3",	// 3-burst
	"BURST5",	// 5-burst
	"BURST10",	// 10-burst
	"SUB_BURST3", // submachine 3-burst
	"SUB_BURST5"	// submachine 5-burst
};

#define WEAPON_TYPES 5

char *WeaponType[WEAPON_TYPES] = {
	"PISTOL",
	"RIFLE",
	"SHOTGUN",
	"SUBMACHINEGUN",
	"ASSAULTRIFLE"
};

#define BODYPARTS 7
char *BodyParts[BODYPARTS] = {
	"HEAD",
	"CHEST",
	"LEFT ARM",
	"RIGHT ARM",
	"ABDOMEN",
	"LEFT LEG",
	"RIGHT LEG"
};

#define RANKS 4

char *Ranks[RANKS] = {
	"GREEN",
	"NOVICE",
	"VETERAN",
	"ELITE"
};

long RankLimit[RANKS] = {
	0,
	250,
	500,
	750
};

signed long oc1, oc2;
signed long lstr, lcon;

signed long DuplicateGeneratedSoldier (signed long target);

char *FID = "CTF";

char inited = 0;
char CADDinit[5] = {
	-1,
	-1,
	-1,
	-1,
	-1
};

signed long FreeTeam (void);
FILE *tf;
