/*
	Combat Team 2 - Scroller by Ismo Horppu on 1996 - 1997
*/

#include <conio.h>
#include <go32.h>
#include <stdio.h>
#include <stdlib.h>
#include <pc.h>
#include "m320x200.h"
#include "font.h"
#include "timer.h"
#include "emouse.h"
#include "kb.h"
#include "credit.h"
#include "sfield.h"

/*
	initializes credit scroller
*/
int InitCreditScroller (void)
{
	if ((ptr = (BYTE *) malloc (VIRTUAL_SCREENS * 64000)) == NULL){
		printf ("Not enough memory for virtual screens\n");
		return -1;
	}
	
	ClearVB (ptr);	
	ClearVB (ptr + 64000);
	return 0;
}

// frees virtual screens pointer
void FreeCreditScroller (void)
{
	free (ptr);
}

// makes new line
void make_line (long dy, BYTE *xptr, BYTE col)
{
	long c;
	
	for (c = 0; c < 320; c++){
		PutPixel (c, dy, col, xptr);
	}
}

void clear_line (long dy, BYTE *xptr)
{
	long c;
	
	for (c = 0; c < 320; c++){
		PutPixel (c, dy, 0, xptr);
	}
}

int xcomp (char *str, char *dest)
{
	int c, good;

	good = 0;
	if (strlen (str) != strlen (dest)) return 0;

	for (c = 0; c < strlen (str); c++){
		if (dest[c] == str[c]) good++;
	}

	if (good == strlen (dest)) return 1;
	return 0;
}

int CheckSpecialCommand (char *dest)
{
	char c, good = 0;
	int stat;
	
	stat = xcomp (scroll_text[text_line], dest);
	return stat;
}

/*
	scrolls credit up by one line
*/
void ScrollOneLineUp (void)
{
	while ((inportb (0x3da) & 8) == 0);
	while ((inportb (0x3da) & 8) == 1);
	while ((inportb (0x3da) & 8) == 0);
	RefreshVRAM (ptr + (ComingY + 1) * 320UL);
	
	clear_line (ComingY, ptr);
	
	if (font_line != -1){
		if (CheckSpecialCommand (scommand[0])){
				DisplayCustomString (skip_text, 0, ComingY, font_line, ptr);
		}
	
		else{
			if (font_line != 6){
				DisplayCustomString (scroll_text[text_line], 0, ComingY, font_line, ptr);
			}
		}
	}
	
	ComingY--;
	clear_line (BackupY - 200, ptr + 64000UL);
	
	if (font_line != -1){
		if (CheckSpecialCommand (scommand[0])){
				DisplayCustomString (skip_text, 0, BackupY - 200, font_line, ptr + 64000UL);
		}
		
		else{
			if (font_line != 6){
				DisplayCustomString (scroll_text[text_line], 0, BackupY - 200, font_line, ptr + 64000UL);
			}
		}
	}
	
	BackupY--;
	dist++;
	
	if (dist >= 200){
		dist = 0;
		ComingY = 199;
		BackupY = 399;
	}
}

void ScrollOneLineDown (void)
{
	while ((inportb (0x3da) & 8) == 0);
	while ((inportb (0x3da) & 8) == 1);
	while ((inportb (0x3da) & 8) == 0);
	RefreshVRAM (ptr + (ComingY - 200) * 320UL);
	
	clear_line (ComingY - 200, ptr + 64000UL);
	
	if (CheckSpecialCommand (scommand[0])){
			if (font_line != 6){
				DisplayCustomString (skip_text, 0, ComingY - 200, font_line, ptr + 64000UL);
			}
	}
	
	else{
		if (font_line != 6){
			DisplayCustomString (scroll_text[text_line], 0, ComingY - 200, font_line, ptr + 64000UL);
		}
	}
	
	ComingY++;
	clear_line (BackupY, ptr);
	
	if (CheckSpecialCommand (scommand[0])){
			if (font_line != 6){
				DisplayCustomString (skip_text, 0, BackupY, font_line, ptr);
			}
	}
	
	else{
		if (font_line != 6){
			DisplayCustomString (scroll_text[text_line], 0, BackupY, font_line, ptr);
		}
	}
	
	BackupY++;
	dist++;
	
	if (dist >= 200){
		dist = 0;
		ComingY = 200;
		BackupY = 0;
	}
}

// start credit scroll
void StartScrollerUp (void)
{
	long l = 0;
	char released = 0;

	text_line = 0;
	pause_cnt = 0;
	ComingY = 199;	// start y
  BackupY = 399;	// save Y
	dist = 0;
	font_line = 5;
	
	ClearVB (ptr);	
	ClearVB (ptr + 64000);
	
	timer_ticks = 0;
	timer_start = 1;
	
	while (1){
		if (!no_key()) return;
		UpdateMouse ();
		if (mouseb == 0) released = 1;
		if (mouseb != 0 && released == 1) return;
		
		if (timer_ticks >= 1000 / scroll_fps){
			ScrollOneLineUp ();
			font_line--;
			
			if (font_line < -1){
				pause_cnt--;
				font_line = 5;

				if (pause_cnt <= 0){
					text_line++;
					if (text_line > SCROLL_LENGTH - 1) text_line = SCROLL_LENGTH - 1;
					
					if (CheckSpecialCommand (scommand[0])){
						pause_cnt = 10;
					}
					
					else pause_cnt = 0;
					
					if (CheckSpecialCommand (scommand[1])){
						text_line++;
						t1 = atoi (scroll_text[text_line]);
						text_line++;
						t2 = atoi (scroll_text[text_line]);
						ShadeFont (t1, t2);
						text_line++;
					}
				}
			}
			
			timer_ticks = 0;
			l++;
		}
		
		if (l > SCROLLER_LINES) break;
	}
}

// start credit scroll
void StartScrollerDown (void)
{
	long l = 0;
	char released = 0;
	
	dist = 0;
	text_line = 0;
	pause_cnt = 0;
	ComingY = 200;	// start y
  BackupY = 0;	// save Y
	font_line = 0;
	ClearVB (ptr);	
	ClearVB (ptr + 64000);
	
	timer_ticks = 0;
	timer_start = 1;
	
	InitStars ();
	
	while (1){
		if (!no_key()) return;
		UpdateMouse ();
		if (mouseb == 0) released = 1;
		if (mouseb != 0 && released == 1) return;
		
		if (timer_ticks >= 1000 / scroll_fps){
			ScrollOneLineDown ();
			DrawStars ();
			MoveStars ();
			font_line++;
			
			if (font_line > 6){
				font_line = 0;
				pause_cnt--;
				
				if (pause_cnt <= 0){
					text_line++;
					if (text_line > SCROLL_LENGTH - 1) text_line = SCROLL_LENGTH - 1;
					
					if (CheckSpecialCommand (scommand[0])){
						pause_cnt = 10;
					}
					
					else pause_cnt = 0;
					
					if (CheckSpecialCommand (scommand[1])){
						text_line++;
						t1 = atoi (scroll_text[text_line]);
						text_line++;
						t2 = atoi (scroll_text[text_line]);
						ShadeFont (t1, t2);
						text_line++;
					}
				}
			}
			
			timer_ticks = 0;
			l++;
		}
		
		if (l > SCROLLER_LINES) break;
	}
}