
/*
	Combat Team II defines
*/

#define BlockWidth 32
#define BlockHeight 64

#define MapWidth 64
#define MapHeight 64
#define Zlevels 4
#define Blocks 60 * 8
#define RealBlocks 60

/*
	real soldier sprite = direction * 7 + frame + light_level * 56
	team = 448 frames (7 * 8 * 8)
*/
#define Sprites 28 * 8 * 2 * 4	// 7 * 4 * 8 * 2
#define RealSprites 28 // 7 * 8

#define BlockWidth 32
#define BlockHeight 64

#define PLAYERS 4
#define MAX_START 8

extern BYTE Map[MapWidth][MapHeight][Zlevels];
extern BYTE Object[MapWidth][MapHeight][Zlevels];
extern BYTE LightLevel[MapWidth][MapHeight][Zlevels];
extern BYTE *blockPTR;
extern BYTE *spritePTR;
extern BYTE *artPTR;
extern BYTE PlayerStartX[MAX_START][PLAYERS];
extern BYTE PlayerStartY[MAX_START][PLAYERS];
extern BYTE PlayerStartZ[MAX_START][PLAYERS];
extern BYTE AnimFrame[MAX_START][PLAYERS];
extern BYTE AnimSpr[MAX_START][PLAYERS];

#define MAX_KEYS 15
extern BYTE keys[MAX_KEYS];

extern BYTE scard;	// 0, 1, 2, 3
extern WORD sc_base;	// 0x210 - 0x280
extern BYTE sc_dma_lo;	// 0 - 3
extern BYTE sc_dma_hi;	// 4 - 7
extern BYTE sc_irq;	// 0 - 15 (2, 3, 5, 7)
extern BYTE sc_type;
extern BYTE sc_ai;

extern int APs[PLAYERS][MAX_START];

extern int enemies;
extern int enemyX[PLAYERS * MAX_START];
extern int enemyY[PLAYERS * MAX_START];
extern int enemyZ[PLAYERS * MAX_START];
extern int enemyR[PLAYERS * MAX_START];
//extern int soldier_visible[PLAYERS][MAX_START];
//extern int soldier_health[PLAYERS][MAX_START];

extern int default_players;
extern int sound_amplify;
extern int brightness;
	
extern int health[PLAYERS][MAX_START];
extern int weapon[32];
extern BYTE ammo[32];

extern BYTE *pic1_ptr;

extern BYTE selectPTR[16][16];
extern BYTE targetPTR[16][16];

#define HUMAN 1
#define COMPUTER 2
extern BYTE player_type[PLAYERS];
#define WOUNDS 4
extern char *WoundType[WOUNDS];
