/*
	Combat Team II general extern header
*/

#include "types.h"

#ifndef CT2EGEN
#define CT2EGEN

#define MapWidth 64
#define MapHeight 64
#define Zlevels 4
#define Blocks 60 * 8
#define RealBlocks 60

#define BlockWidth 32
#define BlockHeight 64
#define PalEntries 768

#define MousePointers 5
#define MousePointerWidth 16
#define MousePointerHeight 16

#define Sprites 28 * 8 * 2 * 4	// 7 * 4 * 8
#define RealSprites 28 // 7 * 4

#define Walkable 1
#define Seeable 2
#define SWable 4
#define Riseable 16
#define RWable 32
#define NoBlock 8

#define PLAYERS 4
#define MAX_START 8

extern BYTE Palette[PalEntries];
extern BYTE Map[MapWidth][MapHeight][Zlevels];
extern BYTE LightLevel[MapWidth][MapHeight][Zlevels];
extern BYTE Object[MapWidth][MapHeight][Zlevels];
extern BYTE *blockPTR;
extern BYTE *VB;
extern BYTE *mousePTR;
extern BYTE *menuPTR;
extern BYTE *spritePTR;
extern BYTE *artPTR;
extern FILE *f;
extern DWORD virtual_buffer_offset;
extern int popmenu;
extern int popx, popy;
extern unsigned int dos_seg;
extern _go32_dpmi_seginfo VirtualBuffer;
extern BYTE BlockFlags[RealBlocks];
extern BYTE PlayerStartX[MAX_START][PLAYERS];
extern BYTE PlayerStartY[MAX_START][PLAYERS];
extern BYTE PlayerStartZ[MAX_START][PLAYERS];
extern BYTE AnimFrame[MAX_START][PLAYERS];
extern BYTE AnimSpr[MAX_START][PLAYERS];

#define MAX_KEYS 15
extern BYTE keys[MAX_KEYS];

extern BYTE scard;	// 0, 1, 2, 3
extern WORD sc_base;	// 0x210 - 0x280
extern BYTE sc_dma_lo;	// 0 - 3
extern BYTE sc_dma_hi;	// 4 - 7
extern BYTE sc_irq;	// 0 - 15 (2, 3, 5, 7)
extern BYTE sc_type;
extern BYTE sc_ai;

extern int APs[PLAYERS][MAX_START];

extern int enemies;
extern int enemyX[PLAYERS * MAX_START];
extern int enemyY[PLAYERS * MAX_START];
extern int enemyZ[PLAYERS * MAX_START];
extern int enemyR[PLAYERS * MAX_START];
//extern int soldier_visible[PLAYERS][MAX_START];
//extern int soldier_health[PLAYERS][MAX_START];

extern int default_players;
extern int sound_amplify;
extern int brightness;

extern int health[PLAYERS][MAX_START];
extern int weapon[32];
extern BYTE ammo[32];

extern BYTE *pic1_ptr;

extern BYTE selectPTR[16][16];
extern BYTE targetPTR[16][16];

#define HUMAN 1
#define COMPUTER 2
extern BYTE player_type[PLAYERS];

extern struct SoldierInfo{
	signed long Team;
	signed long FirstName;		// linked name list entry
	signed long SurName;		// linked name list entry
	signed long HP[7];			// hit points for 7 body parts
	signed long Weapon;		// linked weapon list entry
	signed long Ammo;			// total ammo
	signed long Inmag;			// in magazine ammo
	signed long APs;			// moving points
	signed long Strength;
	signed long Constitution;
	signed long Kills;			// kills
	signed long Experience;	// experience points... 
	signed long Rank;			// rank (can be, 0=NOVICE, 1=GREEN, 2=VETERAN, 3=ELITE)
	signed long Cost;			// buy/sell price
	signed long Load;			// soldier's load in KGs
	signed long FireSkill;
	signed long Armor;				// not yet supported
	signed long OHP[7];
	signed long CaddSoldierIndex;	// very important, must be valid !!!
}SI[32];

extern struct TeamInfo{
	signed long money;			// team money
	signed long soldiers;	// active soldiers
}TI[PLAYERS];

#define WOUNDS 4
extern char *WoundType[WOUNDS];

#endif
