#include "types.h"

#ifndef CT2GEN
#define CT2GEN

#define MapWidth 64
#define MapHeight 64
#define Zlevels 4
#define Blocks 60 * 8
#define RealBlocks 60

#define BlockWidth 32
#define BlockHeight 64
#define PalEntries 768

#define MousePointers 5
#define MousePointerWidth 16
#define MousePointerHeight 16

#define Sprites 28 * 8 * 2 * 4	// 7 * 4 * 8
#define RealSprites 28 // 7 * 4

#define Walkable 1
#define Seeable 2
#define SWable 4
#define Riseable 16
#define RWable 32
#define NotBlock 8

#define PLAYERS 4
#define MAX_START 8

#define MAX_KEYS 15

BYTE Palette[PalEntries];
BYTE Map[MapWidth][MapHeight][Zlevels];
BYTE LightLevel[MapWidth][MapHeight][Zlevels];
BYTE Object[MapWidth][MapHeight][Zlevels];
BYTE MapTeam[MapWidth][MapHeight][Zlevels];

BYTE *blockPTR;
BYTE *VB;
BYTE *mousePTR;
BYTE *menuPTR;
BYTE *spritePTR;
BYTE *artPTR;
FILE *f;
extern DWORD virtual_buffer_offset;

int popmenu = -1;
int popx = -1, popy = -1;

extern unsigned int dos_seg;
_go32_dpmi_seginfo VirtualBuffer;

BYTE PlayerStartX[MAX_START][PLAYERS];
BYTE PlayerStartY[MAX_START][PLAYERS];
BYTE PlayerStartZ[MAX_START][PLAYERS];
BYTE AnimFrame[MAX_START][PLAYERS];
BYTE AnimSpr[MAX_START][PLAYERS];

/*
	table of flags of blocks
*/
BYTE BlockFlags[RealBlocks] = {
	SWable,
	0, 0, 0, 0, 0, 0, 0, 0,
	SWable, SWable, SWable, SWable, SWable,
	0, 0, 0, 0, 0, 0, 0, 0,
	Seeable, Seeable, Seeable, Seeable,
	0, 0, 0, 0, 0, 0, 0, 0,
	Seeable, Seeable, Seeable, Seeable,
	0, 0, 0, 0, 0, 0, 0, 0,
	SWable,
	0, Seeable, 0, 0, 0, SWable,
	RWable, RWable, 0, 0, 0, 0,
	NotBlock
};

/*	
	there keys are read from config.ct2 file
	(generated by SETUP)
*/
BYTE keys[MAX_KEYS];

/*	
	soundcard variables
*/
BYTE scard;						// 0, 1, 2, 3
WORD sc_base;					// 0x210 - 0x280
BYTE sc_dma_lo;				// 0 - 3
BYTE sc_dma_hi;				// 4 - 7
BYTE sc_irq;					// 0 - 15 (2, 3, 5, 7)
BYTE sc_type;
BYTE sc_force_stereo;	// 0 -> FORCE MONO, 1 -> FORCE STEREO
BYTE sc_ai;

int APs[PLAYERS][MAX_START];

int enemies;
int enemyX[PLAYERS * MAX_START];
int enemyY[PLAYERS * MAX_START];
int enemyZ[PLAYERS * MAX_START];
int enemyR[PLAYERS * MAX_START];

int default_players;
int sound_amplify;
int brightness;

int health[PLAYERS][MAX_START];
int weapon[32];
BYTE ammo[32];

BYTE *pic1_ptr;	// start screen
BYTE *pic2_ptr;	// map select screen
BYTE *pic3_ptr;	// shop screen

// new from ct2init
int startpos[PLAYERS];

#define MAPS 8
char *maps[MAPS] = {
	".\\maps\\map.dat",
	".\\maps\\map2.dat",
	".\\maps\\jungle.dat",
	".\\maps\\base.dat",
	".\\maps\\map3.dat",
	".\\maps\\jail.dat",
	".\\maps\\garden.dat",
	".\\maps\\light.dat"
};

char *realmaps[MAPS] = {
	"map.dat",
	"map2.dat",
	"jungle.dat",
	"base.dat",
	"map3.dat",
	"jail.dat",
	"garden.dat",
	"light.dat"
};

BYTE selectPTR[16][16];
BYTE targetPTR[16][16];

#define HUMAN 1
#define COMPUTER 2
BYTE player_type[PLAYERS];

/*
	detailed soldier info structures (copied from team file soldier links...)
*/
struct SoldierInfo{
	signed long Team;				// will be filled with player Team ID
	signed long FirstName;		// linked name list entry
	signed long SurName;			// linked name list entry
	signed long HP[7];				// hit points for 7 body parts
	signed long Weapon;			// linked weapon list entry
	signed long Ammo;				// ammo (magazines)
	signed long Inmag;				// ammo in magazine
	signed long APs;
	signed long Strength;
	signed long Constitution;
	signed long Kills;
	signed long Experience;
	signed long Rank;				// rank (can be, 0=NOVICE, 1=GREEN, 2=VETERAN, 3=ELITE)
	signed long Cost;				// buy/sell price
	signed long Load;				// soldier's load in KGs
	signed long FireSkill;
	signed long Armor;				// not yet supported
	signed long OHP[7];
	signed long CaddSoldierIndex;	// very important, must be valid !!!
}SI[PLAYERS * MAX_START];

struct TeamInfo{
	signed long money;			// team money
	signed long soldiers;	// active soldiers
}TI[PLAYERS];

/*
	will be displayed soon...
*/
#define WOUNDS 4
char *WoundType[WOUNDS] = {
	"NO",
	"SLIGHT",
	"SERIOUS",
	"CRITICAL"
};

#endif
