/*
	Font routines by Ismo Horppu on 1996 - 1997
*/

#include <stdio.h>
#include <string.h>
#include <mem.h>
#include <dpmi.h>

#include "types.h"
#include "m320x200.h"
#include "ct2egen.h"
#include "ct2font.h"

DWORD calcstep (DWORD rw, DWORD nw)
{
	return (rw << 16L) / nw;
}

int LoadFonts (char *FontFile)
{
	for (FontCharNum = 0; FontCharNum < 256; FontCharNum++){
		if ((FontChar[FontCharNum] = (BYTE *) malloc (FONTWIDTH * FONTHEIGHT)) == NULL){
			return OUT_OF_MEMORY;
		}
	}

	if ((FontFileHandle = fopen (FontFile, "rb")) == NULL){
		return FONTFILE_NOT_FOUND;
	}

	for (FontCharNum = 0; FontCharNum < 26; FontCharNum++){
		if ((fread (FontChar[65 + FontCharNum], 1, FONTWIDTH * FONTHEIGHT, FontFileHandle)) != FONTWIDTH * FONTHEIGHT){
			return FONTFILE_READ_ERROR;
		}

		for (offset = 0; offset < FONTWIDTH * FONTHEIGHT; offset++){
			value = *((BYTE *) FontChar[65 + FontCharNum] + offset);
			*((BYTE *) FontChar[97 + FontCharNum] + offset) = value;
		}
	}

	for (FontCharNum = 0; FontCharNum < 9; FontCharNum++){
		if ((fread (FontChar[49 + FontCharNum], 1, FONTWIDTH * FONTHEIGHT, FontFileHandle)) != FONTWIDTH * FONTHEIGHT){
			return FONTFILE_READ_ERROR;
		}
	}

	if ((fread (FontChar[48], 1, FONTWIDTH * FONTHEIGHT, FontFileHandle)) != FONTWIDTH * FONTHEIGHT){
		return FONTFILE_READ_ERROR;
	}

	/*
		read , and .
	*/

	// skip one weird char...
	fread (FontChar[255], 1, FONTWIDTH * FONTHEIGHT, FontFileHandle);

	fread (FontChar[44], 1, FONTWIDTH * FONTHEIGHT, FontFileHandle);
	fread (FontChar[46], 1, FONTWIDTH * FONTHEIGHT, FontFileHandle);

	fread (FontChar[33], 1, FONTWIDTH * FONTHEIGHT, FontFileHandle);
	fread (FontChar[63], 1, FONTWIDTH * FONTHEIGHT, FontFileHandle);
	fclose (FontFileHandle);

	for (offset = 0; offset < FONTWIDTH * FONTHEIGHT; offset++){
		*((BYTE *) FontChar[32] + offset) = 0;
		*((BYTE *) FontChar['-'] + offset) = 0;
		*((BYTE *) FontChar['_'] + offset) = 0;
	}

	// generate - and _
	for (offset = 0; offset < FONTWIDTH; offset++){
		*((BYTE *) FontChar['_'] + offset + (FONTHEIGHT - 1) * FONTWIDTH) = 1;		
		*((BYTE *) FontChar['-'] + offset + ((FONTHEIGHT / 2) - 1) * FONTWIDTH) = 1;
	}
	
	xs = calcstep (FONTWIDTH, SCALEDWIDTH);
	ys = calcstep (FONTHEIGHT, SCALEDHEIGHT);
	return OK;
}

int FreeFonts (void)
{
	for (FontCharNum = 0; FontCharNum < 256; FontCharNum++){
		free (FontChar[FontCharNum]);
	}

	return OK;
}

void DisplayChar (BYTE textchar, WORD x, WORD y)
{
	
	PutClippedInvImage (FontChar[textchar], x, y, FONTWIDTH, FONTHEIGHT, VB);
}

// display only one line
void DisplayCustomChar (BYTE textchar, WORD x, WORD y, WORD sh, BYTE *tp)
{
	PutClippedInvImage (FontChar[textchar] + (long) sh * (long) 5,
	x, y, FONTWIDTH, 1, tp);
}

int CenterPos (char *string)
{
	return (320 / 2 - (strlen (string) * (FONTWIDTH + 1) / 2));
}


int DisplayString (char *string, WORD x, WORD y)
{
	WORD len;
	WORD sxpos;
	WORD sx;

	sxpos = x;
	len = strlen (string);
	
	for (sx = 0; sx < len; sx++){
		if (string[sx] != 32 && string[sx] != 9 && string[sx] != 0xD && string[sx] != 0xA){
			DisplayChar (string[sx], sxpos, y);
		}

		if (string[sx] == 9){
			sxpos += (SCALEDWIDTH + 1) * 4;
		}

		else sxpos += (SCALEDWIDTH + 1);
	}
	
	return OK;
}

int DisplayCustomString (char *string, WORD x, WORD y, WORD sh, BYTE *tp)
{
	WORD len;
	WORD sxpos;
	WORD sx;

	sxpos = x;
	len = strlen (string);
	
	for (sx = 0; sx < len; sx++){
		if (string[sx] != 32 && string[sx] != 9 && string[sx] != 0xD && string[sx] != 0xA){
			DisplayCustomChar (string[sx], sxpos, y, sh, tp);
		}

		if (string[sx] == 9){
			sxpos += (SCALEDWIDTH + 1) * 4;
		}

		else sxpos += (SCALEDWIDTH + 1);
	}
	
	return OK;
}

int DisplayCenteredString (char *string, WORD y)
{
	WORD len;
	WORD sxpos;
	WORD sx;
	WORD x;

	x = CenterPos (string);
	sxpos = x;
	len = strlen (string);

	for (sx = 0; sx < len; sx++){
		if (string[sx] != 32 && string[sx] != 9){
			DisplayChar (string[sx], sxpos, y);
		}

		if (string[sx] == 9){
			sxpos += (SCALEDWIDTH + 1) * TAB_SIZE;
		}

		else sxpos += (SCALEDWIDTH + 1);
	}

	return OK;
}

int ShadeFont (BYTE sc, BYTE cs)
{
	int c;
	int x, y;
	BYTE v;
	BYTE color;

	for (c = 0 ; c < 255; c++){
		color = sc;

		for (y = 0; y < FONTHEIGHT; y++){
			for (x = 0; x < FONTWIDTH; x++){
      	v = *((BYTE *) FontChar[c] + x + y * FONTWIDTH);

				if (v != 0){
					*((BYTE *) FontChar[c] + x + y * FONTWIDTH) = color;
				}
			}

			color += cs;
		}
	}

	return 0;
}