/*
	Combat Team II mode 320x200 header
*/
#ifndef M320x200
#define M320x200

#include "types.h"

extern "C"{
	void WriteMem (long off, long value);
	void PutPixel (int xp, int yp, BYTE color, BYTE *ptr);
	BYTE GetPixel (int xp, int yp, BYTE *ptr);
	void PutImage (BYTE *image, int xp, int yp, int width, int height);
	void PutInvImage (BYTE *image, int xp, int yp, int width, int height);
	void PutBlock (BYTE *image, int xp, int yp, int width, int height);
	void PutClippedInvImage (BYTE *image, int xp, int yp, int width, int height, BYTE *ptr);
	void PutClippedInvImage16 (BYTE *image, int xp, int yp, int width, int height, BYTE *ptr);
	void RefreshVRAM (BYTE *ptr);
	void ClearVB (BYTE *ptr);
	void TopBar (BYTE *ptr);
	void Mem2Mem (BYTE *source, BYTE *dest);
}

extern int minx, miny, maxx, maxy;
extern unsigned long int virtual_buffer_offset;
#endif
