#
#	CT2 Mouse Routines
# Made by Ismo Horppu on 1996 - 1997
#

.align 4
.extern _mousex
.extern _mousey
.extern _mouseb

.globl _CheckInstalled
_CheckInstalled:
		movw $0, %ax
		int $0x33
		ret

.globl _ShowMouse
_ShowMouse:
		pushl %eax
		movw $1, %ax
		int $0x33
		popl %eax
		ret

.globl _HideMouse
_HideMouse:
		pushl %eax
		movw $2, %ax
		int $0x33
		popl %eax
		ret

#
#	recommended to use, 'cause this is compatible
#
.globl _UpdateMouse
_UpdateMouse:
		pushl %eax
		pushl %ebx
		pushl %ecx
		pushl %edx
		
		movw $3, %ax
		int $0x33
		shrw $1, %cx
		movw %cx, _mousex
		movw %dx, _mousey
		movw %bx, _mouseb
		
		popl %edx
		popl %ecx
		popl %ebx
		popl %eax
		ret

.globl _SetHorizontalLimits
_SetHorizontalLimits:
		pushl %ebp
		movl %esp, %ebp
		pushl %eax
		pushl %ecx
		pushl %edx
		
		movw 8(%ebp), %cx
		movw 12(%ebp), %dx
		movw $0x7, %ax
		int $0x33

		popl %edx
		popl %ecx
		popl %eax
		popl %ebp
		ret

.globl _SetVerticalLimits
_SetVerticalLimits:
		pushl %ebp
		movl %esp, %ebp
		pushl %eax
		pushl %ecx
		pushl %edx
		
		movw 8(%ebp), %cx
		movw 12(%ebp), %dx
		movw $0x8, %ax
		int $0x33

		popl %edx
		popl %ecx
		popl %eax
		popl %ebp
		ret

#
#	ideal for centering mouse pointer, etc
#
.globl _SetPointerPosition
_SetPointerPosition:
		pushl %ebp
		movl %esp, %ebp
		pushl %eax
		pushl %ecx
		pushl %edx
		
		movw 8(%ebp), %cx		# get Xpos (should be multiplied by 2 ???)
		movw 12(%ebp), %dx	# get Ypos
		movw $0x4, %ax
		int $0x33
			
		popl %edx
		popl %ecx
		popl %eax		
		popl %ebp
		ret
				
