#
#	CT2 Palette routines
#	Made by Ismo Horppu on 1996
#

.align 4
.globl _SetPalette

_SetPalette:
		pushl %ebp
		movl %esp, %ebp

		pushl %ecx
		pushw %dx
		pushl %esi

		# get palette buffer address
		movl 8(%ebp), %esi

		# 768 entries to write
		movl $768, %ecx

		# dac port
		movw $0x3c8, %dx

		# start color is zero
		xorb %al, %al
		outb %al, %dx
		incw %dx

		# this must be as smooth as possible...
		# clear interrupts & wait vertical retrace
		cli
		movw $0x3da, %dx

vertical_loop1:
		inb %dx, %al
		testb $8, %al
		jz vertical_loop1

vertical_loop2:
		inb %dx, %al
		testb $8, %al
		jnz vertical_loop2

		movw $0x3c9, %dx

		# write whole palette
		rep
		outsb

		# enable interrupts
		sti
		popl %esi
		popw %dx
		popl %ecx
		popl %ebp
		ret

.globl _SetRGB
_SetRGB:
		pushl %ebp
		movl %esp, %ebp

		pushw %ax
		pushw %dx

		movb 8(%ebp), %al
		movw $0x3c8, %dx
		outb %al, %dx
		movw $0x3c9, %dx
		movb 12(%ebp), %al
		outb %al, %dx
		movb 16(%ebp), %al
		outb %al, %dx
		movb 20(%ebp), %al
		outb %al, %dx

		popw %dx
		popw %ax
		popl %ebp
		ret
