/*
	Starfield "EFFECT"
	Made by Ismo Horppu on 1996 - 1997
*/

#include <stdio.h>
#include <conio.h>
#include <sys/farptr.h>
#include <dpmi.h>
#include <go32.h>
#include <stdlib.h>
#include <time.h>
#include "types.h"
#include "rsfield.h"

void InitStars (void)
{
	srand (time (NULL));

	for (c = 0; c < STARS; c ++){
		x[c] = (rand ()% 320) - 160;
		y[c] = (rand ()% 200) - 100;
		z[c] = rand ()% MAXDIST + 1;
		s[c] = rand ()% MAXSPEED + 1;
	}
}

void DrawStars (void)
{
	for (c = 0; c < STARS; c++){
		sx = 160 + ((x[c] * 256) / z[c]);
		sy = 100 + ((y[c] * 256) / z[c]);

		if (sx >= 0 && sx <= 319 && sy >=0 && sy <= 199){
			_farpokeb (_dos_ds, 0xA0000 + sx + sy * 320, 
			16 + z[c] / (MAXDIST / 15));
		}
	}
}

void MoveStars (void)
{
	for (c = 0; c < STARS; c++){
		z[c] -= s[c];

		if (z[c] < s[c] + 1){
			z[c] = MAXDIST;
			x[c] = (rand ()% 320) - 160;
			y[c] = (rand ()% 200) - 100;
			s[c] = rand ()% MAXSPEED + 1;
		}
	}
}

void EraseStars (void)
{
	for (c = 0; c < STARS; c++){
		sx = 160 + ((x[c] * 256) / z[c]);
		sy = 100 + ((y[c] * 256) / z[c]);

		if (sx >= 0 && sx <= 319 && sy >=0 && sy <= 199){
			_farpokeb (_dos_ds, 0xA0000 + sx + sy * 320, 7);
		}
	}
}