/*
	Window routines 0.25
	made by Ismo Horppu on 1996 - 1997
*/

#include "font.h"
#include "m320x200.h"
#include <stdio.h>
#include <go32.h>
#include <dpmi.h>
#include "ct2egen.h"
#include "rwin.h"

void DrawWindow (int x, int y, int w, int h, char *text, int hlh)
{
	int sx, sy, len, cx;
	
	for (sy = y + 1; sy < y + h - 1; sy++){
		for (sx = x + 1; sx < x + w - 1; sx++){
			PutPixel (sx, sy, WinFillColor, VB);
		}
	}
	
	for (sy = y + 1; sy < y + hlh - 1; sy++){
		for (sx = x + 1; sx < x + w - 1; sx++){
			PutPixel (sx, sy, HeadLineFillColor, VB);
		}
	}
	
	for (sx = x; sx < x + w; sx++){
		PutPixel (sx, y, WinTopColor, VB);
	}
	
	for (sx = x; sx < x + w; sx++){
		PutPixel (sx, y + h - 1, WinBottomColor, VB);
	}
	
	for (sy = y; sy < y + h - 1; sy++){
		PutPixel (x, sy, WinTopColor, VB);
	}
	
	for (sy = y + 1; sy < y + h; sy++){
		PutPixel (x + w - 1, sy, WinBottomColor, VB);
	}
	
	len = strlen (text);
	
	if (len != 0){
		cx = (w - 2) / 2 - (len * 6) / 2;
		DisplayString (text, x + 1 + cx, y + 2);
	}
}

void DrawExclusiveWindow (int x, int y, int w, int h, char *text, int hlh)
{
	int sx, sy, len, cx;
	int val;
	
	for (sy = y + 1; sy < y + h - 1; sy++){
		for (sx = x + 1; sx < x + w - 1; sx++){
			PutPixel (sx, sy, WinFillColor, VB);
//			PutPixel (sx, sy, GetPixel (sx, sy, VB) | WinFillColor, VB);
		}
	}
	
	for (sy = y + 1; sy < y + hlh - 1; sy++){
		for (sx = x + 1; sx < x + w - 1; sx++){
			PutPixel (sx, sy, HeadLineFillColor, VB);
		}
	}
	
	for (sx = x; sx < x + w; sx++){
		PutPixel (sx, y, WinTopColor, VB);
	}
	
	for (sx = x; sx < x + w; sx++){
		PutPixel (sx, y + h - 1, WinBottomColor, VB);
	}
	
	for (sy = y; sy < y + h - 1; sy++){
		PutPixel (x, sy, WinTopColor, VB);
	}
	
	for (sy = y + 1; sy < y + h; sy++){
		PutPixel (x + w - 1, sy, WinBottomColor, VB);
	}
	
	len = strlen (text);
	
	if (len != 0){
		cx = (w - 2) / 2 - (len * 6) / 2;
		DisplayString (text, x + 1 + cx, y + 2);
	}
}

void SetWindowColors (BYTE TopColor, BYTE BottomColor, BYTE FillColor, BYTE WinHeadLineFillColor)
{
	WinTopColor = TopColor;
	WinBottomColor = BottomColor;
	WinFillColor = FillColor;
	HeadLineFillColor = WinHeadLineFillColor;
}