; These packing routines are based on the LZHUF.C program by
; Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

include ctrl\packint.ah
include lzss\lzsspack.ah

bin_null equ bufsize*2

pack_text segment

lzsspack_init proc near
  ; St father til ikke at pege p noget:
  mov ax,bin_null
  mov cx,bufsize
  mov di,offset lzpck.father
  rep stosw

  ; St alle binre trer til ikke at eksistere:
  mov cx,257
  mov di,offset lzpck.left+bufsize*2
  rep stosw

  retur:
  ret
endp

  lab1:
  mov si,lzpck.right[di]
  jmp end_else

lzsspack_deletenode proc near
  shl di,1
  ; Fra C++: DI=deleteofs
  ;          SI=q

  cmp lzpck.father[di],bin_null
  jz retur

  cmp lzpck.left[di],bin_null
  jz lab1

  ; Den frste store else i C++ udgaven:
    mov si,lzpck.left[di]
      cmp lzpck.right[di],bin_null ; Den frste if er flyttet herned
      jz end_else

    cmp lzpck.right[si],bin_null
    jz lab3

    ; Den frste do i C++ udgaven:
    lab4:
      mov si,lzpck.right[si]
      cmp lzpck.right[si],bin_null
    jnz lab4

    ; Den frste (store) ombytning:
    mov bp,lzpck.father[si]  ; Ombytning stn 1 st
    mov bx,lzpck.left[si]
    mov lzpck.right[bp],bx
    mov lzpck.father[bx],bp  ; Ombytning stn 2 st
    mov bx,lzpck.left[di]    ; Ombytning stn 3 st
    mov lzpck.left[si],bx
    mov lzpck.father[bx],si  ; Ombytning stn 4 st

    lab3:
    ; Den anden (mindre) ombytning:
    mov bx,lzpck.right[di]   ; Omb 1
    mov lzpck.right[si],bx
    mov lzpck.father[bx],si  ; Omb 2

  ; Else er slut her
  end_else:

  mov bx,lzpck.father[di]
  mov lzpck.father[si],bx

  ; Den 2. if konstruktion:
  cmp lzpck.left[bx],di    
  jnz lab5
    ; if delen:
    mov lzpck.left[bx],si
    mov lzpck.father[di],bin_null
    ret
  lab5:
    ; else delen:
    mov lzpck.right[bx],si
    mov lzpck.father[di],bin_null
    ret
endp

; Nedstende makro bruges i lzsspack. Den returnerer med de rigtige parametre
return_delete macro
  neg dx
  add dx,max_pack_len-1   ; DX=Makismalt match len
  mov di,lzpck.matchofs   ; DI=match offsetet
  shr di,1                ;    Divider det ned til det rigtige offset
  ret                     ; Returner
endm

      lab12:
        mov lzpck.left[bp],bin_null
        mov lzpck.right[bp],bin_null
        mov lzpck.father[bp],bx
        mov lzpck.left[bx],bp
        return_delete

    go_right:
      cmp lzpck.right[bx],bin_null
      jz lab10
        mov bx,lzpck.right[bx]
        jmp lab11
      lab10:
        mov lzpck.left[bp],bin_null
        mov lzpck.right[bp],bin_null
        mov lzpck.father[bp],bx
        mov lzpck.right[bx],bp
        return_delete

lzsspack_insertnode proc
  mov al,lzpck.ascbuf[bp]
  xor ah,ah
  add ax,bufsize+1
  shl ax,1
  mov bx,ax             ; BX=curplace
  mov al,0FFh           ; AL=Compare - g til venstre
  shl bp,1              ; BP=Insertofs
  mov dx,max_pack_len-min_pack_len
  ; max_pack_len-1-DX=Match len, start med min_pack_len-1

  for_loop:
    or al,al            ; Tjek compare
    jns go_right        ; Ved positive tal, s g t.v.
      cmp lzpck.left[bx],bin_null
      jz lab12
      mov bx,lzpck.left[bx]

    lab11:
    ; Den frste og store if konstruktion er frdig

    xor al,al             ; Slet AL
    mov cx,max_pack_len   ; CX=Max lngde vi skal sge
    mov di,bp             ; St SI og DI op til en compare
    shr di,1
    add di,offset lzpck.ascbuf
    mov si,bx
    shr si,1
    add si,offset lzpck.ascbuf
    repe cmpsb            ; Tjek nu den nuvrende streng
    jz max_len            ; Hop hvis vi har fundet en streng med max lngde
    rcr al,1              ; St c-flaget ind verst i AL
    cmp cx,dx
    ja for_loop           ; Hvis den nye match er mindre end tidligere s hop
    jz maybe_good         ; Hvis de er ens skal vi mske fortstte
    mov lzpck.matchofs,bx ; Gem bedste offset
    mov dx,cx             ; Og bedste lngde
    jmp for_loop

    ; Vi har fundet en makismal lngde:
    ; Gr nu som movenode:
    max_len:
    mov dx,-1               ; DX=Max lngde
    mov lzpck.matchofs,bx   ; Gem bedste offset

    mov ax,lzpck.father[bx] ; Move 1
    mov lzpck.father[bp],ax
    mov di,lzpck.right[bx]  ; Move 2
    mov lzpck.right[bp],di
    mov lzpck.father[di],bp ; Move 4
    mov di,lzpck.left[bx]   ; Move 3
    mov lzpck.left[bp],di
    mov lzpck.father[di],bp ; Move 5
    ; if stningen
    mov di,lzpck.father[bx]
    cmp lzpck.left[di],bx
    jnz lab13
      mov lzpck.left[di],bp
      mov lzpck.father[bx],bin_null
      return_delete
    lab13:
      mov lzpck.right[di],bp
      mov lzpck.father[bx],bin_null
      return_delete

    maybe_good:
    ; Vi skal vlge den af de to der er tttest p.
    ; BP=Vores nuvrende offset
    ; BX=Vores nye sted vi mske skal vlge
    ; lzpck.matchofs=Vores gamle valgte sted

    mov cx,lzpck.matchofs
    cmp lzpck.matchofs,bp
    jb bx_below
      ; matchofs er strre end BP. BX ligger ttterer p BP end matchofs hvis
      ; BX ligger uden for BP og matchofs
      cmp bx,bp
      jb chose_new
      cmp bx,lzpck.matchofs
      ja chose_new
      jmp for_loop
      chose_new:
      mov lzpck.matchofs,bx ; Vlg det nye sted
      jmp for_loop
    bx_below:
      ; matchofs er mindre end BP. BX ligger derfor tttere p BP end
      ; matchofs hvis BX ligger mellem matchofs BP
      cmp bx,bp
      ja go_for
      cmp bx,lzpck.matchofs
      jb go_for
      ; Ellers: Byt om
      mov lzpck.matchofs,bx ; Vlg det nye sted
      go_for:
      jmp for_loop
endp

ends
end
