// These packing routines are based on the LZHUF.C program by
// Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

// This is an example of a program using the C++ packing interface.
// It uses the Borland (and MicroSoft?) C++'s functions for
// direct filemanipulation and the stdio library for screen output.

#include <suppack.hpp>
#include <dos.h>
#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>

#define READ_ERR  1
#define WRITE_ERR 2

// Class that takes care of fileio
class fileio:public packing {
  int outfile;     // Destination file
  int infile;      // Source file
  long rd,written; // Number of bytes read/written

  void write_status() {
    printf("\rRead %li. Written %li.",rd,written);
  }

  virtual int read(char* buffer, unsigned* bufsize) {
     // Read from the file:
    if(_dos_read(infile,buffer,*bufsize,bufsize))
      return READ_ERR;
    rd+=*bufsize;
    return PACK_NOERR;
  }

  virtual int write(char* buffer, unsigned bufsize) {
    unsigned writ;
    _dos_write(outfile,buffer,bufsize,&writ); // Write the given
    if(writ!=bufsize) return WRITE_ERR;       // If it wasn't written
    written+=writ;
    write_status();
    return PACK_NOERR;
  }

  public:

  fileio(char* ifile, char* ofile) {
    // Open the files:
    if(_dos_open(ifile,O_RDONLY,&infile)) infile=-1; // On error...
    if(_dos_creat(ofile,0,&outfile)) outfile=-1;
    written=rd=0;
    write_status();
  }

  ~fileio() {
     _dos_close(infile); _dos_close(outfile); // Close the files
     write_status();
     printf("\n");
  }
};

main(int argc, char* argv[]) {
  if((argc!=4) || ((toupper(argv[1][0])!='A') && (toupper(argv[1][0])!='E'))) {
    printf("Syntax: SUPPACK.EXE a|e packedfile unpackedfile\n");
    return 1;
  }

  int err;

  if(toupper(argv[1][0])=='E') { // Unpack
    fileio f(argv[2],argv[3]);
    err=f.do_decode();
  } else { // Pack
    fileio f(argv[3],argv[2]);
    err=f.do_encode();
  }

  switch(err) {
    case PACK_EOD:    printf("Unexpected end of file\n"); break;
    case PACK_NO_MEM: printf("Not enough memory\n"); break;
    case READ_ERR:    printf("Read error\n"); break;
    case WRITE_ERR:   printf("Write error\n"); break;
  }

  return err;
}