/* These packing routines are based on the LZHUF.C program by
   Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

   This file holds C declarations that can be used directly together
   with the assembler library.
*/

#ifdef __cplusplus
  #define PACK_EXTRN extern "C"
#else
  #define PACK_EXTRN extern
#endif

/* Declare errorcodes. Note that negative errorcodes are reserved
   for use by library.
*/

#define PACK_NOERR 0  /* No error */
#define PACK_EOD -1   /* End Of Data before end of unpacking */

/* Typedefs for user read/write functions: */
typedef int(far pascal* suppackreadfunc)(void far* userdata, char far *buffer,
            unsigned far* size);

typedef int(far pascal* suppackwritefunc)(void far* userdata,
            char far* buffer, unsigned size);

/* Function declarations: */

PACK_EXTRN unsigned far pascal decode_mem_req(void);
/* Returns the number of bytes that the unpacker needs. */

PACK_EXTRN int far pascal do_decode(
  void far* userdata,suppackreadfunc,suppackwritefunc, char* workbuffer);
/* This function does the unpacking. It returns PACK_NOERR if the
   unpacking were succesfull and returns PACK_EOD if the entier block
   of packed data couldn't be read. Returns the same as the read/write
   functions if they return an error code. Paramerers:

   userdata:
     A pointer that's only used to give the read/write functions (look
     below) as parameter. Asures that the user can work reentrant if he
     wants to.

   suppackreadfunc:
     This function should read *size bytes to buffer. In *size the number of
     bytes actually read should be stored. Should return PACK_NOERR or a
     possitive errorcode.

   suppackwritefunc:
     This function should write size bytes from buffer. Should return
     PACK_NOERR or a possitive errorcode.

   workbuffer:
     A memory area that the unpacker can use for its own data. A minimum of
     decode_mem_req bytes is required.
*/

/* The following is as by the unpacker - just for the packer: */
PACK_EXTRN unsigned far pascal encode_mem_req(void);

PACK_EXTRN int far pascal do_encode(
  void far* userdata, suppackreadfunc,suppackwritefunc, char far* workbuffer);

#undef PACK_EXTRN