// These packing routines are based on the LZHUF.C program by
// Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

// Dette modul bruges til dynamisk huffmann kompresion og dekompresion.
// De gennerelle rutiner er placeres i HUFFMAN.CPP og de pakke/udpakke
// specifikke er placeres i henholdsvis PACK og UNPACK.CPP

#ifndef HUFFMAN
#define HUFFMAN

struct base_huff {
  unsigned freq[T + 1];
  // Frekvens for alle noder samt et sidste index som sttes til
  // max vrdi for at en sgning frem i denne tabel altid kan stoppe, da:
  // Tret er sorteret efter denne sledes at freq[n]<=freq[n+1]

  int son[T];
  // Pointere til childs. Snnerne er det givne element + elementet
  // lige efter. To nabo elementer str alts altid ved siden af hinanden.
  // Det betyder kombineret med teksten under freq, at to sskene
  // str lige op ad hinanden i frekvens.

  int prnt[T + N_CHAR];
  // Intervallet [0..T]        : Forldre til alle noder
  // Intervallet [T..T+N_CHAR[ : Position i tret for hver karakter

  void reconst();
  // Denne rekonstruerer tret. Dette skal ske for at frekvenserne
  // ikke skal blive s store at der sker overflow.

  void update(int);
  // Opdater frekvensen for den givne karakter i tret.

  void inithuff();
  // Initer rutinerne.
};

// Flgende har ikke noget huffman at gre men er flles:
// bufplace=Aktuelle buffer pointer
// offset  =Sted i bufferen vi vil refferere til
// Returnerer offset's relative afstand til bufplace
extern int dist(int bufplace, int offset);

#endif