//DASHANIM.H  --  Header file for routines that play .DSH animation files
//                created by PCX2DSH.
//                (C) 1995 Eric M. Dashofy / Archon Software
//		  All Rights Reserved

#ifndef __DASHANIM_H__
#define __DASHANIM_H__

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include "xmm.h"


typedef unsigned char byte;
typedef unsigned int  word;
typedef unsigned long dword;

#ifndef _BOOL_TYPE_
#define _BOOL_TYPE_

  typedef enum{
    TRUE  = 1,
    FALSE = 0
  } boolean;

#endif

struct DSH_Header{
  byte 		FileType[12];
  byte 		MajorVersion[2];
  byte 		MinorVersion[2];
  dword 	FileLength;
  byte   	NumFrames;
  word          ScreenWidth;
  word		ScreenHeight;
  word		ColorDepth;
  byte		Padding[37];
};

struct buf_struct{
  byte far*     buf_ptr;
  FILE* 	file;
  DSH_Header	hdr;
  word		bytes_read;
  word		buf_size;
  word		offset;
};


const byte NewFrame  = 0xFF;
const byte SkipMode  = 0xFD;
const byte WriteMode = 0xFE;

const word buf_size = 50*1024;


word dsh_flood_buffer(buf_struct& buffer);
void dsh_get_header(FILE* stream, DSH_Header& hdr);
word dsh_xms_flood_buffer(DashXMM& AnimXMS, buf_struct& buffer);
void dsh_get_bytes(byte far* to, word num_bytes, buf_struct& buffer,
		   DashXMM& AnimXMS);
void set_palette(byte* pal);

//this is the only function the user should need to call!
int playdsh(char* afn, unsigned int delayms);

#endif