// File from page 614 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: ASSOC.H -- Associative array
#ifndef ASSOC_H_
#define ASSOC_H_
#include "..\14\set.h"
#include <assert.h>

template<class In, class Out>
class assoc_array {
  set<In> inVal;
  vector<Out> outVal;
  int max;
  // Prevent assignment & copy-construction:
  void operator=(assoc_array&);
  assoc_array(assoc_array&);
public:
  assoc_array() : max(0) {}
  Out& operator[](const In&);
  int length() const { return max; }
  In& in_value(int i) {
    // No check for shipping application:
    assert(i >= 0 && i < max);
    return inVal[i];
  }
  Out& out_value(int i) {
    assert(i >= 0 && i < max);
    return *outVal[i];
  }
};

template<class In, class Out> Out&
assoc_array<In,Out>::operator[](const In& in){
  if(!inVal.contains(in)) {
    inVal.add(in); // Copy-constructor
    outVal[max] = new Out; // Default constr.
    max++;
  }
  int x = inVal.index(in);
  return *outVal[inVal.index(in)];
}
#endif // ASSOC_H_
