// File from page 655 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: MULTIPL3.CPP -- Virtual base initialization
// Virtual base classes must always be
// Intialized by the "most-derived" class
#include <iostream.h>
#include "..\14\tstash.h"

class base {
public:
  base(int) {}
  virtual char* vf() const = 0;
};

class d1 : virtual public base {
public:
  d1() : base(1) {}
  char* vf() const { return "d1"; }
};

class d2 : virtual public base {
public:
  d2() : base(2) {}
  char* vf() const { return "d2"; }
};

class mi : public d1, public d2 {
public:
  mi() : base(3) {}
  char* vf() const {
    return d1::vf(); // MUST disambiguate
  }
};

class x : public mi {
public:
  // You must ALWAYS init the virtual base:
  x() : base(4) {}
};

main() {
  tstash<base> b;
  b.add(new d1);
  b.add(new d2);
  b.add(new mi); // OK
  b.add(new x);
  for(int i = 0; i < b.count(); i++)
    cout << b[i]->vf() << endl;
}
