// File from page 743 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: SELFRTTI.CPP -- Your own RTTI system
#include "..\14\tstack.h"
#include <iostream.h>

class security {
protected:
  enum { baseID = 1000 };
public:
  virtual int dynamic_type(int ID) {
    if(ID == baseID) return 1;
    return 0;
  }
};

class stock : public security {
protected:
  enum { typeID = baseID + 1 };
public:
  int dynamic_type(int ID) {
    if(ID == typeID) return 1;
    return security::dynamic_type(ID);
  }
  static stock* dynacast(security* s) {
    if(s->dynamic_type(typeID))
      return (stock*)s;
    return 0;
  }
};

class bond : public security {
protected:
  enum { typeID = baseID + 2 };
public:
  int dynamic_type(int ID) {
    if(ID == typeID) return 1;
    return security::dynamic_type(ID);
  }
  static bond* dynacast(security* s) {
    if(s->dynamic_type(typeID))
      return (bond*)s;
    return 0;
  }
};

class commodity : public security {
protected:
  enum { typeID = baseID + 3};
public:
  int dynamic_type(int ID) {
    if(ID == typeID) return 1;
    return security::dynamic_type(ID);
  }
  static commodity* dynacast(security* s) {
    if(s->dynamic_type(typeID))
      return (commodity*)s;
    return 0;
  }
  void special() {
    cout << "special commodity function\n";
  }
};

class metal : public commodity {
protected:
  enum { typeID = baseID + 4};
public:
  int dynamic_type(int ID) {
    if(ID == typeID) return 1;
    return commodity::dynamic_type(ID);
  }
  static metal* dynacast(security* s) {
    if(s->dynamic_type(typeID))
      return (metal*)s;
    return 0;
  }
};

main() {
  tstack<security> portfolio;
  portfolio.push(new metal);
  portfolio.push(new commodity);
  portfolio.push(new bond);
  portfolio.push(new stock);
  tstackIterator<security> it(portfolio);
  while(it) {
    commodity* cm =
      commodity::dynacast(it.current());
    if(cm) cm->special();
    else cout << "not a commodity" << endl;
    it++;
  }
  cout << "cast from intermediate pointer:\n";
  security* sp = new metal;
  commodity* cp = commodity::dynacast(sp);
  if(cp) cout << "it's a commodity\n";
  metal* mp = metal::dynacast(sp);
  if(mp) cout << "it's a metal too!\n";
}
