// File from page 248 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: EFFECTOR.CPP -- Jerry Schwarz's "effectors"
#include<iostream.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <limits.h> // ULONG_MAX

// Put out a portion of a string:
class fixw {
  char* s;
public:
  fixw(const char* S, int width);
  ~fixw();
  friend ostream& operator<<(ostream&, fixw&);
};

fixw::fixw(const char* S, int width) {
  s = (char*)malloc(width + 1);
  assert(s);
  strncpy(s, S, width);
  s[width] = 0; // Null-terminate
}

fixw::~fixw() { free(s); }

ostream& operator<<(ostream& os, fixw& fw) {
  return os << fw.s;
}

// Print a number in binary:
typedef unsigned long ulong;

class bin {
  ulong n;
public:
  bin(ulong N);
  friend ostream& operator<<(ostream&, bin&);
};

bin::bin(ulong N) { n = N; }

ostream& operator<<(ostream& os, bin& b) {
  ulong bit = ~(ULONG_MAX >> 1); // Top bit set
  while(bit) {
    os << (b.n & bit ? '1' : '0');
    bit >>= 1;
  }
  return os;
}


main() {
  char* string =
    "Things that make us happy, make us wise";
  for(int i = 1; i <= strlen(string); i++)
    cout << fixw(string, i) << endl;
  ulong x = 0xFEDCBA98UL;
  ulong y = 0x76543210UL;
  cout << "x in binary: " << bin(x) << endl;
  cout << "y in binary: " << bin(y) << endl;
}
