// Box drawing constants

#define BX_SINGLE 0
#define BX_DOUBLE 1

// Character attribute constants

#define FG_BLUE 1
#define FG_GREEN 2
#define FG_CYAN 3
#define FG_RED 4
#define FG_MAGENTA 5
#define FG_BROWN 6
#define FG_WHITE 7
#define FG_GRAY 8
#define FG_LIGHTBLUE 9
#define FG_LIGHTGREEN 10
#define FG_LIGHTCYAN 11
#define FG_LIGHTRED 12
#define FG_LIGHTMAGENTA 13
#define FG_YELLOW 14
#define FG_BRIGHTWHITE 15

#define BG_BLACK 0
#define BG_BLUE 16
#define BG_GREEN 32
#define BG_CYAN 48
#define BG_RED 64
#define BG_MAGENTA 80
#define BG_BROWN 96
#define BG_WHITE 112

// Blinking character attribute

#define BLINK 128

// Scrolling constants

#define SC_UP 0
#define SC_DOWN 1
#define SC_LEFT 2
#define SC_RIGHT 3

// Macro parameter constant for scrolling routine
// Use this in place of the parameters for the ScrollWindow function

#define WNU_FULLSCREEN 0, 1, 79, 24, 0
#define WND_FULLSCREEN 0, 0, 79, 23, 1
#define WNL_FULLSCREEN 1, 0, 79, 24, 2
#define WNR_FULLSCREEN 0, 0, 78, 24, 3

// CursorShape constants

#define CR_BLOCK 0x011F
#define CR_UNDERLINE 0x1E1F
#define CR_NOCURSOR 0x0000

// Function Prototypes

extern void CursorShape( unsigned );
extern void ShowChar( char, short, short, short );
extern void Box( short, short, short, short, short, short );
extern void Fill( short, short, short, short, short, char );
extern void ChangeAttr( short, short, char );
extern void AtPrintS( short, short, short, char * );
extern char GetChar( short, short );
extern char GetAttr( short, short );
extern void ScrollWindow( short, short, short, short, short );
extern unsigned int SetMode( short );
extern void ClearScreen();
extern void CursorPosition( short, short );
extern void Message( char *, char *, short );
extern void MessageWait( char *, char *, short );
extern void Window( int, int, int, int, int, int );
extern void CenterWindow( int, int, int, int, int *, int * );
extern void ShowNumber( int, int, int, int );
extern void ShowNumber( int, int, int, unsigned );
extern void ShowNumber( int, int, int, long );
extern void *SaveScreen( short, short, short, short );
extern void RestoreScreen( void * );
