;****************************************************************************
;FIRE.COM - a half-screen 64 colour fire effect.
;*This version doubles the height of the pixels! i.e. 320x100x256 video mode*
;This is a simple (but good) fire effect (super small: 114 bytes! :)
;Only 64 colours are used.  All registers, no variables.
;No page flipping and no vertical retrace.. (still quite smooth though).
;Requires A86 to assemble as is. (the code is a mess, but it works! :)
;(C) Jamie, September 5th 1996
;contact me at: james.mckinney@stonebow.otago.ac.nz
;****************************************************************************

start:          mov bh,0A0h             ;use DS to point to video segment.
                mov ds,bx               ;by using DS there is no need for a
                                        ;segment override, which is a byte
                                        ;bigger (I think) and a few ticks slower
                mov al,13h              ;ax=0 on start, so ah=0
                int 10h                 ;mode 13 hex (320*200*256)

                mov dx,3d4h             ;This bit changes the screen mode to
                mov al,9                ;320*100*256
                out dx,al               ;
                inc dx                  ;if you comment this bit out, you get
                in al,dx                ;fire in the middle of the screen.
                and al,0E0h             ;It is a bit messy, and half as high. 
                add al,3                ;Still looks quite good though, and
                out dx,al               ;saves 13 bytes :)

;---------------Set Palette
Set_Palette:    mov dx,3c8h
                mov al,0                ;set colours from 0 up
                out dx,al
                inc dx
                mov cl,63
SNext_col:      mov al,63
                sub al,cl
                out dx,al               ;Red
                mov bl,al               ;*Green=(Red*Red)128
                mul bl                  ;*This puts the yellow in the fire
                shr ax,7
                out dx,al               ;Green
                mov al,0
                out dx,al               ;Blue (always=0)
                loop SNext_col
;---------------Set Palette


;------------------------------ MAIN BIT start ------------------------------
Main_start:     
;---------------Seed Fire       ;puts a mix of yellow/black pixels on screen.
seed_fire:      mov cl,160
                mov di,31681+960
seed_loop:      in ax,40h       ;a (cheesy) 'random' number generator
                mov bx,ax       ;reads the timer twice and XOR's the values
                in ax,40h       ;to get a number 0-65535
                xor bx,ax       ;
                and bh,1        ;make the number 0-511
                test cl,1       ;should be 0-319, but this is faster and any
                jz seed_set     ;pixels >319 dont get shown anyway
                mov ah,63
seed_set:       mov [di+bx],ah
                loop seed_loop
;---------------Seed Fire 

;---------------Do Fire
do_fire:        mov di,31679+960
                mov ch,56h              ;cl already equals 0
Fire_loop:      mov al,[di]             ;get colour of current pixel
                add al,[di+319]         ;get colour of below left
                add al,[di+320]         ;get colour of below
                add al,[di+321]         ;get colour of below right
                shr al,2                ;divide by 4 (to average)
                mov [di],al             ;put the new pixel
                dec di
                loop fire_loop    
;---------------Do fire
;------------------------------ MAIN BIT end --------------------------------

;---------------Check Key
Check_key:      in al,60h               ;read key port
                cmp al,128              ;        
                ja Main_Start
;---------------Check Key               ;key not removed from buffer.                     


Main_end:       mov ax,3                ;back to text mode
                int 10h
exit:           ret
;*****************************************************************************
