Unit FlicPlay;
{$G+,R-,S-}

{ this unit provides routines for reading and playing a fli or
  flc file. The whole file is read into memory; In real mode,
  it uses XMS, in protected mode it uses the pascal heap, to
  accomplish this. On systems with 8Mb or more, this should
  be no problem! (I could read and play a 3.5Mb flicfile!!).

  All the functions and procedures are exported to use them in
  a .DLL (protected mode only).

  Author:           N. De Smedt (alias ThunderByte)
  Last update:      24/04/1997
  Additional units: Timer,TwkUnit;        (protected mode)
                    Timer,TwkUnit,XMSUnit (real mode)
  Additional objectfiles:
                    TWK256.OBJ,copy386.obj

Notes: You must have at least 64K (for 320X200X256) or 128K
       (for 320X400X256) free on the heap (real mode).
       This unit is tested on a 486 DX-40 with 8Mb, a
       486 DX2-66 PCI with 16Mb and a Compaq Pentium 133Mhz
       with 32Mb.

Thanks go to: Brian Jensen aka goto64 of Purple (TwkUnit).
              Mark Feldman (Timer).

       Give them also credits!

You can always email me at desmedt@uia.ac.be (if you use this unit into
an application or if you improve this unit; I'd like to hear from you!!

-----------------------------------------------------------------------}
INTERFACE

{ Error constants, fe_XXXXXX (fe = Flic Error) }
Const fe_NotAFlic           = 1;
      fe_FlicReadError      = 2;
      fe_WrongResolution    = 3;
      fe_InvalidType        = 4;
      fe_FileNotFound       = 5;
      fe_NotEnoughMemory    = 6;
      fe_InvalidInPut       = 7;
      fe_GeneralError       = 8; { All other errors }

{$IFDEF DPMI}
Function InitFlic(fn: String): Byte; Export;
{$ELSE}
Function InitFlic(fn: String): Byte;
{$ENDIF}
{ Does the nescesary things for reading and
  playing the flicfile. Returns zero if succesfull.
  Otherwise <> 0, possible errors: 1,2,4,5.
  Don't forget to call DoneFlic!! }
{$IFDEF DPMI}
Function NumberOfFrames: Word; Export;
{$ELSE}
Function NumberOfFrames: Word;
{$ENDIF}
{ Returns the number of frames in the flicfile.
  Don't forget to call InitFlic first !! }
{$IFDEF DPMI}
Function ReadFrames: Byte; Export;
{$ELSE}
Function ReadFrames: Byte;
{$ENDIF}
{ Read the frames of the flicfile into memory.
  This can take long...
  Returns zero if succesfull,
  otherwise one of the above error constants, possible
  errors: 1,2,3 or 6,7. }
{$IFDEF DPMI}
Function PlayFlic(Speed: Word): Byte; Export;
{$ELSE}
Function PlayFlic(Speed: Word): Byte;
{$ENDIF}
{ Plays the fli or flc. Returns zero if succesfull, otherwise
  one of the above error constants!
  Remember to call ReadFrames first !
  Set speed to zero if you want to use the flic' speed }
{$IFDEF DPMI}
Procedure DoneFlic; Export;
{$ELSE}
Procedure DoneFlic;
{$ENDIF}
{ Frees all the memory and other things, like
  restoring the timer. Call this proc ALWAYS after
  playing or reading a flicfile, EVEN when an error
  occured!!!!!!!! (place it in the exitprocedure chain...) }
{$IFDEF DPMI}
Function FlicErrorStr(ErrorNr: Byte): String; Export;
{$ELSE}
Function FlicErrorStr(ErrorNr: Byte): String;
{$ENDIF}
{ Gives a string for a given error number }

IMPLEMENTATION
Uses CRT,DOS,Timer,{$IFNDEF DPMI} XMSUnit,{$ENDIF} TwkUnit;

Const FLI_Color=11;
      FLI_256=   4;
      FLI_LC=   12;
      FLI_BLACK=13;
      FLI_BRUN= 15;
      FLI_COPY= 16;
      FLI_MINI= 18;
      FLI_DELTA= 7;
      BufSize=  64000;

TYPE FLIHead=Record
              flength:   LongInt;
              magic:     Word;
              frames:    Word;
              width:     Word;
              height:    Word;
              depth:     Word;
              flags:     Word;
              speed:     LongInt;
              reserved1: Word;
              created:   LongInt;
              creator:   LongInt;
              updated:   LongInt;
              updater:   LongInt;
              aspectx:   Word;
              aspecty:   Word;
              reserved2: Array[1..38] Of Byte;
              oframe1:   LongInt;
              oframe2:   LongInt;
              reserved3: Array[1..40] Of Byte;
             END;
     FrameHead=Record
                length: LongInt;
                magic:  Word;
                chunks: Word;
                expand: Array[1..8] Of Byte;
               END;
     ChunkHead=Record
                length: LongInt;
                tp:     Word;
               END;
     BufArray= Array[0..BufSize-1] Of Byte;

     FramesList = ^FramesRec;
     FramesRec = RECORD
       {$IFDEF DPMI}
       FrameData: Pointer; { pointer to the data on the pascal heap }
       {$ELSE}
       Offs: Longint;
       {$ENDIF}
       FrameSize: Word;
       Chunks: Word;
       Next: FramesList;
     end;

     TByteArray = Array[0..0] of Byte;

Var Chain: Pointer;
    TimerRestored: Boolean;
    StartFrame,CurrentFrame: FramesList;
    Offset: Longint;
    {$IFNDEF DPMI}
    XMSHandle: Word;
    {$ENDIF}

Procedure ExitProcedure; FAR;
Begin
  If Not TimerRestored then
     RestoreTimer;
  ExitProc := Chain;
end;

{$F+}
{$L TWK256.OBJ}
PROCEDURE TWEAK; external;
{$L COPY386.OBJ}
PROCEDURE CopyPage2_386(VSeg,VideoSeg: Word); External;
{$F-}

Var flicfile: File;
    head:     FLIHead;
    fhead:    FrameHead;
    data:     ^BufArray;
    indpos:   Word;
    dpos:     LongInt;
    maxdpos:  LongInt;
    curpal:   Array[0..255,1..3] Of Byte;
    dataseg:  Word;
    code:     Integer;

Function ReadBlock(Var Data; Size: Word): Boolean;
Begin
  {$I-}
  BlockRead(FlicFile,Data,Size);
  {$I+}
  ReadBlock := (IOREsult = 0);
end;

Function GetBlock(Var Data; Size: Word): Boolean;
Begin
  With CurrentFrame^ do
    Begin
      {$IFDEF DPMI}
      Move(TByteArray(FrameData^)[Offset],Data,Size);
      INC(Offset,Size);
      GetBlock := True;
      {$ELSE}
      If Odd(Size) then  { XMS-blocks must have even lengths,
                            don't know why?? }
         INC(Size);
      GetBlock := MoveFromXMS(XMSHandle,Offset,Ptr(Seg(Data),Ofs(Data)),Size);
      INC(Offset,Size);
      {$ENDIF}
    end; { With }
end;

Function InitFLIC(fn: String): Byte;
BEGIN
  Assign(flicfile,fn);
  {$I-}
  Reset(flicfile,1);
  {$I+}
  If IOResult <> 0 then
     Begin
       InitFlic := fe_FileNotFound;
       Exit;
     end;
  If Not ReadBlock(head,SizeOf(FLIHead)) then
     Begin
       InitFlic := fe_FlicReadError;
       Exit;
     end;
  If (head.magic <> $AF11) And (head.magic <> $AF12) then
     Begin
       InitFlic := fe_NotAFlic;
       Exit;
     end;
  If MaxAvail < SizeOf(BufArray) then
     Begin
       InitFlic := fe_NotEnoughMemory;
       Exit;
     end;
  GetMem(data,SizeOf(BufArray));
  dataseg:=Seg(data^);
  StartFrame := NIL;
  {$IFNDEF DPMI}
  If Not XMSAvailable then { Oops no XMS ! }
     InitFlic := fe_NotEnoughMemory
  Else
 {$ENDIF}
 InitFlic := 0;
END;

Procedure DoneFLIC;
Var i: Integer;
    P: FramesList;
BEGIN
  If Data <> NIL then
     FreeMem(data,SizeOf(BufArray));
  If Screen21 <> NIL then
     FreeMem(screen21,SizeOf(VirScreen));
  {$I-}
  Close(flicfile);
  {$I+}
  i := IOResult;
  If StartFrame <> NIL then
     Begin
       Repeat
         P := StartFrame^.Next;
         {$IFDEF DPMI}
         FreeMem(StartFrame^.FrameData,StartFrame^.FrameSize);
         {$ENDIF}
         DisPose(StartFrame);
         StartFrame := P;
       Until P = NIL;
     end;
  {$IFNDEF DPMI}
  FreeXMS(XMSHandle);
  {$ENDIF}
  RestoreTimer;
  TimerRestored := True;
END;

PROCEDURE ReadColorMap(length: Word;
                       range:  Byte);
Var skip,packet: Byte;
    change:      Word;
    posi:        Word;
    curcol:      Byte;
    t:           Byte;
    packets:     Byte;
    shift:       Byte;
BEGIN
 If range = 63 Then shift:=0
 Else shift:=2;
 GetBlock(Data^,Length);
 (*BlockRead(flicfile,data^,length);*)
 curcol:=0;
 posi:=2; packets:=data^[0]{+data^[1]?};
 For packet:=1 To packets Do
 BEGIN
  skip:=data^[posi];
  Inc(posi);
  change:=data^[posi];
  Inc(posi);
  If change=0 Then change:=256;
  curcol:=curcol+skip;
  For t:=curcol To curcol+change-1 Do
  BEGIN
   curpal[t,1]:=data^[posi] Shr shift; Inc(posi);
   curpal[t,2]:=data^[posi] Shr shift; Inc(posi);
   curpal[t,3]:=data^[posi] Shr shift; Inc(posi);
  END;
 END;
 ASM
  Mov ah,10h
  Mov al,12h
  Mov bx,ds
  Mov es,bx
  Lea dx,curpal
  Mov bx,0
  Mov cx,100h
  Int 10h
 END;
END;

PROCEDURE SetBlack;
BEGIN
 TwkClearpage2;
END;

PROCEDURE ReadLineCompressed(length: Word);
Var sy,y:     Word;
    posi:     Word;
    packet:   Byte;
    packets:  Byte;
    x:        Word;
    rep:      ShortInt;
    curline:  Word;
    curseg:   Word;
    curpixel: Word;
BEGIN
 GetBlock(Data^,Length);
(* BlockRead(flicfile,data^,length);*)
 sy:=data^[0]+data^[1] Shl 8;
 posi:=4;
 If sy>=200 Then
 BEGIN curseg:=s22seg; curline:=(sy-200)*320; END
 Else BEGIN curseg:=s21seg; curline:=sy*320; END;
 For y:=sy To sy+data^[2]+data^[3] Shl 8-1 Do
 BEGIN
  curpixel:=curline;
  packets:=data^[posi]; Inc(posi);
  ASM
   Mov dl,packets
   Test dl,255
   Jz @TheEnd
   Mov bx,ds
   Mov si,posi
   Mov di,curline
   Mov es,curseg
   Mov ds,dataseg
   Cld
   Mov ah,0
   Mov ch,0
   @NextPacket:
   Lodsb
   Add di,ax
   Mov cl,ds:[si]
   Inc si

   Cmp cl,0
   Jle @Single

   Rep Movsb
   Dec dl
   Jnz @NextPacket
   Jmp @Slut

   @Single:
   Lodsb
   Neg cl
   Rep Stosb
   Dec dl
   Jnz @NextPacket

   @Slut:
   Mov ds,bx
   Mov posi,si
   @TheEnd:
  END;
  If sy=199 Then BEGIN curseg:=s22seg; curline:=0; END
  Else curline:=curline+320;
 END;
END;

PROCEDURE ReadRunLength(length: Word);
Var sy,y:    Word;
    posi:    Word;
    packet:  Byte;
    packets: Byte;
    x:       Word;
    rep:     ShortInt;
    t:       Word;
    repb:    Byte;
BEGIN
 (*BlockRead(flicfile,data^,length);*)
 GetBlock(Data^,Length);
 posi:=0;
 For y:=0 To head.height-1 Do
 BEGIN
  packets:=data^[posi]; Inc(posi); x:=0;
  For packet:=1 To packets Do
  BEGIN
   rep:=ShortInt(data^[posi]); Inc(posi);
   If rep>0 Then
   BEGIN
    repb:=data^[posi];
    Asm
     Mov es,s21seg
     Mov ax,y
     Cmp ax,200
     Jl  @AfterPlane
     Mov es,s22seg
     Sub ax,200
     @AfterPlane:
     Mov cx,320
     Mul cx
     Add ax,x
     Mov di,ax
     Mov ch,0
     Mov cl,rep
     Add x,cx
     Mov al,repb
     Rep Stosb
     Inc posi
    END;
   END Else BEGIN
    ASM
     Neg rep
     Push ds
     Mov es,s21seg
     Mov ax,y
     Cmp ax,200
     Jl  @AfterPlane
     Mov es,s22seg
     Sub ax,200
     @AfterPlane:
     Mov cx,320
     Mul cx
     Add ax,x
     Mov di,ax
     Mov ch,0
     Mov cl,rep
     Add x,cx
     Mov si,posi
     Add posi,cx
     Mov ds,dataseg
     Cld
     Rep Movsb
     Pop ds
    END;
   END;
  END;
 END;
END;

PROCEDURE ReadDeltaCompressed(length: Word);
Var sy:       Word;
    y:        Integer;
    posi:     Word;
    packet:   Word;
    packets:  Word;
    ipacks:   Integer;
    x:        Word;
    rep:      ShortInt;
    skip:     Byte;
    ldata:    Byte;
    ldata2:   Byte;
    t:        Byte;
    curline:  Word;
    curseg:   Word;
BEGIN
(* BlockRead(flicfile,data^,length);*)
 GetBlock(Data^,Length);
 sy:=data^[0]+data^[1] Shl 8;
 posi:=2;
 y:=0; curseg:=s21seg; curline:=0;
 While sy>0 Do
 BEGIN
  packets:=data^[posi]; Inc(posi);
  packets:=packets+data^[posi] Shl 8; Inc(posi);
  ipacks:=Integer(packets);
  If packets And $C000 = $C000 Then {Bit 15 and 14 set}
  BEGIN
   ipacks:=Abs(ipacks);
   y:=y+ipacks;
   If y>=200 Then
   BEGIN
    y:=y-200;
    curline:=y*320; curseg:=s22seg;
   END ELSE curline:=curline+ipacks*320;
  END Else
  If packets And $8000 = $8000 Then {Bit 15 set}
  BEGIN
   If y<=199 Then
    screen21^[y,319]:=Lo(packets)
   Else screen22^[y-200,319]:=Lo(packets)
  END
  Else BEGIN
   Dec(sy);
   ASM
    Cld
    Mov dx,ipacks
    Mov si,posi
    Mov es,curseg
    Mov di,curline
    Mov bx,ds
    Mov ds,dataseg
    Mov ch,0
    @NextPacket:
    Mov ah,0
    Lodsb
    Add di,ax
    Mov cl,ds:[si]
    Inc si
    Cmp cl,0
    Jl  @Single
    Je  @TheEnd

    {Copy words:}
    Rep Movsw
    Dec dx
    Jnz @NextPacket
    Jmp @TheEnd

    {Dublicate byte:}
    @Single:
    Neg cl
    Lodsw
    Rep Stosw
    Dec dx
    Jnz @NextPacket
    @TheEnd:
    Mov posi,si
    Mov ds,bx
   END;
   Inc(y);
   If y=200 Then
   BEGIN curline:=0; curseg:=s22seg; END
   Else curline:=curline+320;
  END;
 END;
END;

PROCEDURE ReadMiniOrInfo(length: Word);
BEGIN
  GetBlock(Data^,Length);
(*  BlockRead(flicfile,data^,length);*)
END;

PROCEDURE CopyUncompressed;
BEGIN
 GetBlock(Screen21^,64000);
(* BlockRead(flicfile,screen21^,64000);*)
 If head.height = 400 Then
    GetBlock(Screen22^,64000);
(*    BlockRead(flicfile,screen22^,64000);*)
END;

PROCEDURE CopyPage2; Assembler;
ASM
 Push ds
 {Set destination}
 Mov cx,SegA000
 Mov es,cx
 Mov di,0
 {Set source:}
 Mov si,0
 Mov ds,s21seg
 {Set number of words to move:}
 Mov cx,32000
 {Move:}
 Cld
 Rep Movsw
 Pop ds
END;

PROCEDURE ClearMCGAPage2; Assembler;
ASM
 Push ds
 Mov si,0
 Mov ds,s21seg
 Mov ax,0
 Mov cx,32000
 Cld
 Rep Stosw
 Pop ds
END;

PROCEDURE GoMCGA; Assembler;
ASM
 Mov   al,13h
 Mov   ah,0
 Int   10h
END;

Function PlayChunk(CHead: ChunkHead): Byte;
BEGIN
 Case CHead.tp Of
  FLI_LC:    ReadLineCompressed(chead.length-6);
  FLI_DELTA: ReadDeltaCompressed(chead.length-6);
  FLI_BRUN:  ReadRunLength(chead.length-6);
  FLI_Color: ReadColorMap(chead.length-6,63);
  FLI_256:   ReadColorMap(chead.length-6,255);
  FLI_Copy:  CopyUncompressed;
  FLI_Black: SetBlack;
  FLI_Mini:  ReadMiniOrInfo(chead.length-6);
  Else
     If fhead.magic=$00A1 then
        ReadMiniOrInfo(chead.length-6)
     Else
        Begin
          PlayChunk := fe_InvalidType;
          Exit;
        end;
 END;
 WaitFor(head.speed);
 If head.height=400 then
    TwkCopyPage2
 Else
    Begin
      CopyPage2_386(s21seg,SegA000);
    end;
 StartTimer;
 PlayChunk := 0;
END;

Function PlayFlic(Speed: Word): Byte;
Var   B: Byte;
      CH: ChunkHead;
      Count,ChunkNumber: Word;
Begin
  InstallFastTimer;
  If Speed <> 0 then
     Head.Speed := Speed;
  If head.magic = $AF11 then
     head.speed:=14*head.speed;
  If head.height=200 Then
     BEGIN
       GoMCGA;
       If MaxAvail < SizeOf(VirScreen) then
          Begin
            PlayFlic := fe_NotEnoughMemory;
            Exit;
          end;
       GetMem(screen21,SizeOf(VirScreen));
       s21seg:=Seg(screen21^);
       ClearMCGAPage2;
       CopyPage2_386(s21seg,SegA000);
     END
  Else
     If head.height=400 Then
        BEGIN
          InitTweak;
          TwkClearPage2;
          TwkCopyPage2;
        END
     Else
        Begin
          PlayFlic := fe_WrongResolution;
          Exit;
        end;
  Repeat
    StartTimer;
   CurrentFrame := StartFrame;
   {$IFNDEF DPMI}
   Offset := 0;
   {$ENDIF}
   For Count := 1 to head.Frames do
     Begin
       {$IFDEF DPMI}
       Offset := 0;
       {$ENDIF}
       For ChunkNumber := 1 to CurrentFrame^.Chunks do
         Begin
           If Not GetBlock(CH,SizeOf(Ch)) then
              Begin
                PlayFlic := fe_GeneralError;
                Exit;
              end;
           B := PlayChunk(Ch);
           If B <> 0 then
              Begin
                PlayFlic := B;
                Exit;
              end;
         end; { For }
       CurrentFrame := CurrentFrame^.Next;
     end; { For }
   WaitFor(head.speed);
  Until KeyPressed;
  PlayFlic := 0;
END;

Function NumberOfFrames: Word;
Begin
  NumberOfFrames := Head.Frames;
end;

Function ReadFrames: Byte;
Var Count:     Word;
    P,OldP:    FramesList;
    {$IFNDEF DPMI}
    MaxFree: Integer;
    Size: Word;
    {$ENDIF}
BEGIN
 {$IFNDEF DPMI}
 MaxFree := XMSFreeBlock;
 If MaxFree <> -1 then
    If Not GetXMSMemory(MaxFree-1,XMSHandle) then
       Begin
         ReadFrames := fe_NotEnoughMemory;
         Exit;
       end;
 Offset := 0;
 {$ENDIF}
 For Count := 1 to Head.Frames do
   Begin
     If Not ReadBlock(fhead,SizeOf(FrameHead)) then
        Begin
          ReadFrames := fe_FlicReadError;
          Exit;
        end;
        If (fhead.magic <> $F1FA) And (fhead.magic <> $00A1) then
           Begin
             ReadFrames := fe_NotAFlic;
             Exit;
           end;
        If fhead.Length > BufSize then
           Begin
             ReadFrames := fe_InvalidType;
             Exit;
           end;
        If MaxAvail < 1024 then { 1K safetypool ! }
           Begin
             Readframes := fe_NotEnoughMemory;
             Exit;
           end;
        OldP := P;
        New(P);
        P^.FrameSize := fhead.Length-SizeOf(fhead);
        P^.Chunks := fhead.Chunks;
        {$IFDEF DPMI}
        If MaxAvail < P^.FrameSize then
           Begin
             Readframes := fe_NotEnoughMemory;
             Exit;
           end;
        GetMem(P^.FrameData,P^.FrameSize);
        If Not ReadBlock(P^.FrameData^,P^.FrameSize) then
        {$ELSE}
        If Not ReadBlock(Data^,P^.FrameSize) then
        {$ENDIF}
           Begin
             Readframes := fe_FlicReadError;
             Exit;
           end;
        {$IFNDEF DPMI}
        Size := P^.FrameSize;
        If Odd(Size) then { XMS-blocks must have even lengths,
                            don't know why?? }
           INC(Size);
        If Not MoveToXMS(Data,XMSHandle,Offset,Size) then
           Begin
             ReadFrames := fe_GeneralError;
             Exit;
           end;
        P^.Offs := Offset;
        INC(Offset,Size);
        {$ENDIF}
        P^.Next := NIL;
        If StartFrame = NIL then
           StartFrame := P
        Else
           Begin
             OldP^.Next := P;
           end;
   end; { For }
  {$IFNDEF DPMI}
  { Allocating all the XMS-memory is probably too much: }
  If Not ReallocateXMSBlock(XMSHandle,Offset div 1024 +1) then
     Begin
       ReadFrames := fe_GeneralError;
       Exit;
     end;
  {$ENDIF}
  ReadFrames := 0;
END;

Function FlicErrorStr(ErrorNr: Byte): String;
Var Str: String;
Begin
  Str := '';
  Case ErrorNr of
    fe_NotAFlic:
      Str := 'Not a flicfile';
    fe_FlicReadError:
      Str := 'Error reading flicfile';
    fe_WrongResolution:
      Str := 'Wrong resolution';
    fe_InvalidType:
      Str := 'Invalid flicfile';
    fe_FileNotFound:
      Str := 'Flicfile not found';
    fe_NotEnoughMemory:
      Str := 'Not enough memory';
    fe_InvalidInPut:
      Str := 'Bad input';
    fe_GeneralError:
      Str := 'Fatal error';
  end; { CASE }
  FlicErrorStr := Str;
end;

Begin
  Chain := ExitProc;
  ExitProc := @ExitProcedure;
end.