Unit XMSUnit;
{ This unit provides many routines to acces extended memory

  Author:      N. De Smedt (alias ThunderByte)
  E-Mail:      DeSmedt@uia.ua.ac.be
  Last update: 15/01/1995

--------------------------------------------------------------------------- }

INTERFACE

Uses DOS;

Type MoveRec = RECORD
       Size: Longint;
       SourceHandle: Word;
       SourceOffset: Longint;
       DestHandle: Word;
       DestOffset: Longint;
     end;

Var Regs: Registers;
    XMSAvailable: Boolean;
    XMSPtr: Pointer;
    XMSVersion: String;
    XMSError: Integer;
    MoveBlock: MoveRec;

Function XMSErrorStr(Fout: Integer): String;
Function XMSDriverPresent: Boolean;
Function XMSEntryPoint: Pointer;
Function ConvertBCD(BCD: Byte): Word;
Function XMSDriverVersion: Longint;
  { Hiword (DX): major version number. }
  { LoWord (AX): revision number. }
Function HMA: Byte;
{ 0: HMA present, in use (usually by DOS)
  1: HMA present, not in use
  2: HMA not present }
Function XMSVersionStr: String;
Function EnableA20: Boolean;
Function XMSFreeBlock: Integer;
  {  Biggest free XMS block (K), otherwise -1 (error) }
Function XMSTotalFree: Integer;
  { total XMS (K), otherwise -1 (error) }
Function MaxUMB: Word; { UMB: Upper Memory Block: memory between 640K - 1Mb }
Function GetXMSMemory(Size: Word; VAR Handle: Word): Boolean;
{ Size in K }
Function FreeXMS(Handle: Word): Boolean;
Function MoveToXMS(SourcePointer: Pointer; DHandle: Word;
                          DestOffs,Bytes: Longint): Boolean;
Function MoveFromXMS(SHandle: Word; SourceOffs: Longint; DestPtr: Pointer;
                          Bytes: Longint): Boolean;
Function LockBlock(Handle: Word): Pointer;
{ NIL on error }
Function UnLockBlock(Handle: Word): Boolean;
Function XMSHandleInfo(Handle: Word): Word;
{ Low  byte: number of protected blocks }
{ High byte: number of free handles }
Function ReallocateXMSBlock(Handle,NewSize: Word): Boolean;
{ NewSize in K }
Function GetUMBBlock(Para: Word): Word;
{ = 0 on error; <> 0: segment }
Function FreeUMBBlock(SegNr: Word): Boolean;
Procedure XMSInit;

IMPLEMENTATION

Function XMSErrorStr(Fout: Integer): String;
Var EStr: String;
Begin
  EStr := '';
  Case Fout of
    $80: EStr := 'Function not implemented';
    $81: EStr := 'VDISK device-driver found';
    $82: EStr := 'A20 error discovered';
    $8E: EStr := 'General drivererror';
    $8F: EStr := 'Unrecoverable drivererror';
    $90: EStr := 'High memory area (HMA) not present';
    $91: EStr := 'High memory area (HMA) already in use';
    $92: EStr := 'Size bytes less than /HMAMIN driverparameter';
    $93: EStr := 'High memory area (HMA) not used';
    $94: EStr := 'A20 line still in use';
    $A0: EStr := 'All extended memory currently in use';
    $A1: EStr := 'No more extended memory handles';
    $A2: EStr := 'Invalid handle';
    $A3: EStr := 'Invalid source handle';
    $A4: EStr := 'Invalid source offset';
    $A5: EStr := 'Invalid destination handle';
    $A6: EStr := 'Invalid destination offset';
    $A7: EStr := 'Invalid length';
    $A8: EStr := 'Transfer has an invalid overlap';
    $A9: EStr := 'Parity error';
    $AA: EStr := 'Block not protected';
    $AB: EStr := 'Block is protected';
    $AC: EStr := 'Count of protected handles is to long';
    $AD: EStr := 'Error in protecting';
    $B0: EStr := 'Smaller upper memory block (UMB) available';
    $B1: EStr := 'No more upper memory blocks (UMB) availalbe';
    $B2: EStr := 'Invalid segmentnumber (upper memory block)';
  end; { CASE }
  XMSErrorStr := EStr;
end;

Function XMSDriverPresent: Boolean; ASSEMBLER;
ASM
  MOV  AX,4300h
  INT  2Fh
  CMP  AL,80h
  JNE  @@01
  MOV  AL,1
  JMP  @@02
@@01:
  XOR  AL,AL
@@02:
end;

Function XMSEntryPoint: Pointer;
Begin
  Regs.AH := $43;
  Regs.AL := $10;
  Intr($2F,Regs);
  XMSEntryPoint := Ptr(Regs.ES,Regs.BX);
end;

Function ConvertBCD(BCD: Byte): Word; Assembler;
ASM
  XOR  AX,AX
  XOR  BX,BX
  MOV  BL,BCD
  PUSH BX
  MOV  CL,4
  SHR  BL,CL
  MOV  CL,10
  MOV  AL,BL
  MUL  CL
  POP  BX
  AND  BL,00001111b
  ADD  AX,BX
end;

Function XMSDriverVersion: Longint; ASSEMBLER;
ASM
  XOR   AH,AH
  CALL  XMSPtr
  MOV   DX,AX { Hiword (DX): major versionnr. }
  MOV   AX,BX { LoWord (AX): revisionnr. }
end;

Function HMA: Byte; ASSEMBLER;
{ 0: HMA present, in use
  1: HMA present, not in use
  2: HMA not present }
ASM
  XOR   AH,AH
  CALL  XMSPtr
  OR    DX,DX
  JZ    @@01
  MOV   AH,01h
  MOV   DX,0FFFFh
  CALL  XMSPtr
  OR    AX,AX
  JNZ   @@02
  CMP   BL,91h { HMA already in use ? }
  JE    @@04
  MOV   AL,1
  JMP   @@03
@@02:
  CMP   BL,91h
  JE    @@04
  MOV   AH,02h
  CALL  XMSPtr
  MOV   AL,1
@@04:
  XOR   AL,AL
  JMP   @@03
@@01: { HMA not present ! }
  MOV   AL,02
@@03:
end;

Function S(L: Longint): String;
Var H: String;
Begin
  Str(L,H);
  S := H;
end;

Function XMSVersionStr: String;
Type DoubleWordRec = RECORD
       LoWord: Word;
       HiWord: Word;
     end;
Var Version: Longint;
    H: String;
    DoubleWord: DoubleWordRec;
Begin
  Version := XMSDriverVersion;
  Move(Version,DoubleWord,4);
  With DoubleWord do
    Begin
      H := S(ConvertBCD(Hi(HiWord)))+'.'+S(ConvertBCD(Lo(HiWord)));
      H := H + '           revisienr: ';
      H := H + S(ConvertBCD(Hi(LoWord)))+'.'+S(ConvertBCD(Lo(LoWord)));
    end; { WITH }
  XMSVersionStr := H;
end;

Function EnableA20: Boolean; ASSEMBLER;
ASM
  MOV   AH,007h
  CALL  XMSPTR
end;

Function XMSFreeBlock: Integer; ASSEMBLER;
ASM
  MOV   AH,008h
  CALL  XMSPtr
  OR    AX,AX
  JNZ   @@01
  MOV   AX,0FFFFh { Error; return -1 }
@@01:
end;

Function XMSTotalFree: Integer; ASSEMBLER;
ASM
  MOV   AH,008h
  CALL  XMSPtr
  OR    AX,AX
  JNZ   @@01
  MOV   AX,0FFFFh { Error; return -1 }
@@01:
  MOV   AX,DX
end;

Function MaxUMB: Word; ASSEMBLER;
ASM
  MOV   AH,010h
  MOV   DX,0FFFFh
  CALL  XMSPtr
  MOV   AX,DX
end;

Function GetXMSMemory(Size: Word; VAR Handle: Word): Boolean;
Var XMSHandle: Word;
Begin
  XMSError := 0;
  ASM
    MOV   AH,009h
    MOV   DX,Size
    CALL  XMSPtr
    OR    AX,AX
    JZ    @@01
    MOV   XMSHandle,DX
    JMP   @@02
@@01:
    XOR   BH,BH
    MOV   XMSError,BX
@@02:
  end;
  If XMSError = 0 then
     Begin
       Handle := XMSHandle;
       GetXMSMemory := True;
     end
  Else
     Begin
       Handle := 0;
       GetXMSMemory := False;
     end
end;

Function FreeXMS(Handle: Word): Boolean;
Begin
  XMSError := 0;
  ASM
    MOV   AH,0Ah
    MOV   DX,Handle
    CALL  XMSPtr
    OR    AX,AX
    JNZ    @@01
    XOR   BH,BH
    MOV   XMSError,BX
@@01:
  end;
  FreeXMS := (XMSError = 0);
end;

Function MoveToXMS(SourcePointer: Pointer; DHandle: Word;
                          DestOffs,Bytes: Longint): Boolean;
Begin
  With MoveBlock do
    Begin
      SourceHandle := 0;
      SourceOffset := Longint(SourcePointer);
      DestHandle := DHandle;
      DestOffset := DestOffs;
      Size := Bytes;
    end; { WITH }
  XMSError := 0;
  ASM
    PUSH DS
    MOV  AX,SEG MoveBlock
    MOV  DS,AX
    MOV  SI,OFFSET MoveBlock
    MOV  AH,0Bh
    CALL XMSPtr
    POP  DS
    OR   AX,AX
    JNZ  @@01
    XOR  BH,BH
    MOV  XMSError,BX
@@01:
  end;
  MoveToXMS := (XMSError = 0);
end;

Function MoveFromXMS(SHandle: Word; SourceOffs: Longint; DestPtr: Pointer;
                          Bytes: Longint): Boolean;
Begin
  With MoveBlock do
    Begin
      SourceHandle := SHandle;
      SourceOffset := SourceOffs;
      DestHandle := 0;
      DestOffset := Longint(DestPtr);
      Size := Bytes;
    end; { WITH }
  XMSError := 0;
  ASM
    PUSH DS
    MOV  AX,SEG MoveBlock
    MOV  DS,AX
    MOV  SI,OFFSET MoveBlock
    MOV  AH,0Bh
    CALL XMSPtr
    POP  DS
    OR   AX,AX
    JNZ  @@01
    XOR  BH,BH
    MOV  XMSError,BX
@@01:
  end;
  MoveFromXMS := (XMSError = 0);
end;

Function LockBlock(Handle: Word): Pointer; ASSEMBLER;
{ NIL on error }
ASM
  MOV  AH,0Ch
  MOV  DX,Handle
  CALL XMSPtr
  OR   AX,AX
  JZ   @@01
  MOV  AX,BX
  JMP  @@02
@@01:
  XOR  AX,AX
  XOR  DX,DX
@@02:
end;

Function UnLockBlock(Handle: Word): Boolean; ASSEMBLER;
ASM
  MOV  AH,0Dh
  MOV  DX,Handle
  CALL XMSPtr
end;

Function XMSHandleInfo(Handle: Word): Word; ASSEMBLER;
{ Low  byte: number of protected blocks }
{ High byte: number of free handles }
ASM
  MOV  AH,0Eh
  MOV  DX,Handle
  CALL XMSPtr
  OR   AX,AX
  JNZ  @@01
  XOR  BH,BH
  MOV  XMSError,BX
  XOR  AX,AX
  JMP  @@02
@@01:
  MOV  AH,BH
  MOV  AL,BL
@@02:
end;

Function ReallocateXMSBlock(Handle,NewSize: Word): Boolean; ASSEMBLER;
ASM
  MOV  AH,0Fh
  MOV  DX,Handle
  MOV  BX,NewSize
  CALL XMSPtr
  OR   AX,AX
  JNZ  @@01
  XOR  BH,BH
  MOV  XMSError,BX
@@01:
end;

Function GetUMBBlock(Para: Word): Word; ASSEMBLER;
{ = 0 on error; <> 0: segmentnr }
ASM
  MOV  AH,010h
  MOV  DX,Para
  CALL XMSPtr
  OR   AX,AX
  JNZ  @@01
  XOR  BH,BH
  MOV  XMSError,BX
  JMP  @@02
@@01:
  MOV  AX,BX
@@02:
end;

Function FreeUMBBlock(SegNr: Word): Boolean; ASSEMBLER;
ASM
  MOV  AH,011h
  MOV  DX,SegNr
  CALL XMSPtr
  OR   AX,AX
  JNZ  @@01
  XOR  BH,BH
  MOV  XMSError,BX
@@01:
end;

Procedure XMSInit;
Begin
  XMSError := 0;
  FillChar(MoveBlock,SizeOf(MoveBlock),#0);
  XMSPtr := NIL;
  XMSAvailable := (XMSDriverPresent) and (Hi(DosVersion) >= 5);
  If XMSAvailable then
     Begin
       XMSPtr := XMSEntryPoint;
       XMSVersion := XMSVersionStr;
     end;
end;

{ MAIN }
{ **** }

Begin
  XMSInit;
end.

{ How to use XMS: }

If GetXMSMemory(5,Handle) then { 5K }
     Begin
       If MoveToXMS(Ptr($B800,0),Handle,0,4096) then
          Begin
            Clrscr;
            Write('The whole screen is now saved in XMS ! ');
            Readln;
            If MoveFromXMS(Handle,0,Ptr($B800,0),4096) then
               Begin
                 Gotoxy(1,25);
                 Write('And back again. . .');
                 Readln;
               end;
          end;
       If FreeXMS(Handle) then;
     end;