
program _Rotation;
{ 3d rotating gravitational well (ahum;-) by Bas van Gaalen, Holland, PD }
uses
  dos,crt,graph;

const
  NofPoints = 168;
  Speed = 0;
  Xc : word = 0;
  Yc : word = 0;
  Zc : word = 300;
  SinTab : array[0..255] of integer = (
    0,3,6,9,13,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58,60,63,66,68,
    71,74,76,79,81,84,86,88,91,93,95,97,99,101,103,105,106,108,110,111,
    113,114,116,117,118,119,121,122,122,123,124,125,126,126,127,127,127,
    128,128,128,128,128,128,128,127,127,127,126,126,125,124,123,122,122,
    121,119,118,117,116,114,113,111,110,108,106,105,103,101,99,97,95,93,
    91,88,86,84,81,79,76,74,71,68,66,63,60,58,55,52,49,46,43,40,37,34,31,
    28,25,22,19,16,13,9,6,3,0,-3,-6,-9,-13,-16,-19,-22,-25,-28,-31,-34,
    -37,-40,-43,-46,-49,-52,-55,-58,-60,-63,-66,-68,-71,-74,-76,-79,-81,
    -84,-86,-88,-91,-93,-95,-97,-99,-101,-103,-105,-106,-108,-110,-111,
    -113,-114,-116,-117,-118,-119,-121,-122,-122,-123,-124,-125,-126,
    -126,-127,-127,-127,-128,-128,-128,-128,-128,-128,-128,-127,-127,
    -127,-126,-126,-125,-124,-123,-122,-122,-121,-119,-118,-117,-116,
    -114,-113,-111,-110,-108,-106,-105,-103,-101,-99,-97,-95,-93,-91,
    -88,-86,-84,-81,-79,-76,-74,-71,-68,-66,-63,-60,-58,-55,-52,-49,
    -46,-43,-40,-37,-34,-31,-28,-25,-22,-19,-16,-13,-9,-6,-3);

type
  PointRec = record
               X,Y,Z : integer;
             end;
  PointPos = array[0..NofPoints] of PointRec;

var
  Point : PointPos;

{----------------------------------------------------------------------------}

procedure SetGraphics;

var
  AutoDetect : pointer;
  GraphMode, GraphDriver : integer;

{$F+}
function DetectVGA : Integer;

var Vid : Integer;

begin
  DetectVGA := 2; { 2 > 640x480x256 }
end;
{$F-}

begin
  AutoDetect := @DetectVGA;
  GraphDriver := InstallUserDriver('SVGA256',AutoDetect);
  GraphDriver := Detect;
  InitGraph(GraphDriver,GraphMode,'i:\bgi');
end;

{----------------------------------------------------------------------------}

procedure Init;

const
  CoorTab : array[0..168,0..2] of integer = (
    (-75,-75,1),(-75,-63,2),(-75,-51,4),(-75,-39,6),
    (-75,-27,8),(-75,-15,10),(-75,-3,11),(-75,9,10),(-75,21,9),
    (-75,33,7),(-75,45,5),(-75,57,3),(-75,69,2),(-63,-75,2),
    (-63,-63,4),(-63,-51,7),(-63,-39,11),(-63,-27,15),(-63,-15,19),
    (-63,-3,20),(-63,9,20),(-63,21,17),(-63,33,13),(-63,45,9),
    (-63,57,6),(-63,69,3),(-51,-75,4),(-51,-63,7),(-51,-51,12),
    (-51,-39,19),(-51,-27,26),(-51,-15,32),(-51,-3,35),(-51,9,34),
    (-51,21,30),(-51,33,23),(-51,45,16),(-51,57,10),(-51,69,5),
    (-39,-75,6),(-39,-63,11),(-39,-51,19),(-39,-39,30),(-39,-27,41),
    (-39,-15,50),(-39,-3,54),(-39,9,53),(-39,21,46),(-39,33,35),
    (-39,45,24),(-39,57,15),(-39,69,8),(-27,-75,8),(-27,-63,15),
    (-27,-51,26),(-27,-39,41),(-27,-27,56),(-27,-15,68),(-27,-3,74),
    (-27,9,72),(-27,21,63),(-27,33,48),(-27,45,33),(-27,57,20),
    (-27,69,11),(-15,-75,10),(-15,-63,19),(-15,-51,32),(-15,-39,50),
    (-15,-27,68),(-15,-15,84),(-15,-3,91),(-15,9,88),(-15,21,77),
    (-15,33,59),(-15,45,41),(-15,57,25),(-15,69,14),(-3,-75,11),
    (-3,-63,20),(-3,-51,35),(-3,-39,54),(-3,-27,74),(-3,-15,91),
    (-3,-3,99),(-3,9,96),(-3,21,84),(-3,33,64),(-3,45,44),
    (-3,57,27),(-3,69,15),(9,-75,10),(9,-63,20),(9,-51,34),
    (9,-39,53),(9,-27,72),(9,-15,88),(9,-3,96),(9,9,94),
    (9,21,81),(9,33,63),(9,45,43),(9,57,26),(9,69,14),
    (21,-75,9),(21,-63,17),(21,-51,30),(21,-39,46),(21,-27,63),
    (21,-15,77),(21,-3,84),(21,9,81),(21,21,70),(21,33,54),
    (21,45,37),(21,57,23),(21,69,12),(33,-75,7),(33,-63,13),
    (33,-51,23),(33,-39,35),(33,-27,48),(33,-15,59),(33,-3,64),
    (33,9,63),(33,21,54),(33,33,42),(33,45,29),(33,57,18),
    (33,69,10),(45,-75,5),(45,-63,9),(45,-51,16),(45,-39,24),
    (45,-27,33),(45,-15,41),(45,-3,44),(45,9,43),(45,21,37),
    (45,33,29),(45,45,20),(45,57,12),(45,69,7),(57,-75,3),
    (57,-63,6),(57,-51,10),(57,-39,15),(57,-27,20),(57,-15,25),
    (57,-3,27),(57,9,26),(57,21,23),(57,33,18),(57,45,12),
    (57,57,7),(57,69,4),(69,-75,2),(69,-63,3),(69,-51,5),
    (69,-39,8),(69,-27,11),(69,-15,14),(69,-3,15),(69,9,14),
    (69,21,12),(69,33,10),(69,45,7),(69,57,4),(69,69,2));

var
  I : word;

begin
  for I := 0 to NofPoints do begin
    Point[I].X := CoorTab[I,0];
    Point[I].Y := CoorTab[I,1];
    Point[I].Z := CoorTab[I,2];
  end;
  for I := 0 to 63 do begin
    port[$3C8] := I;
    port[$3C9] := I div 3;
    port[$3C9] := I;
    port[$3C9] := I div 2;
  end;
end;

{----------------------------------------------------------------------------}

function Sinus(Idx : byte) : integer; begin
  Sinus := SinTab[Idx]; end;

{----------------------------------------------------------------------------}

function Cosin(Idx : byte) : integer; begin
  Cosin := SinTab[(Idx+192) mod 255]; end;

{----------------------------------------------------------------------------}

procedure DoRotation;

const
  Xstep = -1;
  Ystep = 2;
  Zstep = 1;

var
  Xp,Yp : array[0..NofPoints] of word;
  X,Y,Z,X1,Y1,Z1 : integer;
  I : word;
  PhiX,PhiY,PhiZ : byte;
  Color : byte;

begin
  PhiX := 0; PhiY := 0; PhiZ := 0;
  repeat
    while (port[$3da] and 8) <> 8 do;
    while (port[$3da] and 8) = 8 do;
    for I := 0 to NofPoints do begin

      if (Xp[I]+320 < 640) and (Yp[I]+240 < 480) then
        putpixel(Xp[I]+320,Yp[I]+240,0);

      X1 := (Cosin(PhiY)*Point[I].X-Sinus(PhiY)*Point[I].Z) div 128;
      Y1 := (Cosin(PhiZ)*Point[I].Y-Sinus(PhiZ)*X1) div 128;
      Z1 := (Cosin(PhiY)*Point[I].Z+Sinus(PhiY)*Point[I].X) div 128;
      X  := (Cosin(PhiZ)*X1+Sinus(PhiZ)*Point[I].Y) div 128;
      Y  := (Cosin(PhiX)*Y1+Sinus(PhiX)*z1) div 128;
      Z  := (Cosin(PhiX)*Z1-Sinus(PhiX)*Y1) div 128;
      Xp[I] := (Xc*Z-X*Zc) div (Z-Zc);
      Yp[I] := (Yc*Z-Y*Zc) div (Z-Zc);

      if (Xp[I]+320 < 640) and (Yp[I]+240 < 480) then
        putpixel(Xp[I]+320,Yp[I]+240,30+round(Z/8));

      inc(Point[I].Z,Speed); if Point[I].Z > 125 then Point[I].Z := -125;
    end;
    inc(PhiX,Xstep);
    inc(PhiY,Ystep);
    inc(PhiZ,Zstep);
  until keypressed;
end;

{----------------------------------------------------------------------------}

begin
  SetGraphics;
  Init;
  DoRotation;
  textmode(lastmode);
end.
