;-------------------------------------------------------------------------------
;              Copyright (C) 1994 Paul Geary
;-------------------------------------------------------------------------------
;              email me at gearyp@cs.man.ac.uk
;-------------------------------------------------------------------------------

BORDERS=1	                         ;set to 1 for visible border-timings

code 	SEGMENT para public 'CODE'
	ASSUME cs:code
	LOCALS
	.386

ORG	100h
start:
	jmp	main

; setborder 
;descr: debug/change border color
setborder MACRO col
	IF BORDERS
	push	ax
	push	dx
	mov	dx,3dah                  ;STATUS REGISTER-ONE
	in	al,dx                    ;set attribute reg. to address mode
	mov	dx,3c0h                  ;ATTRIBUTE CONTROL REGISTER
	mov	al,11h+32
	out	dx,al                    ;get Overscan colour register
	mov	al,col                   ;get col
	out	dx,al                    ;use col as border retrace colour
	pop	dx
	pop	ax
	ENDIF
	ENDM

; Intro Routines 

; timer 
inittimer PROC NEAR
	mov	eax,fs:[8*4]                    ;get old timer address
	mov	ds:oldint8,eax                  ;store it
	mov	ax,cs
	shl	eax,16
	mov	ax,OFFSET intti8                ;get my interrupt routine
	mov	dx,17000 ;70hz
	jmp	@@1
deinittimer:
	mov	eax,ds:oldint8                  ;get old interrupt
	xor	dx,dx
@@1:	cli                                     ;clear interrupts
	mov	fs:[8*4],eax                    ;patch in my interrupt
	mov	al,036h
	out	43h,al
	mov	al,dl
	out	40h,al
	mov	al,dh
	out	40h,al
	sti
	ret
inittimer ENDP

intti8	PROC FAR ;timer interrupt
	push	ax
	mov	al,20h
	out	20h,al
	inc	cs:framecounter
	pop	ax
	iret
intti8	ENDP

; load indexed palette 
setpal	PROC NEAR
	;ds:si=pointer to colorindices
	mov	dx,3c8h                         ;PEL address write mode
	xor	al,al                           ;clear al
	out	dx,al                           ;select data register zero
	inc	dx                              ;next data register
	mov	cx,8                            ;
@@1:	xor	bh,bh
	mov	bl,ds:[si]
	shr	bl,2
	call	setpl2                          ;write cols
	mov	bl,ds:[si]
	shl	bx,2
	call	setpl2                          ;write cols
	inc	si
	loop	@@1
	ret

setpl2:	and	bx,15*2                         ;limit offset
	mov	ax,word ptr ds:col0[bx]         ;get colour 1+2
	out	dx,al                           ;write col RED
	mov	al,ah                           ;get high-byte
	out	dx,al                           ;write col GREEN
	mov	al,ds:col0[bx+2]                ;get colour 3
	out	dx,al                           ;write col BLUE
	ret
setpal	ENDP

; clear & copy videobuffer to screen 
clearcopy PROC NEAR

	xor	edx,edx                         ;clear reg
       mov     si,OFFSET vbuf
	mov	bx,4                            ;4 bytes at a time!
	mov	cx,110                          ;loop counter
        mov     di,-4
	mov	di,(90*44)-4                   ;vram row-offest
@@1:	mov	bp,5
@@2:	REPT	2
	mov	eax,ds:[si]                     ;get 4 bytes from vbuffer
	add	di,bx
	mov	ds:[si],edx                     ;clear 4 bytes of vbuffer
	add	si,bx                           ;next 4 bytes to read
	mov	es:[di],eax                     ;copy buffer to vram
	ENDM                                    ;moved 8 bytes so far...
	dec	bp
	jnz	@@2                             ;move 40 bytes (1 scan line!)
	add	si,bx                           ;next scan-line
	dec	cx
	jnz	@@1                             ;all 200 scan-lines to copy...
	ret
clearcopy ENDP

; Make Perspective Tabs + Create Random Point Tab 
MakeTabs PROC NEAR
        mov     bx,OFFSET CoordTab
        mov     cx,510
@@c1:
        push    cx
        call    rand
        call    rand
        pop     cx
        loop    @@c1

        mov     bx,512
        mov     cx,800h                         ;loop counter
        mov     si,OFFSET XTable                ;setup pointer to table
MakeX:  mov     eax,0ffffffh
        mov     dx,00ffh
        idiv    bx
        mov     ds:[si],ax                      ;store data
        inc     bx                              ;next perspect
        add     si,2                            ;next pos in table
        loop    MakeX
;======
        xor     eax,eax
        mov     cx,800h                         ;loop counter
        xor     si,si                           ;reset table offset
MakeY:  mov     ax,200
        imul    ds:XTable[si]
;        add     dx,90                           ;add offset into screen
        cmp     dx,199                          ;has pospective gone off ?
        jle     Limit
        mov     dx,199                          ;limit offset
Limit:  mov     ds:YTable[si],dx                ;and store y-offset
        add     si,2                            ;next pos. in buffer
        loop    MakeY
        ret
MakeTabs ENDP

rand    PROC    NEAR
        mov     eax,1107030247
        mul     ds:Seed
        add     eax,97177
        mov     ds:Seed,eax
        shr     eax,15
        and     ax,0fffh
        sub     ax,7ffh
        mov     ds:[bx],ax
        add     bx,2
        ret
rand    ENDP

Test   PROC NEAR
        mov     si,OFFSET LandTxt               ;setup base pointer
        xor     di,di                           ;reset CoordTab offset
        xor     cx,cx
        xor     bx,bx
        xor     dx,dx

        mov     cl,ds:[si]                      ;get char count
        cmp     cx,0                            ;if zero, don't plot any!
        je      End
        mov     ax,cx
        shr     ax,1
        mov     di,128
        mul     di
        mov     bx,ax
        mov     ax,cx
        and     ax,1
        mov     di,64
        mul     di
        add     ax,bx
        neg     ax
        mov     dx,ax
        xor     di,di
;        mov     dx,340                          ;x-coord start pos.
        mov     bp,640                          ;y-coord start-pos.
NxtChar:
        push    cx
        inc     si                              ;next char
        xor     bx,bx
        mov     bl,ds:[si]                      ;get char
        cmp     bx," "                          ;check for <SPACE>
        jne     Space
        add     dx,128
        pop     cx
        loop    NxtChar

Space:
        sub     bx,"A"                          ;need offset
        shl     bx,3                            ;x8 (8 bytes per char!)

        mov     cx,8                            ;8 rows to test
        push    bp                              ;store y-axis
All:
        push    cx
        mov     cx,8                            ;8 bytes to test
        push    dx                              ;store x-axis
DoRow:
        cmp     ds:Font[bx],0                   ;is the byte set ??
        je      Blank                           ;no, it's not set
        mov     ds:CoordTab[di+0],dx            ;store x-coord
        mov     ds:CoordTab[di+2],bp            ;store y-coord
Blank:
        add     dx,16                           ;next x-pos.
        add     di,4                            ;next tab. pos.
        inc     bx                              ;next byte to test
        loop    DoRow                           ;test all 8 bits
        sub     bp,32                           ;next y-coord
        pop     dx                              ;get old x-axis
        add     bx,320-8                        ;next row of font
        pop     cx
        loop    All
        pop     bp                              ;get old y-axis
        add     dx,128                          ;make space for next char
        pop     cx
        loop    NxtChar
End:    ret
Test    ENDP

; advance demo one frame (raw work) 

doit	PROC NEAR

;======= WAIT FOR VSYNC =========================================================

	setborder 0
	mov	dx,3dah                         ;get STATUS REGISTER ONE
@@w1:	in	al,dx
	test	al,8                            ;is screen in vertical retrace ?
	jnz	@@w1                            ;wait for non-retrace
@@w2:	in	al,dx
	test	al,8                            ;is screen at start of retrace ?
	jz	@@w2                            ;wait for beginning of retrace
	setborder 30

; NOTE: Why are there two wait loops ?
; The retrace status indicates only that the vertical retrace is in progress;
; it may be almost finished when you first check. To get around this you need
; to first wait for a display interval and then wait for the vertical retrace.


;====== SET NEW PALETTE ========================================================

	mov	si,ds:index                     ;get palette pointer
	push	si
	call	setpal                          ;set new palette
	pop	si
	add	si,9                            ;next palette
	cmp	si,OFFSET index4                ;check for end of palette list
	jbe	@@i2                            ;if less, no change
	mov	si,OFFSET index1                ;otherwise, reset pointer

;====== SET BITPLANE TO USE ====================================================

@@i2:	mov	ds:index,si                     ;and store
	mov	al,2                            ;index number of the Map Mask Register
	mov	ah,ds:[si+8]                    ;get bitplane to write in vblank
	mov	dx,3c4h                         ;SEQUENCER ADDRESS REGISTER
	out	dx,ax                           ;select bitplane to modify
	call	clearcopy                       ;copy buffer to vram

; NOTE: The Sequencer Address Register selects which register will appear at
; port 3c5h. The index number of the desired register is written to port 3c5h.

; The Map Mask Register enables or disables the specified bit planes during
; a memory write. Each bit set will allow that plane to be modified;, e.g.,
; setting bits 1 and 3 allows cpu to write data to bit planes 1 and 3.

; When using odd/even modes, bits 0 and 1, and 2 and 3 should have the same
; value. When using Chain 4 mode, all four maps should be set the same.

; This register affects all write modes; i.e., all data written to adapter
; memory.

; Bits:         0 = bitplane 0
;               1 = bitplane 1
;               2 = bitplane 2
;               3 = bitplane 3
;               4-7 not used

@@78:
SetX:
        mov     ax,EulerX
        and     ax,1feh                         ;limit euler
        mov     bx,ax
        mov     ax,ds:SineTab[bx]               ;get sine-data
        mov     cx,600
        imul    cx                              ;need 32-bit arithmetic
        mov     OffsetX,dx
        add     bx,4                            ;increment euler
        mov     EulerX,bx                       ;and store new value..
        xor     dx,dx
SetY:
        mov     ax,EulerY
        and     ax,1feh                         ;limit euler
        mov     bx,ax
        mov     ax,ds:SineTab[bx]               ;get sine-data
        mov     cx,100
        imul     cx                              ;need 32-bit arithmetic
        mov     OffsetY,dx
        add     bx,2                            ;increment euler
        mov     EulerY,bx                       ;and store new value..
        xor     dx,dx
SetZ:
        mov     ax,EulerZ
        and     ax,1feh
        mov     bx,ax
        mov     ax,ds:SineTab[bx]
        mov     cx,186
        imul     cx
        mov     cx,Fixit
        mov     Fixit,dx
        sub     OffsetY,cx
        shr     OffsetY,1
        add     bx,8                            ;increment euler
        mov     EulerZ,bx                       ;and store new value..

        mov     di,OFFSET CoordTab              ;setup dot-coord table pointer
        mov     cx,510                          ;510 points to plot!
Plot:
        mov     bx,ds:[di+2]                    ;get y-axis
        mov     ax,ds:[di+2]                    ;get y-axis
        add     ax,OffsetY                      ;add y-offset
        and     ax,7ffh                         ;limit to table
        mov     ds:[di+2],ax                    ;and store new y-coord

        mov     ax,ds:[di+0]                    ;get x-axis
        add     ax,OffsetX                      ;add x-offset

        add     bx,bx                           ;need word offset
        imul    ds:XTable[bx]                   ;get x-coord perspect
        mov     ax,dx
        mov     si,ds:YTable[bx]                ;need y-coord perspect
        add     ax,160                          ;centre on screen

        cmp     ax,319                          ;check for screen edge
        ja      Done                            ;too, big -then don't plot it !
        cmp     si,199
        ja      Done
        cmp     si,0
        jb      Done
        cmp     ax,0
        jb      Done

        add     si,si
        mov     bx,ds:rows[si]                  ;get line addr.
        mov     si,ax                           ;MUST use index reg.
        add     si,si                           ;need word offset
        add     bx,ds:cols[si]                  ;add x-offset
        mov     al,ds:colb[si]                  ;get pixel gfx
        or      ds:[bx],al                      ;plot pixel
Done:
        add     di,4                            ;next dot coords
        loop    Plot                            ;plot all dots
        ret
doit	ENDP

; Main routine 
;stack @ cs:0fffeh

main	PROC NEAR
; Init Segs 
.8086
	push	cs
	push	cs
	pop	ds
	pop	es
	xor	ax,ax                           ;zero used later
	mov	dx,0a000h                       ;vram address
	mov	es,dx                           ;es now points to vram
;segments now set: DS=code/data ES=vram
; Check for 386 
	push	sp                              ;test order of write/decrement
	pop	dx                              ;by PUSH SP
	cmp	dx,sp                           ;if dx=sp, cpu not 80186/80188
	;jz	@@o1
@@o2:	;jmp	endansi                         ;80(1)86 found so exit
.286p
@@o1:	mov	bx,OFFSET rows
	sgdt	ds:[bx]
	cmp	byte ptr ds:[bx+5],0
	;js	@@o2                            ;80(2)86 found so exit
; Check for VGA 
.386p
	mov	fs,ax                           ;ax was zero, fs=zeropage

;segments now set: DS=code/data ES=vram FS=zeropage

	mov	ax,1a00h                        ;Function:
	int	10h                             ;READ DISPLAY COMBINATION
	cmp	al,01ah                         ;1ah indicates vga connected
	jne	endansi                         ;otherwise - forget it..
	cmp	bl,7                            ;check 2nd display for vga
	jb	endansi                         ;any less and it's not

        mov     ax,13h
        int     10h                             ;set 320x200 -256 cols
        mov     cx,"Z"-"A"+1                    ;chars to plot
        mov     bx,16                           ;foreground colour
        mov     ax,"A"+0eh*256                  ;ah=func. al=ascii code
Ascii:  int     10h                             ;plot char
        inc     al                              ;next ascii code
        loop    Ascii                           ;plot all chars
        mov     cx,8*320/2                      ;size of block to copy
        mov     bx,OFFSET Font                  ;destination
        xor     di,di                           ;reset gfx offset
Copy:   mov     ax,es:[di]                      ;get gfx
        mov     ds:[di+bx],ax                   ;store gfx
        add     di,2                            ;next word
        loop    Copy

; Initialize - vga 

	mov	ax,0dh                          ;Function: vga 16 col 320x200
	int	10h                             ;SET VIDEO STATE

	;set up rows/cols/etc

	mov	si,-2                           ;buffer-offset
	mov	di,OFFSET vbuf-44               ;vram buffer-pointer
	mov	bl,128
	xor	bp,bp                           ;reset columns-offset
	jmp	@@b4
@@b1:	mov	ds:rows[si],di                  ;store row-offset
	mov	ds:colb[si],bl                  ;store pixel-gfx
	mov	ds:cols[si],bp                  ;store columns-offset
	ror	bl,1                            ;rotate pixel right
	jnc	@@b4                            ;shift 8 times
	inc	bp                              ;next column
@@b4:	add	di,44                           ;next row-offset
	add	si,2                            ;next pos in buffer
	cmp	si,(320)*2                      ;check for last column
	jle	@@b1                            ;jump if less-than..

	;set simplex palette order (16 color mode)

	mov	dx,3dah
	in	al,dx
	mov	dl,0c0h
	xor	ax,ax
	mov	cx,16
@@b2:	out	dx,al
	out	dx,al
	inc	al
	loop	@@b2
	mov	al,20h
	out	dx,al
; Initialize - others 
	call	inittimer
        call    MakeTabs
        call    Test
; Do the intro stuff 
again:	call	doit                            ;run main routines
	mov	ah,1
	int	16h                             ;read keystroke buffer
	jz	again                           ;if nothing there, keep looping
	mov	ah,0
	int	16h
; DeInitialize 
	call	deinittimer
; Display end ansi (only thing done if no 386 or vga) 
endansi:mov	ax,3h
	int	10h
	mov	si,OFFSET endtext
	push	0b800h	                        ;if the user has an MGA or HGC
	pop	es	                        ;it's not my problem :-)
	xor	di,di
	mov	ah,0eh
@@1:	lodsb
	IFDEF XORTEXTS
	xor	al,17h
	ENDIF
	cmp	al,31
	jae	@@2
	mov	ah,al
	jmp	@@1
@@2:	jz	@@3
	stosw
	jmp	@@1
@@3:	mov	ax,4c00h
	int	21h
main	ENDP

; Initialized (nonzero) data 

udforced LABEL DWORD

col0	db	 0, 0, 0 ,0	;background color
col1	db	 5, 5, 0 ,0	;delay color 3
col2	db	10,10, 0 ,0	;delay color 2
col3	db	30,30, 0 ,0	;delay color 1
col4	db	60,60, 0 	;brightest color
	;1	. x . x . x . x . x . x . x . x
	;2	. . x x . . x x . . x x . . x x
	;4	. . . . x x x x . . . . x x x x
	;8	. . . . . . . . x x x x x x x x
;palette indices for 4 palettes. Last number is bitplane to write
;during the frame having this palette
index1	db	04h,34h,24h,34h,14h,34h,24h,34h	,1 ;1248
index2	db	03h,23h,13h,23h,44h,44h,44h,44h	,8 ;8124
index3	db	02h,12h,44h,44h,33h,33h,44h,44h	,4 ;4812
index4	db	01h,44h,33h,44h,22h,44h,33h,44h	,2 ;2481
index	dw	OFFSET index1                      ;offset to current index

SineTab         LABEL WORD
	dw	0001h,0324h,0648h,096Ah,0C8Ch,0FABh,12C8h,15E2h,18F9h,1C0Bh,1F1Ah,2223h,2528h,2826h,2B1Fh,2E11h
	dw	30FBh,33DFh,36BAh,398Ch,3C56h,3F17h,41CEh,447Ah,471Ch,49B4h,4C3Fh,4EBFh,5133h,539Bh,55F5h,5842h
	dw	5A82h,5CB3h,5ED7h,60EBh,62F1h,64E8h,66CFh,68A6h,6A6Dh,6C23h,6DC9h,6F5Eh,70E2h,7254h,73B5h,7504h
	dw	7641h,776Bh,7884h,7989h,7A7Ch,7B5Ch,7C29h,7CE3h,7D89h,7E1Dh,7E9Ch,7F09h,7F61h,7FA6h,7FD8h,7FF5h
	dw	7FFFh,7FF5h,7FD8h,7FA6h,7F61h,7F09h,7E9Ch,7E1Dh,7D89h,7CE3h,7C29h,7B5Ch,7A7Ch,7989h,7884h,776Bh
	dw	7641h,7504h,73B5h,7254h,70E2h,6F5Eh,6DC9h,6C23h,6A6Dh,68A6h,66CFh,64E8h,62F1h,60EBh,5ED7h,5CB3h
	dw	5A82h,5842h,55F5h,539Bh,5133h,4EBFh,4C3Fh,49B4h,471Ch,447Ah,41CEh,3F17h,3C56h,398Ch,36BAh,33DFh
	dw	30FBh,2E11h,2B1Fh,2826h,2528h,2223h,1F1Ah,1C0Bh,18F9h,15E2h,12C8h,0FABh,0C8Ch,096Ah,0648h,0324h
	dw	0001h,0FCDCh,0F9B8h,0F696h,0F374h,0F055h,0ED38h,0EA1Eh,0E707h,0E3F5h,0E0E6h,0DDDDh,0DAD8h,0D7DAh,0D4E1h,0D1EFh
	dw	0CF05h,0CC21h,0C946h,0C674h,0C3AAh,0C0E9h,0BE32h,0BB86h,0B8E4h,0B64Ch,0B3C1h,0B141h,0AECDh,0AC65h,0AA0Bh,0A7BEh
	dw	0A57Eh,0A34Dh,0A129h,9F15h,9D0Fh,9B18h,9931h,975Ah,9593h,93DDh,9237h,90A2h,8F1Eh,8DACh,8C4Bh,8AFCh
	dw	89BFh,8895h,877Ch,8677h,8584h,84A4h,83D7h,831Dh,8277h,81E3h,8164h,80F7h,809Fh,805Ah,8028h,800Bh
	dw	8001h,800Bh,8028h,805Ah,809Fh,80F7h,8164h,81E3h,8277h,831Dh,83D7h,84A4h,8584h,8677h,877Ch,8895h
	dw	89BFh,8AFCh,8C4Bh,8DACh,8F1Eh,90A2h,9237h,93DDh,9593h,975Ah,9931h,9B18h,9D0Fh,9F15h,0A129h,0A34Dh
	dw	0A57Eh,0A7BEh,0AA0Bh,0AC65h,0AECDh,0B141h,0B3C1h,0B64Ch,0B8E4h,0BB86h,0BE32h,0C0E9h,0C3AAh,0C674h,0C946h,0CC21h
	dw	0CF05h,0D1EFh,0D4E1h,0D7DAh,0DAD8h,0DDDDh,0E0E6h,0E3F5h,0E707h,0EA1Eh,0ED38h,0F055h,0F374h,0F696h,0F9B8h,0FCDCh


LandTxt LABEL BYTE
        db      4,"PAUL"

endtext	LABEL BYTE ;endansi... well... endansiline (numbers are colors)
	db	15
	db	'    (c) Paul Geary (Gor)'
	db	3,'  ',11
	db	'LandRunner - in 80x86 Assembler'
	db	3,'  ',15
	db	'6/3/94'
	db	31


; Uninitialized (zero) data 

zerobeg	LABEL WORD ;start zero clear from here
Seed    dd      0
OffsetX dw      0
OffsetY dw      0
EulerX  dw      0
EulerY  dw      0
EulerZ  dw      0
Fixit   dw      0
CoordTab dw     510  dup (0,0)
XTable  dw      800h dup (0)
YTable  dw      800h dup (0)
rows	dw	320  dup (0)	;offsets to screen rows
cols	dw	320  dup (0)	;offsets to screen cols
colb	db	320  dup (0,0)	;bitmasks for screen cols

ALIGN 4
vbuf	LABEL BYTE
	db	44*200 dup(0) ;video buffer
ALIGN 4
Font    LABEL BYTE
        db      8 dup(320 dup(0))

ALIGN 4
framecounter dw	0
oldint8	     dd	0

zeroend	LABEL WORD ;end zero clear here

code 	ENDS
	END start
