/******************************************************************************\

  Copyright 1993 The Regents of the University of California.
  Modification Copyright 1995 The University of North Carolina at Chapel Hill.
  All Rights Reserved.

  Permission to use, copy, modify and distribute this software and its
  documentation for educational, research and non-profit purposes, without
  fee, and without a written agreement is hereby granted, provided that the
  above copyright notice and the following three paragraphs appear in all
  copies.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA OR THE UNIVERSITY OF NORTH CAROLINA
  AT CHAPEL HILL BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL,
  OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS
  SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF CALIFORNIA OR THE UNIVERSITY
  OF N. CAROLINA HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.


  Permission to use, copy, modify and distribute this software and its
  documentation for educational, research and non-profit purposes, without
  fee, and without a written agreement is hereby granted, provided that the
  above copyright notice and the following three paragraphs appear in all
  copies.

  THE UNIVERSITY OF CALIFORNIA AND THE UNIVERSITY OF NORTH CAROLINA SPECIFICALLY
  DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED
  HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATIONS
  TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

  The authors may be contacted via:

  US Mail:  Brian Mirtich                       J. Cohen/M. Lin/D. Manocha/K. Ponamgi
            387 Soda Hall                       Department of Computer Science
            Computer Science Division           Sitterson Hall, CB #3175
            University of California            University of N. Carolina
            Berkeley, CA 94720                  Chapel Hill, NC 27599-3175

  Phone:     (510) 642-8149                     (919)962-1749

  EMail:     mirtich@cs.berkeley.edu           {cohenj,lin,manocha,ponamgi}@cs.unc.edu




\*****************************************************************************/


/*****************************************************************************\
  matrix.h
  --
  Description : Type declarations and prototypes for matrix and vector
                routines. 

\*****************************************************************************/

/* Protection from multiple includes. */
#ifndef INCLUDED_COLLISION_MATRIX_H
#define INCLUDED_COLLISION_MATRIX_H


/*------------------ Includes Needed for Definitions Below ------------------*/


/*-------------------------------- Constants --------------------------------*/


/*--------------------------------- Macros ----------------------------------*/


/*---------------------------------- Types ----------------------------------*/


typedef double __col_Real;


typedef __col_Real col_Mat3[3][3];
typedef __col_Real col_Mat4[4][4];

typedef __col_Real col_Vect3[3];
typedef __col_Real col_Vect4[4];

/*---------------------------- Function Prototypes --------------------------*/

void __col_mat4Add(col_Mat4 a, col_Mat4 b, col_Mat4 c);
void __col_mat4Sub(col_Mat4 a, col_Mat4 b, col_Mat4 c);
void __col_mat4Mult(col_Mat4 a, col_Mat4 b, col_Mat4 c);
void __col_mat3Mult(col_Mat3 a, col_Mat3 b, col_Mat3 c);
void __col_mat4Copy(col_Mat4 source, col_Mat4 dest);
void __col_mat3Copy(col_Mat3 source, col_Mat3 dest);
void __col_mat4Transpose(col_Mat4 source, col_Mat4 dest);
void __col_mat3Transpose(col_Mat3 source, col_Mat3 dest);
void __col_mat4Print(col_Mat4 M, char *name);
void __col_mat3Print(col_Mat3 M, char *name);

void __col_matMultXform(col_Mat4 a, col_Mat4 b, col_Mat4 c);
void __col_matInvertXform(col_Mat4 M, col_Mat4 inv);
void __col_matBuildXform(char *axes, __col_Real angles[],
			 __col_Real dx, __col_Real dy, __col_Real dz,
			 col_Mat4 M);

void __col_xformPoint(col_Mat4 M, col_Vect3 p, col_Vect3 p2);
void __col_xformVect(col_Mat4 M, col_Vect3 v, col_Vect3 v2);
void __col_xform4(col_Mat4 M, col_Vect4 x, col_Vect4 x2);
void __col_xform3(col_Mat3 M, col_Vect3 x, col_Vect3 x2);

void __col_vectCopy(col_Vect3 src, col_Vect3 dest);
void __col_vectAdd(col_Vect3 a, col_Vect3 b, col_Vect3 c);
void __col_vectSub(col_Vect3 a, col_Vect3 b, col_Vect3 c);
void __col_vectNeg(col_Vect3 src, col_Vect3 dest);
void __col_vectScale(col_Vect3 src, col_Vect3 dest, __col_Real k);
void __col_vectNormalize(col_Vect3 src, col_Vect3 dest);

__col_Real __col_vectNorm(col_Vect3 v);
int __col_vectEqual(col_Vect3 a, col_Vect3 b);
__col_Real __col_vectDotProd(col_Vect3 a, col_Vect3 b);
void __col_vectXprod(col_Vect3 a, col_Vect3 b, col_Vect3 c);
__col_Real __col_planeDist(col_Vect4 plane, col_Vect3 point);
void __col_displacePoint(col_Vect3 point, col_Vect3 vect,
			 __col_Real lambda, col_Vect3 result);

/*---------------------------Globals (externed)------------------------------*/

extern col_Mat3 __col_mat3IDENTITY;
extern col_Mat4 __col_mat4IDENTITY;



/* Protection from multiple includes. */
#endif /* INCLUDED_COLLISION_MATRIX_H */



/*****************************************************************************\
\*****************************************************************************/
