/******************************************************************************\

  Copyright 1995 The University of North Carolina at Chapel Hill.
  All Rights Reserved.

  Permission to use, copy, modify and distribute this software and its
  documentation for educational, research and non-profit purposes, without
  fee, and without a written agreement is hereby granted, provided that the
  above copyright notice and the following three paragraphs appear in all
  copies.

  IN NO EVENT SHALL THE UNIVERSITY OF NORTH CAROLINA
  AT CHAPEL HILL BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL,
  OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS
  SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY
  OF NORTH CAROLINA HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.


  Permission to use, copy, modify and distribute this software and its
  documentation for educational, research and non-profit purposes, without
  fee, and without a written agreement is hereby granted, provided that the
  above copyright notice and the following three paragraphs appear in all
  copies.

  THE UNIVERSITY OF NORTH CAROLINA SPECIFICALLY
  DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED
  HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF NORTH CAROLINA HAS NO OBLIGATION
S
  TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

  The authors may be contacted via:

  US Mail:             J. Cohen/M. Lin/D. Manocha/K. Ponamgi
                       Department of Computer Science
                      Sitterson Hall, CB #3175
                       University of N. Carolina
                       Chapel Hill, NC 27599-3175

  Phone:               (919)962-1749

  EMail:              {cohenj,lin,manocha,ponamgi}@cs.unc.edu




\*****************************************************************************/


/*****************************************************************************\
  options.h
  --
  Description : This header file contains defintions for controlling
                fundamental parameters of the overall compilation.

\*****************************************************************************/

/* Protection from multiple includes. */
#ifndef INCLUDED_COLLISION_OPTIONS_H
#define INCLUDED_COLLISION_OPTIONS_H


/*------------------ Includes Needed for Definitions Below ------------------*/


/*-------------------------------- Constants --------------------------------*/

/*
   Objects are considered to be colliding if their distance is less than or
   equal to some small distance.  Choosing a distance other than 0.0 may avoid
   some possible numerical instabilities if you are running a simulation with
   a controllable distance step size.
*/
#define COL_COLLIDING_DISTANCE (0.0)

/*
   A percentage of the bounding box radius may be added as a buffer zone to
   cause the activation of distance tracking within a larger range of the
   object
*/
#define COL_CUBOID_BUFFER_PERCENT (50.0)
#define COL_DYNAMIC_BOX_BUFFER_PERCENT (50.0)


/*
   COL_DENSE_MATRIX or COL_SPARSE_MATRIX - COL_DENSE_MATRIX is a bit more space
   efficient if you're planning on activating most of the n^2 pairs,
   otherwise, use COL_SPARSE_MATRIX
*/
#define COL_SPARSE_MATRIX

/*--------------------------------- Macros ----------------------------------*/


/*---------------------------------- Types ----------------------------------*/


/*---------------------------- Function Prototypes --------------------------*/


/*---------------------------Globals (externed)------------------------------*/



/* Protection from multiple includes. */
#endif /* INCLUDED_COLLISION_OPTIONS_H */



/*****************************************************************************\
\*****************************************************************************/
