/******************************************************************************\

  Copyright 1995 The University of North Carolina at Chapel Hill.
  All Rights Reserved.

  Permission to use, copy, modify and distribute this software and its
  documentation for educational, research and non-profit purposes, without
  fee, and without a written agreement is hereby granted, provided that the
  above copyright notice and the following three paragraphs appear in all
  copies.

  IN NO EVENT SHALL THE UNIVERSITY OF NORTH CAROLINA
  AT CHAPEL HILL BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL,
  OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS
  SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY
  OF NORTH CAROLINA HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.


  Permission to use, copy, modify and distribute this software and its
  documentation for educational, research and non-profit purposes, without
  fee, and without a written agreement is hereby granted, provided that the
  above copyright notice and the following three paragraphs appear in all
  copies.

  THE UNIVERSITY OF NORTH CAROLINA SPECIFICALLY
  DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED
  HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF NORTH CAROLINA HAS NO OBLIGATION
S
  TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

  The authors may be contacted via:

  US Mail:             J. Cohen/M. Lin/D. Manocha/K. Ponamgi
                       Department of Computer Science
                      Sitterson Hall, CB #3175
                       University of N. Carolina
                       Chapel Hill, NC 27599-3175

  Phone:               (919)962-1749

  EMail:              {cohenj,lin,manocha,ponamgi}@cs.unc.edu


\*****************************************************************************/


/*****************************************************************************\
  graphics.h
  --
  Description : Header file to select graphics routines

\*****************************************************************************/

/* Protection from multiple includes. */
#ifndef INCLUDED_NBODY_GRAPHICS_H
#define INCLUDED_NBODY_GRAPHICS_H


/*------------------ Includes Needed for Definitions Below ------------------*/

/*
   Use an include file for each supported graphics platform
*/
#include <sgi.h>

/*-------------------------------- Constants --------------------------------*/


/*--------------------------------- Macros ----------------------------------*/


/*---------------------------------- Types ----------------------------------*/


/*---------------------------- Function Prototypes --------------------------*/

#ifdef NO_GRAPHICS

#define graphics_init(a)
#define graphics_per_library_object_init(a)
#define graphics_per_object_instance_init(a)
#define graphics_draw_scene(a,b)

#else

#ifdef SGI_GRAPHICS
#define graphics_init(a) sgi_graphics_init(a)
#define graphics_per_library_object_init(a)  sgi_graphics_per_library_object_init(a)
#define graphics_per_object_instance_init(a) sgi_graphics_per_object_instance_init(a)    
#define graphics_draw_scene(a,b) sgi_graphics_draw_scene(a,b)
#endif

#endif






/*---------------------------Globals (externed)------------------------------*/



/* Protection from multiple includes. */
#endif /* INCLUDED_NBODY_GRAPHICS_H */



/*****************************************************************************\
\*****************************************************************************/

