/******************************************************************************\

  Copyright 1995 The University of North Carolina at Chapel Hill.
  All Rights Reserved.

  Permission to use, copy, modify and distribute this software and its
  documentation for educational, research and non-profit purposes, without
  fee, and without a written agreement is hereby granted, provided that the
  above copyright notice and the following three paragraphs appear in all
  copies.

  IN NO EVENT SHALL THE UNIVERSITY OF NORTH CAROLINA
  AT CHAPEL HILL BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL,
  OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS
  SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY
  OF NORTH CAROLINA HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.


  Permission to use, copy, modify and distribute this software and its
  documentation for educational, research and non-profit purposes, without
  fee, and without a written agreement is hereby granted, provided that the
  above copyright notice and the following three paragraphs appear in all
  copies.

  THE UNIVERSITY OF NORTH CAROLINA SPECIFICALLY
  DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED
  HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF NORTH CAROLINA HAS NO OBLIGATION
S
  TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

  The authors may be contacted via:

  US Mail:             J. Cohen/M. Lin/D. Manocha/K. Ponamgi
                       Department of Computer Science
                      Sitterson Hall, CB #3175
                       University of N. Carolina
                       Chapel Hill, NC 27599-3175

  Phone:               (919)962-1749

  EMail:              {cohenj,lin,manocha,ponamgi}@cs.unc.edu


\*****************************************************************************/


/*****************************************************************************\
  polytope.h
  --
  Description : Some types and constants for the nbody simulation

\*****************************************************************************/

/* Protection from multiple includes. */
#ifndef INCLUDED_NBODY_POLYTOPE_H
#define INCLUDED_NBODY_POLYTOPE_H


/*------------------ Includes Needed for Definitions Below ------------------*/

#include <quat.h>
#include <dist.h>
#include <collision_types.h>

/*-------------------------------- Constants --------------------------------*/

#define DEFAULT_FRAMES         1000
#define DEFAULT_DENSITY        5
#define DEFAULT_VELOCITY       5
#define DEFAULT_ROTATION       10
#define DEFAULT_NUM_OBJECTS    20
#define DEFAULT_LIBRARY        "../data/obj20.dat"

/*--------------------------------- Macros ----------------------------------*/


/*---------------------------------- Types ----------------------------------*/

/*
   nbody's polytope structure
*/
typedef struct Polytope
{
  int           id;                      /* id number from collision library */

  int           colliding;        /* id of polytope currently colliding with */
  int           old_colliding;    /* id of polytope previoiusly colliding with */

  double        object_center[3]; /* center of polytope in object coordinates */
  double        max_radius;       /* max distance from "center" to a vertex */
  
  float         trans_vel[3];            /* translation velocity of object */
  float         trans_tot[3];            /* total amount of translation thus far */

  q_type        tot_quat;                /* current orientation */
  q_type        delta_quat;              /* incremental change to orientation */

  col_Mat4          tot;          /* current polytope transformation */
} Polytope;  

/*
   simulation parameters, etc.
*/
typedef struct Status
{
  int         num_frames;           /* number of frames in simulation */
  int         num_lib_polytopes;    /* objects in library */
  int         num_polytopes;        /* instanced objects */
  int         trans_velocity;       /* percent of object radii per frame*/
  int         rot_velocity;         /* degrees per frame */
  double      working_volume;
  float       density;              /* object volume / working volume * 100 */
  int         use_cuboid;           /* boolean - use cuboid or dynamic boxes */
  int         seed;                 /* random number seed to make reproducable
				       simulations */

  col_Report   *all_collisions;
  int         num_collisions;
} Status;

#define ALLOCATE(ptr, type, num)                        \
{                                                       \
    (ptr) = (type *) calloc((num), sizeof(type));       \
    if ((ptr) == NULL)                                  \
    {                                                   \
        printf("Could not allocate memory.\n");         \
        exit(1);                                        \
    }                                                   \
}

/*---------------------------- Function Prototypes --------------------------*/


/*---------------------------Globals (externed)------------------------------*/



/* Protection from multiple includes. */
#endif /* INCLUDED_NBODY_POLYTOPE_H */



/*****************************************************************************\
\*****************************************************************************/

