Unit DNS;

Interface

Uses UDP,PPP,crt;

Const
  DNS_Port = 53;
  DNS_NO_ERROR        = 0;
  DNS_FORMAT_ERROR    = 1;
  DNS_SERVER_FAILURE  = 2;
  DNS_NAME_ERROR      = 3;
  DNS_NOT_IMPLEMENTED = 4;
  DNS_REFUSED         = 5;

Type
  pDNS = ^DNS_Record;
  DNS_Record = Record
                 id : word;
                 domain : string;
                 ips : string;
                 ip : iptype;
                 error : byte;
                 complete : boolean;
                 time_to_live : longint;
                 prev,next : pDNS;
               end;

Var
  DNS_SERVER : IPTYPE;

Function  GetHostbyName(domain:string):pdns;
Procedure DNS_Done(var frame:pdns);
Procedure DNS_callback;

Implementation

Var
  DNS_ID : word;
  First_DNS,
  Last_DNS,
  Cur_DNS : pDNS;

Function Token(var s:string):string;
var
 x,y : integer;
 ts : string;
Begin
 ts := '';
 x := pos('.',s);
 if (x=0) then
  Begin
    token := s;
    s := '';
  end else
  Begin
    for y := 1 to (x-1) do
     ts := ts + s[y];
    delete(s,1,x);
    token := ts;
  end;
end;

Function GetHostbyName(domain:string):pdns;
var
  data : pbyte;
  datap : pbyte;
  lframe : pDNS;
  domaindata : pbyte;
  ddptr : pbyte;
  dlength : word;
  s : string;
  done : boolean;
  x : byte;
Begin
  new(lframe);
  lframe^.domain := domain;
  fillchar(lframe^.ip,sizeof(lframe^.ip),0);
  lframe^.ips := '';
  lframe^.error := 0;
  lframe^.complete := false;
  lframe^.time_to_live := 0;
  inc(dns_id);
  lframe^.id := dns_id;
  lframe^.prev := last_dns;
  last_dns := lframe;
  cur_dns := lframe;
  lframe^.next := nil;
  if first_dns=nil then first_dns := lframe;
  if lframe^.prev<>nil then lframe^.prev^.next := lframe;
  cur_dns:= lframe;

  getmem(domaindata,512); {Formats DNS Query to spec}
  ddptr := domaindata;
  dlength := 0;
  done := false;
  repeat
    s := token(domain);
    if length(s)=0 then done := true else
      for x := 0 to length(s) do
         Begin
           oUDP.addbyte(ddptr,ord(s[x]));
           inc(dlength);
         end;
  until done;
  oUDP.addbyte(ddptr,0);
  inc(dlength);
  ddptr := domaindata;

  getmem(data,dlength+16);
  datap := data;

  oUDP.addbyte(datap,lframe^.id shr 8);
  oUDP.addbyte(datap,lframe^.id and $00ff);
  oUDP.addbyte(datap,1);
  oUDP.addbyte(datap,0);
  oUDP.addbyte(datap,0);
  oUDP.addbyte(datap,1);
  oUDP.addbyte(datap,0);
  oUDP.addbyte(datap,0);
  oUDP.addbyte(datap,0);
  oUDP.addbyte(datap,0);
  oUDP.addbyte(datap,0);
  oUDP.addbyte(datap,0);
  if dlength>0 then
  for x := 1 to dlength do
    Begin
      oUDP.addbyte(datap,ddptr^);
      inc(ddptr);
    end;
  oUDP.addbyte(datap,0);
  oUDP.addbyte(datap,1);
  oUDP.addbyte(datap,0);
  oUDP.addbyte(datap,1);

  {Send it OFF!}
  oUDP.sendUDP(DNS_ID,DNS_SERVER,DNS_PORT,DNS_PORT,dlength+16,data);

  freemem(data,16+dlength);
  freemem(domaindata,512);
  gethostbyname := lframe;
end;

Procedure DNS_DONE(var frame:pDNS);
Begin
  if frame=nil then exit;

  if frame=first_dns then first_dns := first_dns^.next;
  if frame=last_dns then last_dns := last_dns^.prev;
  if frame=cur_dns then cur_dns := cur_dns^.next;

  if frame^.prev<>nil then frame^.prev^.next := frame^.next;
  if frame^.next<>nil then frame^.next^.prev := frame^.prev;

  dispose(frame);
  frame := nil;
end;

Function GetDNS(id:word):pDNS;
var
 this : pDNS;
Begin
 getdns := nil;
 {writeln('DNS ID : ',id);}
 this := first_dns;
 while this<>nil do
  Begin
    if this^.id=id then
      Begin
        getdns := this;
        exit;
      end;
    this := this^.next;
  end;
end;

Procedure Process_DNS(frame:pUDP);
var
 this : pDNS;
 dummy,
 Z,QR,Opcode,AA,TC,RD,RA,Rcode : byte;
 Qcount,ANCount,NSCount,ARCount : word;
 slen : byte;
 qtype,qcode : word;
 rdlength : word;
 temp : pbyte;
 id : word;

Procedure HandleBS(count:word);
var
 x,y : word;
 compressed : boolean;
Begin
 if count>0 then
 for x := 1 to count do
   Begin
     slen := 1;
     while (slen>0) do
     Begin
       compressed := false;
       slen := oUDP.getbyte(frame^.data_ptr);
       if slen>0 then
       Begin
         if (slen and 192)=192 then {Compressed String}
           Begin
             dummy := oUDP.getbyte(frame^.data_ptr);
             compressed := true;
           end else
           Begin {Regular String}
             for y := 1 to slen do
              Begin
                dummy := oUDP.getbyte(frame^.data_ptr);
                {write(chr(dummy));}
              end;
           end;
       end;
       if compressed then slen := 0;
     end;
     qtype := oUDP.getbyte(frame^.data_ptr) shl 8;
     inc(qtype,oUDP.getbyte(frame^.data_ptr));
     qcode := oUDP.getbyte(frame^.data_ptr) shl 8;
     inc(qcode,oUDP.getbyte(frame^.data_ptr));
   end;
end;

Begin
 frame^.data_ptr := frame^.data;
 temp := frame^.data_ptr;
 id := oUDP.getbyte(frame^.data_ptr) shl 8;
 inc(id,oUDP.getbyte(frame^.data_ptr));
 frame^.data_ptr := temp;
 this := getdns(id);

 if this=nil then exit;
 dummy := oUDP.getbyte(frame^.data_ptr);
 dummy := oUDP.getbyte(frame^.data_ptr);
 dummy := oUDP.getbyte(frame^.data_ptr);
 qr := dummy and 128;
 opcode := dummy and 120;
 aa := dummy and 4;
 tc := dummy and 2;
 rd := dummy and 1;
 dummy := oUDP.getbyte(frame^.data_ptr);
 ra := dummy and 128;
 z := dummy and 112;
 rcode := dummy and 15;
 qcount := oUDP.getbyte(frame^.data_ptr) shl 8;
 inc(qcount,oUDP.getbyte(frame^.data_ptr));
 ancount := oUDP.getbyte(frame^.data_ptr) shl 8;
 inc(ancount,oUDP.getbyte(frame^.data_ptr));
 nscount := oUDP.getbyte(frame^.data_ptr) shl 8;
 inc(nscount,oUDP.getbyte(frame^.data_ptr));
 arcount := oUDP.getbyte(frame^.data_ptr) shl 8;
 inc(arcount,oUDP.getbyte(frame^.data_ptr));
 handlebs(qcount);
 handlebs(ancount);

 this^.time_to_live := oUDP.getbyte(frame^.data_ptr) shl 8;
 inc(this^.time_to_live,oUDP.getbyte(frame^.data_ptr));
 this^.time_to_live := this^.time_to_live shl 16;
 inc(this^.time_to_live,oUDP.getbyte(frame^.data_ptr) shl 8);
 inc(this^.time_to_live,oUDP.getbyte(frame^.data_ptr));

 {if ancount>0 then
   Begin           }
     rdlength := oUDP.getbyte(frame^.data_ptr) shl 8;
     inc(rdlength,oUDP.getbyte(frame^.data_ptr));
     {writeln(rdlength);}
     if rdlength=4 then
       Begin
         this^.ip[1] := oUDP.getbyte(frame^.data_ptr);
         this^.ip[2] := oUDP.getbyte(frame^.data_ptr);
         this^.ip[3] := oUDP.getbyte(frame^.data_ptr);
         this^.ip[4] := oUDP.getbyte(frame^.data_ptr);
         this^.ips := oPPP.ipSTR(this^.ip);
       end else
       Begin
         {Get data to assign domain name!}
       end;
   {end;}
 this^.error := rcode;
 this^.complete := true;
end;

Procedure DNS_callback;
var
 this_udp : pUDP;
 done : boolean;
Begin
  done := false;
  repeat
    this_udp := oUDP.getUDPframe(port,DNS_PORT,0);
    if this_udp=nil then done := true else
      Begin
        Process_DNS(this_udp);
        oUDP.DisposeUDPFrame(this_udp);
      end;
  until done;
end;

Begin
  DNS_ID := 0;
  First_DNS := nil;
  Last_DNS := nil;
  Cur_DNS := nil;

  dns_server[1] := 204; {Ares DNS Server}
  dns_server[2] := 181;
  dns_server[3] := 152;
  dns_server[4] := 2;
end.
