Unit ICMP;

Interface

Uses PPP,IP;

Const
   ICMP_Protocol = 1;
   ECHO_REQUEST             = 8;
   ECHO_REPLY               = 0;
   DESTINATION_UNREACHABLE  = 3;
   SOURCE_QUENCH            = 4;
   REDIRECT                 = 5;
   ROUTER_ADVERTISEMENT     = 9;
   ROUTER_SOLICITATION      = 10;
   TIME_EXCEEDED            = 11;
   PARAMETER_PROBLEM        = 12;
   TIMESTAMP_REQUEST        = 13;
   TIMESTAMP_REPLY          = 14;
   INFORMATION_REQUEST      = 15; {OBSOLETE}
   INFORMATION_REPLY        = 16; {OBSOLETE}
   ADDRESS_MASK_REQUEST     = 17;
   ADDRESS_MASK_REPLY       = 18;

Type
   ICMP_Object = Object
                 Private
                    Function  B(var frame:pbyte):byte;
                    Function  GetByte(var frame:pbyte):byte;
                    Procedure AddByte(var frame:pbyte;bte:byte);

                 Public
                    Procedure SendICMP(ICMP_Type:byte;
                                       Code:byte;
                                       ID:word;
                                       DestIP:iptype);
                    Private
                       Constructor Init;
                       Destructor  Done;
                end;

var
  oICMP : ICMP_Object;

Implementation

Uses Checksum;

Constructor ICMP_Object.Init; {Nada}
Begin
end;

Destructor ICMP_Object.Done; {Nada}
Begin
end;

Function ICMP_Object.B(var frame:pbyte):byte;
Begin
  if frame<>nil then
  Begin
    b := frame^;
    inc(frame);
  end else b := 255;
end;

Function ICMP_Object.GetByte(var frame:pbyte):byte;
Begin
  GetByte := b(frame);
end;

Procedure ICMP_Object.AddByte(var frame:pbyte;bte:byte);
Begin
  frame^ := bte; inc(frame);
end;

Procedure ICMP_Object.SendICMP(ICMP_Type:byte;
                   Code:byte;
                   ID:word;
                   DestIP:iptype);
var
 fdata : pbyte;
 fdp : pbyte;
 csumptr : pbyte;
 x : word;
 csum : word;
 tick : longint;
Begin
 getmem(fdata,12);
 fdp := fdata;

 Addbyte(fdp,ICMP_type);
 Addbyte(fdp,code);
 csumptr := fdp;
 Addbyte(fdp,0);
 Addbyte(fdp,0);
 addbyte(fdp,id shr 8);
 addbyte(fdp,id and $00ff);
 addbyte(fdp,0);
 addbyte(fdp,0);
 tick := 0;
 addbyte(fdp,tick shr 24);
 addbyte(fdp,tick shr 16 and $00ff);
 addbyte(fdp,((tick shl 16) shr 16) shr 8);
 addbyte(fdp,((tick shl 16) shr 16) and $00ff);
 csum := not cksum(nil,fdata,12);
 csumptr^ := csum shr 8; inc(csumptr);
 csumptr^ := csum and $00ff; dec(csumptr);
 oIP.SendIP_Datagram(ID,oPPP.IPaddr,DestIP,ICMP_Protocol,12,fdata);
 freemem(fdata,12);
end;

Begin
  oICMP.Init;
end.

