{$DEFINE PPP}
{DEFINE DEBUG}
{DEFINE UDP}
{DEFINE TCP}
{DEFINE ICMP}

Unit IP;

Interface

{$IFDEF PPP} Uses PPP; {$ENDIF}

Type
   pIP = ^IP_Record;
   IP_Record = Record
                 VerLen       : byte;
                 TOS          : byte;
                 PacketLength : word;
                 ID           : word;
                 Flags        : byte;
                 FragmentOfs  : word;
                 TTL          : byte;
                 Protocol     : byte;
                 Checksum     : word;
                 SourceIP     : IPType;
                 DestIP       : IPType;

                 data         : pbyte;
                 data_ptr     : pbyte;
                 datasize     : word;

                 prev,next    : pIP;
               end;

   IP_Object = Object
                 Private
                    First_IP,
                    Last_IP,
                    Cur_IP  : pIP;

                    Function B(var frame:pbyte):byte;
                    Function GetByte(var frame:pbyte):byte;
                    Procedure AddByte(var frame:pbyte;bte:byte);

                 Public
                    Procedure AddIPFrame(frame:pFrame);
                    Procedure DisposeIPFrame(frame:pIP);
                    Procedure ProcessIPFrames;
                    Function PseudoIP(SourceIP:iptype;
                                       DestIP:iptype;
                                       Protocol:byte;
                                       datalength:word):pbyte;

                    Procedure SendIP_Datagram(ID:longint;
                                              SourceIP:iptype;
                                              DestIP:iptype;
                                              Protocol:byte;
                                              datalength:word;
                                              Data:pbyte);
                 Private
                    Constructor Init;
                    Destructor  Done;
                end;

Var
  oIP : IP_Object;

Implementation

Uses CHECKSUM, {Performs Internet Checksum}
     UDP,
     TCP,
     ICMP;

Constructor IP_Object.Init;
Begin
  first_ip := nil;
  last_ip := nil;
  cur_ip := nil;
end;

Destructor IP_Object.Done;
Begin
  while first_ip<>nil do disposeIPframe(first_ip);
end;

Function IP_Object.B(var frame:pbyte):byte;
Begin
  if frame<>nil then
  Begin
    b := frame^;
    inc(frame);
  end else b := 255;
end;

Function IP_Object.GetByte(var frame:pbyte):byte;
Begin
  GetByte := b(frame);
end;

Procedure IP_Object.AddByte(var frame:pbyte;bte:byte);
Begin
  frame^ := bte; inc(frame);
end;

Procedure IP_Object.SendIP_Datagram(ID:longint;
                                    SourceIP:iptype;
                                    DestIP:iptype;
                                    Protocol:byte;
                                    datalength:word;
                                    Data:pbyte);
var
 fdata : pbyte;
 fdp : pbyte;
 csumptr : pbyte;
 csum : word;
 x : word;
Begin
 getmem(fdata,20+datalength);
 fdp := fdata;
 Addbyte(fdp,69); {Ver 4, Headerlength 5    4 shl 4 + 5}
 Addbyte(fdp,0);  {throughput type of service}
 Addbyte(fdp,(datalength+20) shr 8);
 Addbyte(fdp,(datalength+20) and $00ff);
 Addbyte(fdp,id shr 8);
 Addbyte(fdp,id and $00ff);
 Addbyte(fdp,0); Addbyte(fdp,0); {Flags and Fragment offset}
 Addbyte(fdp,30); {Time to Live = 30}
 Addbyte(fdp,Protocol);
 csumptr := fdp; {hold checksum position in header}
 addbyte(fdp,0);
 addbyte(fdp,0);

 addbyte(fdp,SourceIP[1]);
 addbyte(fdp,SourceIP[2]);
 addbyte(fdp,SourceIP[3]);
 addbyte(fdp,SourceIP[4]);

 addbyte(fdp,DestIP[1]);
 addbyte(fdp,DestIP[2]);
 addbyte(fdp,DestIP[3]);
 addbyte(fdp,DestIP[4]);

 csum := cksum(nil,fdata,20) xor $ffff; {compute checksum}

 csumptr^ := csum shr 8; inc(csumptr); {insert checksum into header}
 csumptr^ := csum and $00ff; dec(csumptr);

 if datalength>0 then
 for x := 1 to datalength do
   Begin
     Addbyte(fdp,data^); inc(data);
   end;

 {$IFDEF PPP} oPPP.SendIP(20+datalength,fdata); {$ENDIF}

 freemem(fdata,20+datalength);
end;

Function IP_Object.PseudoIP(SourceIP:iptype;
                             DestIP:iptype;
                             Protocol:byte;
                             datalength:word) : pbyte;
var
 fdp : pbyte;
 fdata : pbyte;
Begin
 getmem(fdata,12);
 fdp := fdata;
 addbyte(fdp,SourceIP[1]);
 addbyte(fdp,SourceIP[2]);
 addbyte(fdp,SourceIP[3]);
 addbyte(fdp,SourceIP[4]);
 addbyte(fdp,DestIP[1]);
 addbyte(fdp,DestIP[2]);
 addbyte(fdp,DestIP[3]);
 addbyte(fdp,DestIP[4]);
 Addbyte(fdp,0);
 Addbyte(fdp,Protocol);
 Addbyte(fdp,datalength shr 8);
 Addbyte(fdp,datalength and $00ff);
 PseudoIP := fdata;
end;

Procedure IP_Object.AddIPFrame(frame:pFrame);
var
 lframe : pIP;
 tmp : word;
 x : byte;
 csum : word;
 tofs : pbyte;
Begin
  tofs := frame^.frame_ptr;
  new(lframe);
  lframe^.VerLen       := getbyte(frame^.frame_ptr);
  lframe^.TOS          := getbyte(frame^.frame_ptr);
  lframe^.PacketLength := getbyte(frame^.frame_ptr) shl 8;
  inc(lframe^.packetlength,getbyte(frame^.frame_ptr));
  lframe^.ID           := getbyte(frame^.frame_ptr) shl 8;
  inc(lframe^.id,getbyte(frame^.frame_ptr));
  tmp := getbyte(frame^.frame_ptr) shl 8;
  inc(tmp,getbyte(frame^.frame_ptr));
  lframe^.Flags        := tmp and 57344; {1st 3 bits}
  lframe^.FragmentOfs  := tmp and 8191; {last 13 bits}
  lframe^.TTL          := getbyte(frame^.frame_ptr);
  lframe^.Protocol     := getbyte(frame^.frame_ptr);
  lframe^.Checksum     := getbyte(frame^.frame_ptr) shl 8;
  inc(lframe^.checksum,getbyte(frame^.frame_ptr));
  for x := 1 to 4 do lframe^.SourceIP[x] := getbyte(frame^.frame_ptr);
  for x := 1 to 4 do lframe^.DestIP[x] := getbyte(frame^.frame_ptr);
  {$IFDEF DEBUG}
     writeln('IP FRAME DATA');
     writeln('-----------------------------------------------');
     writeln('VERLEN        : ',lframe^.verlen);
     writeln('TOS           : ',lframe^.tos);
     writeln('PACKET LENGTH : ',lframe^.packetlength);
     writeln('ID            : ',lframe^.id);
     writeln('Protocol      : ',lframe^.protocol);
     writeln('Source IP     : ',oPPP.ipstr(lframe^.sourceIP));
     writeln('Dest   IP     : ',oPPP.ipstr(lframe^.destIP));
     writeln('Checksum      : ',lframe^.checksum);
     writeln('-----------------------------------------------');
  {$ENDIF}

  lframe^.datasize := lframe^.packetlength-((lframe^.verlen and $0f) shl 2);
  lframe^.data := nil;
  if lframe^.datasize>0 then
    Begin
      getmem(lframe^.data,lframe^.datasize);
      move(frame^.frame_ptr^,lframe^.data^,lframe^.datasize);
    end;
  lframe^.data_ptr := lframe^.data;

  csum := cksum(nil,tofs,lframe^.packetlength);
  {$IFDEF DEBUG} writeln('CHECKSUM : ',csum); {$ENDIF}
  if (csum<65535) then
    Begin
      {if (lframe^.datasize>0) then freemem(lframe^.data,lframe^.datasize);
      dispose(lframe);}
      {$IFDEF DEBUG} writeln('INVALID CRC IN IP FRAME!'); {$ENDIF}
      {exit;}
    end;

  lframe^.prev := last_IP;
  last_ip := lframe;
  cur_ip := lframe;
  lframe^.next := nil;
  if first_ip=nil then first_ip := lframe;
  if lframe^.prev<>nil then lframe^.prev^.next := lframe;
  cur_ip:= lframe;
end;

Procedure IP_Object.DisposeIPFrame(frame:pIP);
Begin
  if frame=nil then exit;

  if frame=first_ip then first_ip := first_ip^.next;
  if frame=last_ip then last_ip := last_ip^.prev;
  if frame=cur_ip then cur_ip := cur_ip^.next;

  if frame^.prev<>nil then frame^.prev^.next := frame^.next;
  if frame^.next<>nil then frame^.next^.prev := frame^.prev;

  if frame^.datasize>0 then freemem(frame^.data,frame^.datasize);
  dispose(frame);
end;

Procedure IP_Object.ProcessIPFrames;
var
 this : pIP;
Begin
  this := first_ip;
  while this<>nil do
   Begin
     case this^.protocol of
       UDP_Protocol  : Begin
                         {$IFDEF UDP} writeln(' [UDP] '); {$ENDIF}
                         oUDP.AddUDPFrame(this);
                         DisposeIPFrame(this);
                         exit;
                       end;
       TCP_Protocol  : Begin
                         {$IFDEF TCP} writeln(' [TCP] '); {$ENDIF}
                         oTCP.AddTCPFrame(this);
                         DisposeIPFrame(this);
                         exit;
                       end;
       ICMP_Protocol : Begin
                         {$IFDEF ICMP} writeln(' [ICMP] '); {$ENDIF}
                         DisposeIPFrame(this);
                         exit;
                       end;
     end;
     this := this^.next;
   end;
end;

Begin
 oIP.Init;
end.


