unit jul_unit;
{ This unit allows you to convert a string date "mm/dd/yy" to a julian
  longint value which can then be used in date calculations.
  Example:

       TempLongInt:=str2jul('010193');  yields 2448989
       inc(TempLongInt);
       TempStr:=jul2str(TempLongInt);     yields '010293'
}
interface

function str2jul(DateStr:string): longint;
function jul2str(JulDate:longint) :string;
Function  Julian( Year, Month, Day : Word ) : LongInt;


implementation


Function  Julian( Year, Month, Day : Word ) : LongInt;
Var
   Temp, Answer : Real;
begin
   if (Year < 90) then Year := Year + 2000  { 2000-2090 }
     else if (Year < 100) then Year := Year + 1900; { 1990-1999 }
   Temp := int((Month-14.0) / 12.0);
   Answer := Day - 32075.0 +
           int(1461.0 * (Year + 4800.0 + Temp) / 4.0) +
           int(367.0 * (Month - 2.0 - Temp * 12.0) / 12.0) -
           int(3.0 * int((Year + 4900.0 + Temp) /100.0) / 4.0);
   Julian:=trunc(Answer);
end;


function str2jul(DateStr:string): longint;
var m,d,y,result:integer;
begin
  if length(datestr)=8 then
    Datestr := Datestr[1]+Datestr[2]+Datestr[4]+Datestr[5]+Datestr[7]+Datestr[8];
  if (length(DateStr)<>6) then str2jul:=-1 else
  begin
    m:=0;
    d:=0;
    y:=0;
    val(copy(DateStr,1,2),m,result);
    val(copy(DateStr,3,2),d,result);
    val(copy(DateStr,5,2),y,result);
    str2jul:=julian(y,m,d);
  end;
end;

function jul2str(JulDate:longint) :string;
Var
   Tmp_A, Tmp_B: Real;
   var y,m,d:word;
   tstr1,tstr2:string;
begin
  if (JulDate<=0) then jul2str:='' else
  begin
    Tmp_A := JulDate + 68569.0;
    Tmp_B := int(4.0 * Tmp_A / 146097.0);
    Tmp_A := Tmp_A - int((146097.0 * Tmp_B + 3.0) / 4.0);
    Y     := trunc(4000.0 * (Tmp_A + 1.0) / 1461001.0);
    Tmp_A := Tmp_A - int(1461.0 * Y / 4.0) + 31.0;
    M     := trunc (80.0 * Tmp_A / 2447.0);
    D     := trunc (Tmp_A - int(2447.0 * M / 80.0));
    Tmp_A := int (M / 11.0);
    M     := trunc (M + 2.0 - 12.0 * Tmp_A);
    Y     := trunc(100.0 * (Tmp_B - 49.0) + Y + Tmp_A) MOD 100;
    str(m,tstr1); tstr1:=copy('00'+tstr1,length(tstr1)+1,2);
    tstr2:=tstr1;
    str(d,tstr1); tstr1:=copy('00'+tstr1,length(tstr1)+1,2);
    tstr2:=tstr2+tstr1;
    str(y,tstr1); tstr1:=copy('00'+tstr1,length(tstr1)+1,2);
    jul2str:=tstr2+tstr1;
  end;
end;

Function LeapYear ( Year : Word ) : Boolean ;
Begin
   If (((Year MOD 4) = 0) and ((Year MOD 100) > 0))
   or (( Year MOD 400 ) = 0 )
   then LeapYear   :=  TRUE
   else LeapYear   :=  FALSE;
End;

end.